/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bitcoinj.core.Utils;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hash {
    private static final Logger log = LoggerFactory.getLogger(Hash.class);

    public static byte[] getSha256Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(data, 0, data.length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Could not create MessageDigest for hash. ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] getSha256Hash(String message) {
        return Hash.getSha256Hash(message.getBytes(Charsets.UTF_8));
    }

    public static byte[] getSha256Hash(Integer data) {
        return Hash.getSha256Hash(ByteBuffer.allocate(4).putInt(data).array());
    }

    public static byte[] getSha256Ripemd160hash(byte[] data) {
        return Utils.sha256hash160((byte[])data);
    }

    public static byte[] getRipemd160hash(byte[] data) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(data, 0, data.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

