/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

public class HavenoHelpFormatter
implements HelpFormatter {
    private final String fullName;
    private final String scriptName;
    private final String version;

    public HavenoHelpFormatter(String fullName, String scriptName, String version) {
        this.fullName = fullName;
        this.scriptName = scriptName;
        this.version = version;
    }

    public String format(Map<String, ? extends OptionDescriptor> descriptors) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s version %s\n\n", this.fullName, this.version));
        output.append(String.format("Usage: %s [options]\n\n", this.scriptName));
        output.append("Options:\n\n");
        for (Map.Entry<String, ? extends OptionDescriptor> entry : descriptors.entrySet()) {
            String optionName = entry.getKey();
            OptionDescriptor optionDesc = entry.getValue();
            if (optionDesc.representsNonOptions()) continue;
            output.append(String.format("%s\n", this.formatOptionSyntax(optionName, optionDesc)));
            output.append(String.format("%s\n", this.formatOptionDescription(optionDesc)));
        }
        return output.toString();
    }

    private String formatOptionSyntax(String optionName, OptionDescriptor optionDesc) {
        List defaultValues;
        StringBuilder result = new StringBuilder(String.format("  --%s", optionName));
        if (optionDesc.acceptsArguments()) {
            result.append(String.format("=<%s>", this.formatArgDescription(optionDesc)));
        }
        if ((defaultValues = optionDesc.defaultValues()).size() > 0) {
            result.append(String.format(" (default: %s)", this.formatDefaultValues(defaultValues)));
        }
        return result.toString();
    }

    private String formatArgDescription(OptionDescriptor optionDesc) {
        String argDescription = optionDesc.argumentDescription();
        if (argDescription.length() > 0) {
            return argDescription;
        }
        String typeIndicator = optionDesc.argumentTypeIndicator();
        if (typeIndicator == null) {
            return "value";
        }
        try {
            Class<?> type = Class.forName(typeIndicator);
            return type.isEnum() ? Arrays.stream(type.getEnumConstants()).map(Object::toString).collect(Collectors.joining("|")) : typeIndicator.substring(typeIndicator.lastIndexOf(46) + 1);
        }
        catch (ClassNotFoundException ex) {
            return typeIndicator;
        }
    }

    private Object formatDefaultValues(List<?> defaultValues) {
        return defaultValues.size() == 1 ? defaultValues.get(0) : defaultValues.toString();
    }

    private String formatOptionDescription(OptionDescriptor optionDesc) {
        StringBuilder output = new StringBuilder();
        String remainder = optionDesc.description().trim();
        while (remainder.length() > 72) {
            int idxFirstSpace = remainder.indexOf(32);
            int chunkLen = idxFirstSpace == -1 ? remainder.length() : Math.max(idxFirstSpace, 73);
            String chunk = remainder.substring(0, chunkLen);
            int idxLastSpace = chunk.lastIndexOf(32);
            int idxBreak = idxLastSpace > 0 ? idxLastSpace : chunk.length();
            String line = remainder.substring(0, idxBreak);
            output.append(this.formatLine(line));
            remainder = remainder.substring(chunk.length() - (chunk.length() - idxBreak)).trim();
        }
        if (remainder.length() > 0) {
            output.append(this.formatLine(remainder));
        }
        return output.toString();
    }

    private String formatLine(String line) {
        return String.format("        %s\n", line.trim());
    }
}

