/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import ch.qos.logback.classic.Logger;
import haveno.common.config.ConfigFileOption;
import haveno.common.config.ConfigFileReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ConfigFileEditor {
    private static final Logger log = (Logger)LoggerFactory.getLogger(ConfigFileEditor.class);
    private final File file;
    private final ConfigFileReader reader;

    public ConfigFileEditor(File file) {
        this.file = file;
        this.reader = new ConfigFileReader(file);
    }

    public void setOption(String name) {
        this.setOption(name, null);
    }

    public void setOption(String name, String arg) {
        this.tryCreate(this.file);
        List<String> lines = this.reader.getLines();
        try (PrintWriter writer = new PrintWriter(this.file);){
            boolean fileAlreadyContainsTargetOption = false;
            for (String line : lines) {
                if (ConfigFileOption.isOption(line)) {
                    ConfigFileOption existingOption = ConfigFileOption.parse(line);
                    if (existingOption.name.equals(name)) {
                        fileAlreadyContainsTargetOption = true;
                        if (!existingOption.arg.equals(arg)) {
                            ConfigFileOption newOption = new ConfigFileOption(name, arg);
                            writer.println(newOption);
                            log.warn("Overwrote existing config file option '{}' as '{}'", (Object)existingOption, (Object)newOption);
                            continue;
                        }
                    }
                }
                writer.println(line);
            }
            if (!fileAlreadyContainsTargetOption) {
                writer.println(new ConfigFileOption(name, arg));
            }
        }
        catch (FileNotFoundException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void clearOption(String name) {
        if (!this.file.exists()) {
            return;
        }
        List<String> lines = this.reader.getLines();
        try (PrintWriter writer = new PrintWriter(this.file);){
            for (String line : lines) {
                if (ConfigFileOption.isOption(line)) {
                    ConfigFileOption option = ConfigFileOption.parse(line);
                    if (option.name.equals(name)) {
                        log.warn("Cleared existing config file option '{}'", (Object)option);
                        continue;
                    }
                }
                writer.println(line);
            }
        }
        catch (FileNotFoundException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void tryCreate(File file) {
        try {
            if (file.createNewFile()) {
                log.info("Created config file '{}'", (Object)file);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

