/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import ch.qos.logback.classic.Level;
import com.google.common.base.Preconditions;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.CompositeOptionSet;
import haveno.common.config.ConfigException;
import haveno.common.config.ConfigFileReader;
import haveno.common.config.EnumValueConverter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import joptsimple.util.RegexMatcher;
import org.bitcoinj.core.NetworkParameters;

public class Config {
    public static final String HELP = "help";
    public static final String APP_NAME = "appName";
    public static final String USER_DATA_DIR = "userDataDir";
    public static final String APP_DATA_DIR = "appDataDir";
    public static final String CONFIG_FILE = "configFile";
    public static final String MAX_MEMORY = "maxMemory";
    public static final String LOG_LEVEL = "logLevel";
    public static final String BANNED_XMR_NODES = "bannedXmrNodes";
    public static final String BANNED_PRICE_RELAY_NODES = "bannedPriceRelayNodes";
    public static final String BANNED_SEED_NODES = "bannedSeedNodes";
    public static final String BASE_CURRENCY_NETWORK = "baseCurrencyNetwork";
    public static final String REFERRAL_ID = "referralId";
    public static final String USE_DEV_MODE = "useDevMode";
    public static final String USE_DEV_MODE_HEADER = "useDevModeHeader";
    public static final String TOR_DIR = "torDir";
    public static final String STORAGE_DIR = "storageDir";
    public static final String KEY_STORAGE_DIR = "keyStorageDir";
    public static final String WALLET_DIR = "walletDir";
    public static final String WALLET_RPC_BIND_PORT = "walletRpcBindPort";
    public static final String USE_DEV_PRIVILEGE_KEYS = "useDevPrivilegeKeys";
    public static final String DUMP_STATISTICS = "dumpStatistics";
    public static final String IGNORE_DEV_MSG = "ignoreDevMsg";
    public static final String PROVIDERS = "providers";
    public static final String SEED_NODES = "seedNodes";
    public static final String BAN_LIST = "banList";
    public static final String NODE_PORT = "nodePort";
    public static final String HIDDEN_SERVICE_ADDRESS = "hiddenServiceAddress";
    public static final String USE_LOCALHOST_FOR_P2P = "useLocalhostForP2P";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String SOCKS_5_PROXY_XMR_ADDRESS = "socks5ProxyXmrAddress";
    public static final String SOCKS_5_PROXY_HTTP_ADDRESS = "socks5ProxyHttpAddress";
    public static final String USE_TOR_FOR_XMR = "useTorForXmr";
    public static final String TORRC_FILE = "torrcFile";
    public static final String TORRC_OPTIONS = "torrcOptions";
    public static final String TOR_CONTROL_HOST = "torControlHost";
    public static final String TOR_CONTROL_PORT = "torControlPort";
    public static final String TOR_CONTROL_PASSWORD = "torControlPassword";
    public static final String TOR_CONTROL_COOKIE_FILE = "torControlCookieFile";
    public static final String TOR_CONTROL_USE_SAFE_COOKIE_AUTH = "torControlUseSafeCookieAuth";
    public static final String TOR_STREAM_ISOLATION = "torStreamIsolation";
    public static final String MSG_THROTTLE_PER_SEC = "msgThrottlePerSec";
    public static final String MSG_THROTTLE_PER_10_SEC = "msgThrottlePer10Sec";
    public static final String SEND_MSG_THROTTLE_TRIGGER = "sendMsgThrottleTrigger";
    public static final String SEND_MSG_THROTTLE_SLEEP = "sendMsgThrottleSleep";
    public static final String IGNORE_LOCAL_XMR_NODE = "ignoreLocalXmrNode";
    public static final String BITCOIN_REGTEST_HOST = "bitcoinRegtestHost";
    public static final String XMR_NODE = "xmrNode";
    public static final String XMR_NODE_USERNAME = "xmrNodeUsername";
    public static final String XMR_NODE_PASSWORD = "xmrNodePassword";
    public static final String XMR_NODES = "xmrNodes";
    public static final String USE_NATIVE_XMR_WALLET = "useNativeXmrWallet";
    public static final String SOCKS5_DISCOVER_MODE = "socks5DiscoverMode";
    public static final String USE_ALL_PROVIDED_NODES = "useAllProvidedNodes";
    public static final String USER_AGENT = "userAgent";
    public static final String NUM_CONNECTIONS_FOR_BTC = "numConnectionsForBtc";
    public static final String API_PASSWORD = "apiPassword";
    public static final String API_PORT = "apiPort";
    public static final String PREVENT_PERIODIC_SHUTDOWN_AT_SEED_NODE = "preventPeriodicShutdownAtSeedNode";
    public static final String REPUBLISH_MAILBOX_ENTRIES = "republishMailboxEntries";
    public static final String LEGACY_FEE_DATAMAP = "dataMap";
    public static final String BTC_TX_FEE = "btcTxFee";
    public static final String BTC_MIN_TX_FEE = "btcMinTxFee";
    public static final String BTC_FEES_TS = "bitcoinFeesTs";
    public static final String BTC_FEE_INFO = "bitcoinFeeInfo";
    public static final String BYPASS_MEMPOOL_VALIDATION = "bypassMempoolValidation";
    public static final String PASSWORD_REQUIRED = "passwordRequired";
    public static final String UPDATE_XMR_BINARIES = "updateXmrBinaries";
    public static final String XMR_BLOCKCHAIN_PATH = "xmrBlockchainPath";
    public static final String DISABLE_RATE_LIMITS = "disableRateLimits";
    public static final int UNSPECIFIED_PORT = -1;
    public static final String DEFAULT_REGTEST_HOST = "none";
    public static final int DEFAULT_NUM_CONNECTIONS_FOR_BTC = 9;
    static final String DEFAULT_CONFIG_FILE_NAME = "haveno.properties";
    private static File APP_DATA_DIR_VALUE;
    private static BaseCurrencyNetwork BASE_CURRENCY_NETWORK_VALUE;
    public final String defaultAppName;
    public final File defaultUserDataDir;
    public final File defaultAppDataDir;
    public final File defaultConfigFile;
    public final boolean helpRequested;
    public final File configFile;
    public final String appName;
    public final File userDataDir;
    public final File appDataDir;
    public final int walletRpcBindPort;
    public final int nodePort;
    public final String hiddenServiceAddress;
    public final int maxMemory;
    public final String logLevel;
    public final List<String> bannedXmrNodes;
    public final List<String> bannedPriceRelayNodes;
    public final List<String> bannedSeedNodes;
    public final BaseCurrencyNetwork baseCurrencyNetwork;
    public final NetworkParameters networkParameters;
    public final boolean ignoreLocalXmrNode;
    public final String bitcoinRegtestHost;
    public final String referralId;
    public final boolean useDevMode;
    public final boolean useDevModeHeader;
    public final boolean useDevPrivilegeKeys;
    public final boolean dumpStatistics;
    public final boolean ignoreDevMsg;
    public final List<String> providers;
    public final List<String> seedNodes;
    public final List<String> banList;
    public final boolean useLocalhostForP2P;
    public final int maxConnections;
    public final String socks5ProxyXmrAddress;
    public final String socks5ProxyHttpAddress;
    public final File torrcFile;
    public final String torrcOptions;
    public final String torControlHost;
    public final int torControlPort;
    public final String torControlPassword;
    public final File torControlCookieFile;
    public final boolean useTorControlSafeCookieAuth;
    public final boolean torStreamIsolation;
    public final int msgThrottlePerSec;
    public final int msgThrottlePer10Sec;
    public final int sendMsgThrottleTrigger;
    public final int sendMsgThrottleSleep;
    public final String xmrNode;
    public final String xmrNodeUsername;
    public final String xmrNodePassword;
    public final String xmrNodes;
    public final boolean useNativeXmrWallet;
    public final UseTorForXmr useTorForXmr;
    public final boolean useTorForXmrOptionSetExplicitly;
    public final String socks5DiscoverMode;
    public final boolean useAllProvidedNodes;
    public final String userAgent;
    public final int numConnectionsForBtc;
    public final String apiPassword;
    public final int apiPort;
    public final boolean preventPeriodicShutdownAtSeedNode;
    public final boolean republishMailboxEntries;
    public final boolean bypassMempoolValidation;
    public final boolean passwordRequired;
    public final boolean updateXmrBinaries;
    public final String xmrBlockchainPath;
    public final boolean disableRateLimits;
    public final File torDir;
    public final File walletDir;
    public final File storageDir;
    public final File keyStorageDir;
    private final OptionParser parser = new OptionParser();

    public Config(String ... args) {
        this(Config.randomAppName(), Config.tempUserDataDir(), args);
    }

    public Config(String defaultAppName, File defaultUserDataDir, String ... args) {
        this.defaultAppName = defaultAppName;
        this.defaultUserDataDir = defaultUserDataDir;
        this.defaultAppDataDir = new File(defaultUserDataDir, defaultAppName);
        this.defaultConfigFile = Config.absoluteConfigFile(this.defaultAppDataDir, DEFAULT_CONFIG_FILE_NAME);
        AbstractOptionSpec helpOpt = this.parser.accepts(HELP, "Print this help text").forHelp();
        ArgumentAcceptingOptionSpec configFileOpt = this.parser.accepts(CONFIG_FILE, String.format("Specify configuration file. Relative paths will be prefixed by %s location.", APP_DATA_DIR)).withRequiredArg().ofType(String.class).defaultsTo((Object)DEFAULT_CONFIG_FILE_NAME, (Object[])new String[0]);
        ArgumentAcceptingOptionSpec appNameOpt = this.parser.accepts(APP_NAME, "Application name").withRequiredArg().ofType(String.class).defaultsTo((Object)this.defaultAppName, (Object[])new String[0]);
        ArgumentAcceptingOptionSpec userDataDirOpt = this.parser.accepts(USER_DATA_DIR, "User data directory").withRequiredArg().ofType(File.class).defaultsTo((Object)this.defaultUserDataDir, (Object[])new File[0]);
        ArgumentAcceptingOptionSpec appDataDirOpt = this.parser.accepts(APP_DATA_DIR, "Application data directory").withRequiredArg().ofType(File.class).defaultsTo((Object)this.defaultAppDataDir, (Object[])new File[0]);
        ArgumentAcceptingOptionSpec nodePortOpt = this.parser.accepts(NODE_PORT, "Port to listen on").withRequiredArg().ofType(Integer.class).defaultsTo((Object)9999, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec hiddenServiceAddressOpt = this.parser.accepts(HIDDEN_SERVICE_ADDRESS, "Hidden Service Address to listen on").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec walletRpcBindPortOpt = this.parser.accepts(WALLET_RPC_BIND_PORT, "Port to bind the wallet RPC on").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxMemoryOpt = this.parser.accepts(MAX_MEMORY, "Max. permitted memory (used only by headless versions)").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)1200, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec logLevelOpt = this.parser.accepts(LOG_LEVEL, "Set logging level").withRequiredArg().ofType(String.class).describedAs("OFF|ALL|ERROR|WARN|INFO|DEBUG|TRACE").defaultsTo((Object)Level.INFO.levelStr, (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bannedXmrNodesOpt = this.parser.accepts(BANNED_XMR_NODES, "List Bitcoin nodes to ban").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec bannedPriceRelayNodesOpt = this.parser.accepts(BANNED_PRICE_RELAY_NODES, "List Haveno price nodes to ban").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec bannedSeedNodesOpt = this.parser.accepts(BANNED_SEED_NODES, "List Haveno seed nodes to ban").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec baseCurrencyNetworkOpt = this.parser.accepts(BASE_CURRENCY_NETWORK, "Base currency network").withRequiredArg().ofType(BaseCurrencyNetwork.class).withValuesConvertedBy((ValueConverter)new EnumValueConverter(BaseCurrencyNetwork.class)).defaultsTo((Object)BaseCurrencyNetwork.XMR_MAINNET, (Object[])new Enum[0]);
        ArgumentAcceptingOptionSpec ignoreLocalXmrNodeOpt = this.parser.accepts(IGNORE_LOCAL_XMR_NODE, "If set to true a Monero node running locally will be ignored").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec bitcoinRegtestHostOpt = this.parser.accepts(BITCOIN_REGTEST_HOST, "Bitcoin Core node when using XMR_STAGENET network").withRequiredArg().ofType(String.class).describedAs("host[:port]").defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec referralIdOpt = this.parser.accepts(REFERRAL_ID, "Optional Referral ID (e.g. for API users or pro market makers)").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec useDevModeOpt = this.parser.accepts(USE_DEV_MODE, "Enables dev mode which is used for convenience for developer testing").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec useDevModeHeaderOpt = this.parser.accepts(USE_DEV_MODE_HEADER, "Use dev mode css scheme to distinguish dev instances.").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec useDevPrivilegeKeysOpt = this.parser.accepts(USE_DEV_PRIVILEGE_KEYS, "If set to true all privileged features requiring a private key to be enabled are overridden by a dev key pair (This is for developers only!)").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec dumpStatisticsOpt = this.parser.accepts(DUMP_STATISTICS, "If set to true dump trade statistics to a json file in appDataDir").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec ignoreDevMsgOpt = this.parser.accepts(IGNORE_DEV_MSG, "If set to true all signed network_messages from haveno developers are ignored (Global alert, Version update alert, Filters for offers, nodes or trading account data)").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec providersOpt = this.parser.accepts(PROVIDERS, "List custom pricenodes").withRequiredArg().withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec seedNodesOpt = this.parser.accepts(SEED_NODES, "Override hard coded seed nodes as comma separated list e.g. 'rxdkppp3vicnbgqt.onion:8002,mfla72c4igh5ta2t.onion:8002'").withRequiredArg().withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec banListOpt = this.parser.accepts(BAN_LIST, "Nodes to exclude from network connections.").withRequiredArg().withValuesSeparatedBy(',').describedAs("host:port[,...]");
        ArgumentAcceptingOptionSpec useLocalhostForP2POpt = this.parser.accepts(USE_LOCALHOST_FOR_P2P, "Use localhost P2P network for development. Only available for non-XMR_MAINNET configuration.").availableIf(BASE_CURRENCY_NETWORK, new String[0]).withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec maxConnectionsOpt = this.parser.accepts(MAX_CONNECTIONS, "Max. connections a peer will try to keep").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)12, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec socks5ProxyXmrAddressOpt = this.parser.accepts(SOCKS_5_PROXY_XMR_ADDRESS, "A proxy address to be used for Bitcoin network.").withRequiredArg().describedAs("host:port").defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec socks5ProxyHttpAddressOpt = this.parser.accepts(SOCKS_5_PROXY_HTTP_ADDRESS, "A proxy address to be used for Http requests (should be non-Tor)").withRequiredArg().describedAs("host:port").defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec torrcFileOpt = this.parser.accepts(TORRC_FILE, "An existing torrc-file to be sourced for Tor. Note that torrc-entries, which are critical to Haveno's correct operation, cannot be overwritten.").withRequiredArg().describedAs("File").withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        ArgumentAcceptingOptionSpec torrcOptionsOpt = this.parser.accepts(TORRC_OPTIONS, "A list of torrc-entries to amend to Haveno's torrc. Note that torrc-entries, which are critical to Haveno's flawless operation, cannot be overwritten. [torrc options line, torrc option, ...]").withRequiredArg().withValuesConvertedBy(RegexMatcher.regex((String)"^([^\\s,]+\\s[^,]+,?\\s*)+$")).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec torControlHostOpt = this.parser.accepts(TOR_CONTROL_HOST, "The control hostname of an already running Tor service to be used by Haveno.").withRequiredArg().defaultsTo((Object)"127.0.0.1", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec torControlPortOpt = this.parser.accepts(TOR_CONTROL_PORT, "The control port of an already running Tor service to be used by Haveno.").availableUnless(TORRC_FILE, new String[]{TORRC_OPTIONS}).withRequiredArg().ofType(Integer.TYPE).describedAs("port").defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec torControlPasswordOpt = this.parser.accepts(TOR_CONTROL_PASSWORD, "The password for controlling the already running Tor service.").availableIf(TOR_CONTROL_PORT, new String[0]).withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec torControlCookieFileOpt = this.parser.accepts(TOR_CONTROL_COOKIE_FILE, "The cookie file for authenticating against the already running Tor service. Use in conjunction with --torControlUseSafeCookieAuth").availableIf(TOR_CONTROL_PORT, new String[0]).availableUnless(TOR_CONTROL_PASSWORD, new String[0]).withRequiredArg().describedAs("File").withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        OptionSpecBuilder torControlUseSafeCookieAuthOpt = this.parser.accepts(TOR_CONTROL_USE_SAFE_COOKIE_AUTH, "Use the SafeCookie method when authenticating to the already running Tor service.").availableIf(TOR_CONTROL_COOKIE_FILE, new String[0]);
        OptionSpecBuilder torStreamIsolationOpt = this.parser.accepts(TOR_STREAM_ISOLATION, "Use stream isolation for Tor [experimental!].");
        ArgumentAcceptingOptionSpec msgThrottlePerSecOpt = this.parser.accepts(MSG_THROTTLE_PER_SEC, "Message throttle per sec for connection class").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)200, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec msgThrottlePer10SecOpt = this.parser.accepts(MSG_THROTTLE_PER_10_SEC, "Message throttle per 10 sec for connection class").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)1000, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec sendMsgThrottleTriggerOpt = this.parser.accepts(SEND_MSG_THROTTLE_TRIGGER, "Time in ms when we trigger a sleep if 2 messages are sent").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)20, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec sendMsgThrottleSleepOpt = this.parser.accepts(SEND_MSG_THROTTLE_SLEEP, "Pause in ms to sleep if we get too many messages to send").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)50, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec xmrNodeOpt = this.parser.accepts(XMR_NODE, "URI of custom Monero node to use").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec xmrNodeUsernameOpt = this.parser.accepts(XMR_NODE_USERNAME, "Username of custom Monero node to use").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec xmrNodePasswordOpt = this.parser.accepts(XMR_NODE_PASSWORD, "Password of custom Monero node to use").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec xmrNodesOpt = this.parser.accepts(XMR_NODES, "Custom nodes used for Monero as comma separated IP addresses.").withRequiredArg().describedAs("ip[,...]").defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec useNativeXmrWalletOpt = this.parser.accepts(USE_NATIVE_XMR_WALLET, "Use native wallet libraries instead of monero-wallet-rpc server").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec useTorForXmrOpt = this.parser.accepts(USE_TOR_FOR_XMR, "Configure TOR for Monero connections, one of: after_sync, off, or on.").withRequiredArg().ofType(UseTorForXmr.class).withValuesConvertedBy((ValueConverter)new EnumValueConverter(UseTorForXmr.class)).defaultsTo((Object)UseTorForXmr.AFTER_SYNC, (Object[])new Enum[0]);
        ArgumentAcceptingOptionSpec socks5DiscoverModeOpt = this.parser.accepts(SOCKS5_DISCOVER_MODE, "Specify discovery mode for Bitcoin nodes. One or more of: [ADDR, DNS, ONION, ALL] (comma separated, they get OR'd together).").withRequiredArg().describedAs("mode[,...]").defaultsTo((Object)"ALL", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec useAllProvidedNodesOpt = this.parser.accepts(USE_ALL_PROVIDED_NODES, "Set to true if connection of bitcoin nodes should include clear net nodes").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec userAgentOpt = this.parser.accepts(USER_AGENT, "User agent at btc node connections").withRequiredArg().defaultsTo((Object)"Haveno", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec numConnectionsForBtcOpt = this.parser.accepts(NUM_CONNECTIONS_FOR_BTC, "Number of connections to the Bitcoin network").withRequiredArg().ofType(Integer.TYPE).defaultsTo((Object)9, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec apiPasswordOpt = this.parser.accepts(API_PASSWORD, "gRPC API password").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec apiPortOpt = this.parser.accepts(API_PORT, "gRPC API port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)9998, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec preventPeriodicShutdownAtSeedNodeOpt = this.parser.accepts(PREVENT_PERIODIC_SHUTDOWN_AT_SEED_NODE, "Prevents periodic shutdown at seed nodes").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec republishMailboxEntriesOpt = this.parser.accepts(REPUBLISH_MAILBOX_ENTRIES, "Republish mailbox messages at startup").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec bypassMempoolValidationOpt = this.parser.accepts(BYPASS_MEMPOOL_VALIDATION, "Prevents mempool check of trade parameters").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec passwordRequiredOpt = this.parser.accepts(PASSWORD_REQUIRED, "Requires a password for creating a Haveno account").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec updateXmrBinariesOpt = this.parser.accepts(UPDATE_XMR_BINARIES, "Update Monero binaries if applicable").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec xmrBlockchainPathOpt = this.parser.accepts(XMR_BLOCKCHAIN_PATH, "Path to Monero blockchain when using local Monero node").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec disableRateLimits = this.parser.accepts(DISABLE_RATE_LIMITS, "Disables all API rate limits").withRequiredArg().ofType(Boolean.TYPE).defaultsTo((Object)false, (Object[])new Boolean[0]);
        try {
            Optional<OptionSet> configFileOpts;
            CompositeOptionSet options = new CompositeOptionSet();
            OptionSet cliOpts = this.parser.parse(args);
            options.addOptionSet(cliOpts);
            this.parser.allowsUnrecognizedOptions();
            File configFile = null;
            OptionSpec[] disallowedOpts = new OptionSpec[]{helpOpt, configFileOpt};
            boolean cliHasConfigFileOpt = cliOpts.has((OptionSpec)configFileOpt);
            boolean configFileHasBeenProcessed = false;
            if (cliHasConfigFileOpt && (configFile = new File((String)cliOpts.valueOf((OptionSpec)configFileOpt))).isAbsolute() && (configFileOpts = this.parseOptionsFrom(configFile, disallowedOpts)).isPresent()) {
                options.addOptionSet(configFileOpts.get());
                configFileHasBeenProcessed = true;
            }
            this.appName = (String)options.valueOf(appNameOpt);
            this.userDataDir = (File)options.valueOf(userDataDirOpt);
            this.appDataDir = Config.mkAppDataDir(options.has((OptionSpec<?>)appDataDirOpt) ? (File)options.valueOf(appDataDirOpt) : new File(this.userDataDir, this.appName));
            if (!configFileHasBeenProcessed) {
                configFile = cliHasConfigFileOpt && !configFile.isAbsolute() ? Config.absoluteConfigFile(this.appDataDir, configFile.getPath()) : Config.absoluteConfigFile(this.appDataDir, DEFAULT_CONFIG_FILE_NAME);
                configFileOpts = this.parseOptionsFrom(configFile, disallowedOpts);
                configFileOpts.ifPresent(options::addOptionSet);
            }
            this.helpRequested = options.has((OptionSpec<?>)helpOpt);
            this.configFile = configFile;
            this.nodePort = (Integer)options.valueOf(nodePortOpt);
            this.hiddenServiceAddress = (String)options.valueOf(hiddenServiceAddressOpt);
            this.walletRpcBindPort = (Integer)options.valueOf(walletRpcBindPortOpt);
            this.maxMemory = (Integer)options.valueOf(maxMemoryOpt);
            this.logLevel = (String)options.valueOf(logLevelOpt);
            this.bannedXmrNodes = options.valuesOf((ArgumentAcceptingOptionSpec<String>)bannedXmrNodesOpt);
            this.bannedPriceRelayNodes = options.valuesOf((ArgumentAcceptingOptionSpec<String>)bannedPriceRelayNodesOpt);
            this.bannedSeedNodes = options.valuesOf((ArgumentAcceptingOptionSpec<String>)bannedSeedNodesOpt);
            this.baseCurrencyNetwork = (BaseCurrencyNetwork)((Object)options.valueOf(baseCurrencyNetworkOpt));
            this.networkParameters = this.baseCurrencyNetwork.getParameters();
            this.ignoreLocalXmrNode = (Boolean)options.valueOf(ignoreLocalXmrNodeOpt);
            this.bitcoinRegtestHost = (String)options.valueOf(bitcoinRegtestHostOpt);
            this.torrcFile = options.has((OptionSpec<?>)torrcFileOpt) ? ((Path)options.valueOf(torrcFileOpt)).toFile() : null;
            this.torrcOptions = (String)options.valueOf(torrcOptionsOpt);
            this.torControlHost = (String)options.valueOf(torControlHostOpt);
            this.torControlPort = (Integer)options.valueOf(torControlPortOpt);
            this.torControlPassword = (String)options.valueOf(torControlPasswordOpt);
            this.torControlCookieFile = options.has((OptionSpec<?>)torControlCookieFileOpt) ? ((Path)options.valueOf(torControlCookieFileOpt)).toFile() : null;
            this.useTorControlSafeCookieAuth = options.has((OptionSpec<?>)torControlUseSafeCookieAuthOpt);
            this.torStreamIsolation = options.has((OptionSpec<?>)torStreamIsolationOpt);
            this.referralId = (String)options.valueOf(referralIdOpt);
            this.useDevMode = (Boolean)options.valueOf(useDevModeOpt);
            this.useDevModeHeader = (Boolean)options.valueOf(useDevModeHeaderOpt);
            this.useDevPrivilegeKeys = (Boolean)options.valueOf(useDevPrivilegeKeysOpt);
            this.dumpStatistics = (Boolean)options.valueOf(dumpStatisticsOpt);
            this.ignoreDevMsg = (Boolean)options.valueOf(ignoreDevMsgOpt);
            this.providers = options.valuesOf((ArgumentAcceptingOptionSpec<String>)providersOpt);
            this.seedNodes = options.valuesOf((ArgumentAcceptingOptionSpec<String>)seedNodesOpt);
            this.banList = options.valuesOf((ArgumentAcceptingOptionSpec<String>)banListOpt);
            this.useLocalhostForP2P = !this.baseCurrencyNetwork.isMainnet() && (Boolean)options.valueOf(useLocalhostForP2POpt) != false;
            this.maxConnections = (Integer)options.valueOf(maxConnectionsOpt);
            this.socks5ProxyXmrAddress = (String)options.valueOf(socks5ProxyXmrAddressOpt);
            this.socks5ProxyHttpAddress = (String)options.valueOf(socks5ProxyHttpAddressOpt);
            this.msgThrottlePerSec = (Integer)options.valueOf(msgThrottlePerSecOpt);
            this.msgThrottlePer10Sec = (Integer)options.valueOf(msgThrottlePer10SecOpt);
            this.sendMsgThrottleTrigger = (Integer)options.valueOf(sendMsgThrottleTriggerOpt);
            this.sendMsgThrottleSleep = (Integer)options.valueOf(sendMsgThrottleSleepOpt);
            this.xmrNode = (String)options.valueOf(xmrNodeOpt);
            this.xmrNodeUsername = (String)options.valueOf(xmrNodeUsernameOpt);
            this.xmrNodePassword = (String)options.valueOf(xmrNodePasswordOpt);
            this.xmrNodes = (String)options.valueOf(xmrNodesOpt);
            this.useNativeXmrWallet = (Boolean)options.valueOf(useNativeXmrWalletOpt);
            this.useTorForXmr = (UseTorForXmr)((Object)options.valueOf(useTorForXmrOpt));
            this.useTorForXmrOptionSetExplicitly = options.has((OptionSpec<?>)useTorForXmrOpt);
            this.socks5DiscoverMode = (String)options.valueOf(socks5DiscoverModeOpt);
            this.useAllProvidedNodes = (Boolean)options.valueOf(useAllProvidedNodesOpt);
            this.userAgent = (String)options.valueOf(userAgentOpt);
            this.numConnectionsForBtc = (Integer)options.valueOf(numConnectionsForBtcOpt);
            this.apiPassword = (String)options.valueOf(apiPasswordOpt);
            this.apiPort = (Integer)options.valueOf(apiPortOpt);
            this.preventPeriodicShutdownAtSeedNode = (Boolean)options.valueOf(preventPeriodicShutdownAtSeedNodeOpt);
            this.republishMailboxEntries = (Boolean)options.valueOf(republishMailboxEntriesOpt);
            this.bypassMempoolValidation = (Boolean)options.valueOf(bypassMempoolValidationOpt);
            this.passwordRequired = (Boolean)options.valueOf(passwordRequiredOpt);
            this.updateXmrBinaries = (Boolean)options.valueOf(updateXmrBinariesOpt);
            this.xmrBlockchainPath = (String)options.valueOf(xmrBlockchainPathOpt);
            this.disableRateLimits = (Boolean)options.valueOf(disableRateLimits);
        }
        catch (OptionException ex) {
            throw new ConfigException("problem parsing option '%s': %s", ex.options().get(0), ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
        }
        File xmrNetworkDir = Config.mkdir(this.appDataDir, this.baseCurrencyNetwork.name().toLowerCase());
        this.keyStorageDir = Config.mkdir(xmrNetworkDir, "keys");
        this.storageDir = Config.mkdir(xmrNetworkDir, "db");
        this.torDir = Config.mkdir(xmrNetworkDir, "tor");
        this.walletDir = Config.mkdir(xmrNetworkDir, "wallet");
        APP_DATA_DIR_VALUE = this.appDataDir;
        BASE_CURRENCY_NETWORK_VALUE = this.baseCurrencyNetwork;
    }

    private static File absoluteConfigFile(File parentDir, String relativeConfigFilePath) {
        return new File(parentDir, relativeConfigFilePath);
    }

    private Optional<OptionSet> parseOptionsFrom(File configFile, OptionSpec<?>[] disallowedOpts) {
        if (!configFile.exists()) {
            if (!configFile.equals(Config.absoluteConfigFile(this.appDataDir, DEFAULT_CONFIG_FILE_NAME))) {
                throw new ConfigException("The specified config file '%s' does not exist.", configFile);
            }
            return Optional.empty();
        }
        ConfigFileReader configFileReader = new ConfigFileReader(configFile);
        String[] optionLines = configFileReader.getOptionLines().stream().map(o -> "--" + o).collect(Collectors.toList()).toArray(new String[0]);
        OptionSet configFileOpts = this.parser.parse(optionLines);
        for (OptionSpec<?> disallowedOpt : disallowedOpts) {
            if (!configFileOpts.has(disallowedOpt)) continue;
            throw new ConfigException("The '%s' option is disallowed in config files", disallowedOpt.options().get(0));
        }
        return Optional.of(configFileOpts);
    }

    public void printHelp(OutputStream sink, HelpFormatter formatter) {
        try {
            this.parser.formatHelpWith(formatter);
            this.parser.printHelpOn(sink);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String randomAppName() {
        try {
            File file = Files.createTempFile("Haveno", "Temp", new FileAttribute[0]).toFile();
            file.delete();
            return file.toPath().getFileName().toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static File tempUserDataDir() {
        try {
            return Files.createTempDirectory("HavenoTempUserData", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static File mkAppDataDir(File dir) {
        if (!dir.exists()) {
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(String.format("Application data directory '%s' could not be created", dir), ex);
            }
        }
        return dir;
    }

    private static File mkdir(File parent, String child) {
        File dir = new File(parent, child);
        if (!dir.exists()) {
            try {
                Files.createDirectory(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(String.format("Directory '%s' could not be created", dir), ex);
            }
        }
        return dir;
    }

    public static File appDataDir() {
        return (File)Preconditions.checkNotNull((Object)APP_DATA_DIR_VALUE, (Object)"The static appDataDir has not yet been assigned. A Config instance must be instantiated (usually by Guice) before calling this method.");
    }

    public static BaseCurrencyNetwork baseCurrencyNetwork() {
        return BASE_CURRENCY_NETWORK_VALUE;
    }

    public static NetworkParameters baseCurrencyNetworkParameters() {
        return BASE_CURRENCY_NETWORK_VALUE.getParameters();
    }

    static {
        BASE_CURRENCY_NETWORK_VALUE = BaseCurrencyNetwork.XMR_MAINNET;
    }

    public static enum UseTorForXmr {
        AFTER_SYNC,
        OFF,
        ON;

    }
}

