/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.app;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    public static final String VERSION = "1.2.2";
    public static final List<String> HISTORICAL_RESOURCE_FILE_VERSION_TAGS = Arrays.asList("0.0.1");
    public static final String P2P_NETWORK_VERSION = "A";
    public static final int LOCAL_DB_VERSION = 1;
    public static final int TRADE_PROTOCOL_VERSION = 3;
    private static String p2pMessageVersion;
    private static int BASE_CURRENCY_NETWORK;
    public static final byte COMPENSATION_REQUEST = 1;
    public static final byte REIMBURSEMENT_REQUEST = 1;
    public static final byte PROPOSAL = 1;
    public static final byte BLIND_VOTE = 1;
    public static final byte VOTE_REVEAL = 1;
    public static final byte LOCKUP = 1;
    public static final byte ASSET_LISTING_FEE = 1;
    public static final byte PROOF_OF_BURN = 1;

    public static int getMajorVersion(String version) {
        return Version.getSubVersion(version, 0);
    }

    public static int getMinorVersion(String version) {
        return Version.getSubVersion(version, 1);
    }

    public static int getPatchVersion(String version) {
        return Version.getSubVersion(version, 2);
    }

    public static boolean isNewVersion(String newVersion) {
        return Version.isNewVersion(newVersion, VERSION);
    }

    public static boolean isNewVersion(String newVersion, String currentVersion) {
        if (newVersion.equals(currentVersion)) {
            return false;
        }
        if (Version.getMajorVersion(newVersion) > Version.getMajorVersion(currentVersion)) {
            return true;
        }
        if (Version.getMajorVersion(newVersion) < Version.getMajorVersion(currentVersion)) {
            return false;
        }
        if (Version.getMinorVersion(newVersion) > Version.getMinorVersion(currentVersion)) {
            return true;
        }
        if (Version.getMinorVersion(newVersion) < Version.getMinorVersion(currentVersion)) {
            return false;
        }
        if (Version.getPatchVersion(newVersion) > Version.getPatchVersion(currentVersion)) {
            return true;
        }
        if (Version.getPatchVersion(newVersion) < Version.getPatchVersion(currentVersion)) {
            return false;
        }
        return false;
    }

    public static int compare(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        if (Version.getMajorVersion(version1) > Version.getMajorVersion(version2)) {
            return 1;
        }
        if (Version.getMajorVersion(version1) < Version.getMajorVersion(version2)) {
            return -1;
        }
        if (Version.getMinorVersion(version1) > Version.getMinorVersion(version2)) {
            return 1;
        }
        if (Version.getMinorVersion(version1) < Version.getMinorVersion(version2)) {
            return -1;
        }
        if (Version.getPatchVersion(version1) > Version.getPatchVersion(version2)) {
            return 1;
        }
        if (Version.getPatchVersion(version1) < Version.getPatchVersion(version2)) {
            return -1;
        }
        return 0;
    }

    private static int getSubVersion(String version, int index) {
        String[] split = version.split("\\.");
        Preconditions.checkArgument((split.length == 3 ? 1 : 0) != 0, (Object)("Version number must be in semantic version format (contain 2 '.'). version=" + version));
        return Integer.parseInt(split[index]);
    }

    public static String getP2PMessageVersion() {
        return p2pMessageVersion;
    }

    public static void setBaseCryptoNetworkId(int baseCryptoNetworkId) {
        BASE_CURRENCY_NETWORK = baseCryptoNetworkId;
        if (BASE_CURRENCY_NETWORK == 0) {
            p2pMessageVersion = "0A";
        }
        if (BASE_CURRENCY_NETWORK == 1) {
            p2pMessageVersion = "1A";
        }
        if (BASE_CURRENCY_NETWORK == 2) {
            p2pMessageVersion = "2A";
        }
    }

    public static int getBaseCurrencyNetwork() {
        return BASE_CURRENCY_NETWORK;
    }

    public static void printVersion() {
        log.info("Version{VERSION=1.2.2, P2P_NETWORK_VERSION=A, LOCAL_DB_VERSION=1, TRADE_PROTOCOL_VERSION=3, BASE_CURRENCY_NETWORK=" + BASE_CURRENCY_NETWORK + ", getP2PNetworkId()=" + Version.getP2PMessageVersion() + "}");
    }
}

