/*
 * Decompiled with CFR 0.152.
 */
package haveno.common;

import com.google.common.util.concurrent.MoreExecutors;
import haveno.common.FrameRateTimer;
import haveno.common.Timer;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserThread {
    private static final Logger log = LoggerFactory.getLogger(UserThread.class);
    private static Class<? extends Timer> timerClass;
    private static Executor executor;
    private static Thread USER_THREAD;

    public static void setTimerClass(Class<? extends Timer> timerClass) {
        UserThread.timerClass = timerClass;
    }

    public static void execute(Runnable command) {
        executor.execute(() -> {
            Executor executor = executor;
            synchronized (executor) {
                USER_THREAD = Thread.currentThread();
                command.run();
            }
        });
    }

    public static void await(Runnable command) {
        if (UserThread.isUserThread(Thread.currentThread())) {
            command.run();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            UserThread.execute(() -> {
                try {
                    command.run();
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isUserThread(Thread thread) {
        return thread == USER_THREAD;
    }

    public static Timer runAfterRandomDelay(Runnable runnable, long minDelayInSec, long maxDelayInSec) {
        return UserThread.runAfterRandomDelay(runnable, minDelayInSec, maxDelayInSec, TimeUnit.SECONDS);
    }

    public static Timer runAfterRandomDelay(Runnable runnable, long minDelay, long maxDelay, TimeUnit timeUnit) {
        return UserThread.runAfter(runnable, (long)new Random().nextInt((int)(maxDelay - minDelay)) + minDelay, timeUnit);
    }

    public static Timer runAfter(Runnable runnable, long delayInSec) {
        return UserThread.runAfter(runnable, delayInSec, TimeUnit.SECONDS);
    }

    public static Timer runAfter(Runnable runnable, long delay, TimeUnit timeUnit) {
        return UserThread.getTimer().runLater(Duration.ofMillis(timeUnit.toMillis(delay)), () -> UserThread.execute(runnable));
    }

    public static Timer runPeriodically(Runnable runnable, long intervalInSec) {
        return UserThread.runPeriodically(runnable, intervalInSec, TimeUnit.SECONDS);
    }

    public static Timer runPeriodically(Runnable runnable, long interval, TimeUnit timeUnit) {
        return UserThread.getTimer().runPeriodically(Duration.ofMillis(timeUnit.toMillis(interval)), () -> UserThread.execute(runnable));
    }

    private static Timer getTimer() {
        try {
            return timerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String message = "Could not instantiate timer bsTimerClass=" + String.valueOf(timerClass);
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public static Executor getExecutor() {
        return executor;
    }

    public static void setExecutor(Executor executor) {
        UserThread.executor = executor;
    }

    static {
        executor = MoreExecutors.directExecutor();
        timerClass = FrameRateTimer.class;
    }
}

