/*
 * Decompiled with CFR 0.152.
 */
package haveno.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static final Map<String, ExecutorService> EXECUTORS = new HashMap<String, ExecutorService>();
    private static final Map<String, Thread> THREADS = new HashMap<String, Thread>();
    private static final int POOL_SIZE = 10;
    private static final ExecutorService POOL = Executors.newFixedThreadPool(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> execute(Runnable command, String threadId) {
        Map<String, ExecutorService> map = EXECUTORS;
        synchronized (map) {
            if (!EXECUTORS.containsKey(threadId)) {
                EXECUTORS.put(threadId, Executors.newFixedThreadPool(1));
            }
            return EXECUTORS.get(threadId).submit(() -> {
                Map<String, Thread> map = THREADS;
                synchronized (map) {
                    THREADS.put(threadId, Thread.currentThread());
                }
                Thread.currentThread().setName(threadId);
                command.run();
            });
        }
    }

    public static void await(Runnable command, String threadId) {
        try {
            ThreadUtils.execute(command, threadId).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutDown(String threadId) {
        ThreadUtils.shutDown(threadId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown(String threadId, Long timeoutMs) {
        if (timeoutMs == null) {
            timeoutMs = Long.MAX_VALUE;
        }
        ExecutorService pool = null;
        Map<String, ExecutorService> map = EXECUTORS;
        synchronized (map) {
            pool = EXECUTORS.get(threadId);
        }
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            throw new RuntimeException(e);
        }
        finally {
            ThreadUtils.remove(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String threadId) {
        Map<String, Object> map = EXECUTORS;
        synchronized (map) {
            EXECUTORS.remove(threadId);
        }
        map = THREADS;
        synchronized (map) {
            THREADS.remove(threadId);
        }
    }

    public static Future<?> submitToPool(Runnable task) {
        return ThreadUtils.submitToPool(Arrays.asList(task)).get(0);
    }

    public static List<Future<?>> submitToPool(List<Runnable> tasks) {
        ArrayList futures = new ArrayList();
        for (Runnable task : tasks) {
            futures.add(POOL.submit(task));
        }
        return futures;
    }

    public static Future<?> awaitTask(Runnable task) {
        return ThreadUtils.awaitTask(task, null);
    }

    public static Future<?> awaitTask(Runnable task, Long timeoutMs) {
        return ThreadUtils.awaitTasks(Arrays.asList(task), 1, timeoutMs).get(0);
    }

    public static List<Future<?>> awaitTasks(Collection<Runnable> tasks) {
        return ThreadUtils.awaitTasks(tasks, tasks.size());
    }

    public static List<Future<?>> awaitTasks(Collection<Runnable> tasks, int maxConcurrency) {
        return ThreadUtils.awaitTasks(tasks, maxConcurrency, null);
    }

    public static List<Future<?>> awaitTasks(Collection<Runnable> tasks, int maxConcurrency, Long timeoutMs) {
        if (timeoutMs == null) {
            timeoutMs = Long.MAX_VALUE;
        }
        if (tasks.isEmpty()) {
            return new ArrayList();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(tasks.size());
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (Runnable runnable : tasks) {
                futures.add(executorService.submit(runnable, null));
            }
            for (Future future : futures) {
                future.get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            ArrayList<Future<Object>> arrayList = futures;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCurrentThread(Thread thread, String threadId) {
        Map<String, Thread> map = THREADS;
        synchronized (map) {
            if (!THREADS.containsKey(threadId)) {
                return false;
            }
            return thread == THREADS.get(threadId);
        }
    }
}

