/*
 * Decompiled with CFR 0.152.
 */
package haveno.common;

import haveno.common.UserThread;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTimer {
    private static final Logger log = LoggerFactory.getLogger(MasterTimer.class);
    private static final Timer timer = new Timer();
    public static final long FRAME_INTERVAL_MS = 100L;
    private static final Set<Runnable> listeners;

    public static void addListener(Runnable runnable) {
        listeners.add(runnable);
    }

    public static void removeListener(Runnable runnable) {
        listeners.remove(runnable);
    }

    static {
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                UserThread.execute(() -> listeners.forEach(Runnable::run));
            }
        }, 100L, 100L);
        listeners = new CopyOnWriteArraySet<Runnable>();
    }
}

