/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;

public class TronAddressValidator
implements AddressValidator {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final byte MAINNET_PREFIX = 65;

    @Override
    public AddressValidationResult validate(String address) {
        if (!TronAddressValidator.isValidTronAddress(address)) {
            return AddressValidationResult.invalidStructure();
        }
        return AddressValidationResult.validAddress();
    }

    private static boolean isValidTronAddress(String address) {
        byte[] calculatedChecksum;
        if (address == null || address.length() != 34) {
            return false;
        }
        byte[] decoded = TronAddressValidator.decodeBase58(address);
        if (decoded == null || decoded.length != 25) {
            return false;
        }
        byte[] data = Arrays.copyOfRange(decoded, 0, 21);
        byte[] checksum = Arrays.copyOfRange(decoded, 21, 25);
        if (!Arrays.equals(checksum, calculatedChecksum = Arrays.copyOfRange(TronAddressValidator.doubleSHA256(data), 0, 4))) {
            return false;
        }
        return data[0] == 65;
    }

    private static byte[] decodeBase58(String input) {
        BigInteger num = BigInteger.ZERO;
        BigInteger base = BigInteger.valueOf(58L);
        for (char c : input.toCharArray()) {
            int digit = BASE58_ALPHABET.indexOf(c);
            if (digit < 0) {
                return null;
            }
            num = num.multiply(base).add(BigInteger.valueOf(digit));
        }
        byte[] bytes = num.toByteArray();
        if (bytes.length > 1 && bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        int leadingZeros = 0;
        for (char c : input.toCharArray()) {
            if (c != '1') break;
            ++leadingZeros;
        }
        byte[] result = new byte[leadingZeros + bytes.length];
        System.arraycopy(bytes, 0, result, leadingZeros, bytes.length);
        return result;
    }

    private static byte[] doubleSHA256(byte[] data) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            return sha256.digest(sha256.digest(data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

