/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import java.math.BigInteger;

public class SolanaAddressValidator
implements AddressValidator {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";

    @Override
    public AddressValidationResult validate(String address) {
        if (!SolanaAddressValidator.isValidSolanaAddress(address)) {
            return AddressValidationResult.invalidStructure();
        }
        return AddressValidationResult.validAddress();
    }

    private static boolean isValidSolanaAddress(String address) {
        if (address == null) {
            return false;
        }
        if (address.length() < 32 || address.length() > 44) {
            return false;
        }
        for (char c : address.toCharArray()) {
            if (BASE58_ALPHABET.indexOf(c) != -1) continue;
            return false;
        }
        byte[] decoded = SolanaAddressValidator.decodeBase58(address);
        return decoded != null && decoded.length == 32;
    }

    private static byte[] decodeBase58(String input) {
        BigInteger num = BigInteger.ZERO;
        BigInteger base = BigInteger.valueOf(58L);
        for (char c : input.toCharArray()) {
            int digit = BASE58_ALPHABET.indexOf(c);
            if (digit < 0) {
                return null;
            }
            num = num.multiply(base).add(BigInteger.valueOf(digit));
        }
        byte[] bytes = num.toByteArray();
        if (bytes.length > 1 && bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            bytes = tmp;
        }
        int leadingZeros = 0;
        for (char c : input.toCharArray()) {
            if (c != '1') break;
            ++leadingZeros;
        }
        byte[] result = new byte[leadingZeros + bytes.length];
        System.arraycopy(bytes, 0, result, leadingZeros, bytes.length);
        return result;
    }
}

