/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;

public class RegexAddressValidator
implements AddressValidator {
    private final String regex;
    private final String errorMessageI18nKey;

    public RegexAddressValidator(String regex) {
        this(regex, null);
    }

    public RegexAddressValidator(String regex, String errorMessageI18nKey) {
        this.regex = regex;
        this.errorMessageI18nKey = errorMessageI18nKey;
    }

    @Override
    public AddressValidationResult validate(String address) {
        if (!address.matches(this.regex)) {
            if (this.errorMessageI18nKey == null) {
                return AddressValidationResult.invalidStructure();
            }
            return AddressValidationResult.invalidAddress("", this.errorMessageI18nKey);
        }
        return AddressValidationResult.validAddress();
    }
}

