/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import org.bitcoinj.core.Utils;

public class CryptoNoteUtils {
    public static String getRawSpendKeyAndViewKey(String address) throws CryptoNoteException {
        try {
            byte[] decoded = MoneroBase58.decode(address);
            if (decoded.length <= 65) {
                throw new CryptoNoteException("The address we received is too short. address=" + address);
            }
            if (decoded.length != 69 && decoded.length != 77) {
                System.out.println("The address we received is not in the expected format. address=" + address);
            }
            byte[] slice = Arrays.copyOfRange(decoded, 1, 65);
            return Utils.HEX.encode(slice);
        }
        catch (CryptoNoteException e) {
            throw new CryptoNoteException(e);
        }
    }

    static class MoneroBase58 {
        private static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        private static final BigInteger ALPHABET_SIZE = BigInteger.valueOf("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".length());
        private static final int FULL_DECODED_BLOCK_SIZE = 8;
        private static final int FULL_ENCODED_BLOCK_SIZE = 11;
        private static final BigInteger UINT64_MAX = new BigInteger("18446744073709551615");
        private static final Map<Integer, Integer> DECODED_CHUNK_LENGTH = Map.of(2, 1, 3, 2, 5, 3, 6, 4, 7, 5, 9, 6, 10, 7, 11, 8);

        MoneroBase58() {
        }

        private static void decodeChunk(String input, int inputOffset, int inputLength, byte[] decoded, int decodedOffset, int decodedLength) throws CryptoNoteException {
            BigInteger result = BigInteger.ZERO;
            BigInteger order = BigInteger.ONE;
            int index = inputOffset + inputLength;
            while (index != inputOffset) {
                char character;
                int digit;
                if ((digit = ALPHABET.indexOf(character = input.charAt(--index))) == -1) {
                    throw new CryptoNoteException("invalid character " + character);
                }
                if ((result = result.add(order.multiply(BigInteger.valueOf(digit)))).compareTo(UINT64_MAX) > 0) {
                    throw new CryptoNoteException("64-bit unsigned integer overflow " + result.toString());
                }
                order = order.multiply(ALPHABET_SIZE);
            }
            BigInteger maxCapacity = BigInteger.ONE.shiftLeft(8 * decodedLength);
            if (result.compareTo(maxCapacity) >= 0) {
                throw new CryptoNoteException("capacity overflow " + result.toString());
            }
            int index2 = decodedOffset + decodedLength;
            while (index2 != decodedOffset) {
                decoded[--index2] = result.byteValue();
                result = result.shiftRight(8);
            }
        }

        public static byte[] decode(String input) throws CryptoNoteException {
            if (input.length() == 0) {
                return new byte[0];
            }
            int chunks = input.length() / 11;
            int lastEncodedSize = input.length() % 11;
            int lastChunkSize = lastEncodedSize > 0 ? DECODED_CHUNK_LENGTH.get(lastEncodedSize) : 0;
            byte[] result = new byte[chunks * 8 + lastChunkSize];
            int inputOffset = 0;
            int resultOffset = 0;
            int chunk = 0;
            while (chunk < chunks) {
                MoneroBase58.decodeChunk(input, inputOffset, 11, result, resultOffset, 8);
                ++chunk;
                inputOffset += 11;
                resultOffset += 8;
            }
            if (lastChunkSize > 0) {
                MoneroBase58.decodeChunk(input, inputOffset, lastEncodedSize, result, resultOffset, lastChunkSize);
            }
            return result;
        }

        private static long readVarInt(ByteBuffer buffer) {
            long result = 0L;
            int shift = 0;
            while (true) {
                byte current = buffer.get();
                result += ((long)current & 0x7FL) << shift;
                if (((long)current & 0x80L) == 0L) break;
                shift += 7;
            }
            return result;
        }

        static long decodeAddress(String address, boolean validateChecksum) throws CryptoNoteException {
            int expected;
            int checksumSize;
            byte[] decoded = MoneroBase58.decode(address);
            if (decoded.length < (checksumSize = 4)) {
                throw new CryptoNoteException("invalid length");
            }
            ByteBuffer decodedAddress = ByteBuffer.wrap(decoded, 0, decoded.length - checksumSize);
            long prefix = MoneroBase58.readVarInt(decodedAddress.slice());
            if (!validateChecksum) {
                return prefix;
            }
            ByteBuffer fastHash = Keccak.keccak1600(decodedAddress.slice());
            int checksum = fastHash.getInt();
            if (checksum != (expected = ByteBuffer.wrap(decoded, decoded.length - checksumSize, checksumSize).getInt())) {
                throw new CryptoNoteException(String.format("invalid checksum %08X, expected %08X", checksum, expected));
            }
            return prefix;
        }
    }

    public static class CryptoNoteException
    extends Exception {
        CryptoNoteException(String msg) {
            super(msg);
        }

        public CryptoNoteException(CryptoNoteException exception) {
            super(exception);
        }
    }

    static class Keccak {
        private static final int BLOCK_SIZE = 136;
        private static final int LONGS_PER_BLOCK = 17;
        private static final int KECCAK_ROUNDS = 24;
        private static final long[] KECCAKF_RNDC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
        private static final int[] KECCAKF_ROTC = new int[]{1, 3, 6, 10, 15, 21, 28, 36, 45, 55, 2, 14, 27, 41, 56, 8, 25, 43, 62, 18, 39, 61, 20, 44};
        private static final int[] KECCAKF_PILN = new int[]{10, 7, 11, 17, 18, 3, 5, 16, 8, 21, 24, 4, 15, 23, 19, 13, 12, 2, 20, 14, 22, 9, 6, 1};

        Keccak() {
        }

        private static long rotateLeft(long value, int shift) {
            return value << shift | value >>> 64 - shift;
        }

        private static void keccakf(long[] st, int rounds) {
            long[] bc = new long[5];
            for (int round = 0; round < rounds; ++round) {
                int j;
                int i;
                for (i = 0; i < 5; ++i) {
                    bc[i] = st[i] ^ st[i + 5] ^ st[i + 10] ^ st[i + 15] ^ st[i + 20];
                }
                for (i = 0; i < 5; ++i) {
                    long t = bc[(i + 4) % 5] ^ Keccak.rotateLeft(bc[(i + 1) % 5], 1);
                    for (j = 0; j < 25; j += 5) {
                        int n = j + i;
                        st[n] = st[n] ^ t;
                    }
                }
                long t = st[1];
                for (int i2 = 0; i2 < 24; ++i2) {
                    j = KECCAKF_PILN[i2];
                    bc[0] = st[j];
                    st[j] = Keccak.rotateLeft(t, KECCAKF_ROTC[i2]);
                    t = bc[0];
                }
                for (int j2 = 0; j2 < 25; j2 += 5) {
                    int i3;
                    for (i3 = 0; i3 < 5; ++i3) {
                        bc[i3] = st[j2 + i3];
                    }
                    for (i3 = 0; i3 < 5; ++i3) {
                        int n = j2 + i3;
                        st[n] = st[n] ^ (bc[(i3 + 1) % 5] ^ 0xFFFFFFFFFFFFFFFFL) & bc[(i3 + 2) % 5];
                    }
                }
                st[0] = st[0] ^ KECCAKF_RNDC[round];
            }
        }

        static ByteBuffer keccak1600(ByteBuffer input) {
            input.order(ByteOrder.LITTLE_ENDIAN);
            int fullBlocks = input.remaining() / 136;
            long[] st = new long[25];
            for (int block = 0; block < fullBlocks; ++block) {
                int index = 0;
                while (index < 17) {
                    int n = index++;
                    st[n] = st[n] ^ input.getLong();
                }
                Keccak.keccakf(st, 24);
            }
            ByteBuffer lastBlock = ByteBuffer.allocate(144).order(ByteOrder.LITTLE_ENDIAN);
            lastBlock.put(input);
            lastBlock.put((byte)1);
            int paddingOffset = 135;
            lastBlock.put(paddingOffset, (byte)(lastBlock.get(paddingOffset) | 0x80));
            lastBlock.rewind();
            int index = 0;
            while (index < 17) {
                int n = index++;
                st[n] = st[n] ^ lastBlock.getLong();
            }
            Keccak.keccakf(st, 24);
            ByteBuffer result = ByteBuffer.allocate(32);
            result.slice().order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(st, 0, 4);
            return result;
        }
    }
}

