/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import haveno.asset.CryptoNoteUtils;

public class CryptoNoteAddressValidator
implements AddressValidator {
    private final long[] validPrefixes;
    private final boolean validateChecksum;

    public CryptoNoteAddressValidator(boolean validateChecksum, long ... validPrefixes) {
        this.validPrefixes = validPrefixes;
        this.validateChecksum = validateChecksum;
    }

    public CryptoNoteAddressValidator(long ... validPrefixes) {
        this(true, validPrefixes);
    }

    @Override
    public AddressValidationResult validate(String address) {
        try {
            long prefix = CryptoNoteUtils.MoneroBase58.decodeAddress(address, this.validateChecksum);
            for (long validPrefix : this.validPrefixes) {
                if (prefix != validPrefix) continue;
                return AddressValidationResult.validAddress();
            }
            return AddressValidationResult.invalidAddress(String.format("invalid address prefix %x", prefix));
        }
        catch (Exception e) {
            return AddressValidationResult.invalidStructure();
        }
    }
}

