/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.RegexAddressValidator;

public class CardanoAddressValidator
extends RegexAddressValidator {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final int BECH32_CONST = 1;
    private static final int BECH32M_CONST = 734539939;
    private static final int MAX_LEN = 104;

    public CardanoAddressValidator() {
        super("^addr1[0-9a-z]{20,98}$");
    }

    public CardanoAddressValidator(String errorMessageI18nKey) {
        super("^addr1[0-9a-z]{20,98}$", errorMessageI18nKey);
    }

    @Override
    public AddressValidationResult validate(String address) {
        if (!CardanoAddressValidator.isValidShelleyMainnet(address)) {
            return AddressValidationResult.invalidStructure();
        }
        return super.validate(address);
    }

    private static boolean isValidShelleyMainnet(String addr) {
        if (addr == null) {
            return false;
        }
        String lower = addr.toLowerCase();
        if (!lower.startsWith("addr1") || lower.length() > 104) {
            return false;
        }
        int sep = lower.lastIndexOf(49);
        if (sep < 1) {
            return false;
        }
        String hrp = lower.substring(0, sep);
        if (!"addr".equals(hrp)) {
            return false;
        }
        String dataPart = lower.substring(sep + 1);
        if (dataPart.length() < 6) {
            return false;
        }
        int[] data = new int[dataPart.length()];
        for (int i = 0; i < dataPart.length(); ++i) {
            int v = CHARSET.indexOf(dataPart.charAt(i));
            if (v == -1) {
                return false;
            }
            data[i] = v;
        }
        int[] hrpExp = CardanoAddressValidator.hrpExpand(hrp);
        int[] combined = new int[hrpExp.length + data.length];
        System.arraycopy(hrpExp, 0, combined, 0, hrpExp.length);
        System.arraycopy(data, 0, combined, hrpExp.length, data.length);
        int chk = CardanoAddressValidator.polymod(combined);
        return chk == 1 || chk == 734539939;
    }

    private static int[] hrpExpand(String hrp) {
        int[] ret = new int[hrp.length() * 2 + 1];
        int idx = 0;
        for (char c : hrp.toCharArray()) {
            ret[idx++] = c >> 5;
        }
        ret[idx++] = 0;
        for (char c : hrp.toCharArray()) {
            ret[idx++] = c & 0x1F;
        }
        return ret;
    }

    private static int polymod(int[] values) {
        int chk = 1;
        int[] GEN = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
        for (int v : values) {
            int b = chk >>> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ v;
            for (int i = 0; i < 5; ++i) {
                if ((b >>> i & 1) == 0) continue;
                chk ^= GEN[i];
            }
        }
        return chk;
    }
}

