/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.File;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlConnection;
import org.berndpruenster.netlayer.tor.Control;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorController;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor;", "Lorg/berndpruenster/netlayer/tor/Tor;", "controlPort", "", "(I)V", "controlHost", "", "(Ljava/lang/String;I)V", "password", "(ILjava/lang/String;)V", "(Ljava/lang/String;ILjava/lang/String;)V", "cookieFile", "Ljava/io/File;", "useSafeCookieAuthentication", "", "(ILjava/io/File;Z)V", "(Ljava/lang/String;ILjava/io/File;Z)V", "EVENTS", "", "getEVENTS", "()Ljava/util/List;", "connect", "", "authenticator", "Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "preprocessHsDirName", "hsDirName", "shutdown", "Authenticator", "CookieAuthenticator", "NullAuthenticator", "PasswordAuthenticator", "SafeCookieAuthenticator", "tor.external"})
public final class ExternalTor
extends Tor {
    @NotNull
    private final List<String> EVENTS;
    private final String controlHost;

    @NotNull
    public final List<String> getEVENTS() {
        return this.EVENTS;
    }

    private final void connect(int controlPort, Authenticator authenticator) {
        Socket sock = new Socket(this.controlHost, controlPort);
        this.setTorController(new TorController(sock));
        authenticator.authenticate(this.getTorController());
        this.getTorController().setEventHandler((EventHandler)this.getEventHandler());
        this.getTorController().setEvents(this.EVENTS);
        this.setControl(new Control(this.getTorController()));
    }

    @NotNull
    public File preprocessHsDirName(@NotNull String hsDirName) {
        Intrinsics.checkParameterIsNotNull((Object)hsDirName, (String)"hsDirName");
        return new File(hsDirName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Control control = this.getControl();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (control) {
            boolean bl3 = false;
            while (true) {
                Collection collection = this.getActiveHiddenServices();
                boolean bl4 = false;
                if (!(!collection.isEmpty())) break;
                Object e = this.getActiveHiddenServices().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"activeHiddenServices[0]");
                this.unpublishHiddenService((String)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public ExternalTor(int controlPort) throws TorCtlException {
        this("127.0.0.1", controlPort);
    }

    public ExternalTor(@NotNull String controlHost, int controlPort) throws TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)controlHost, (String)"controlHost");
        this.EVENTS = CollectionsKt.listOf((Object[])new String[]{"CIRC", "WARN", "ERR"});
        this.controlHost = controlHost;
        this.connect(controlPort, new NullAuthenticator());
    }

    public ExternalTor(int controlPort, @NotNull String password) throws TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this("127.0.0.1", controlPort, password);
    }

    public ExternalTor(@NotNull String controlHost, int controlPort, @NotNull String password) throws TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)controlHost, (String)"controlHost");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.EVENTS = CollectionsKt.listOf((Object[])new String[]{"CIRC", "WARN", "ERR"});
        this.controlHost = controlHost;
        this.connect(controlPort, new PasswordAuthenticator(password));
    }

    public ExternalTor(int controlPort, @NotNull File cookieFile, boolean useSafeCookieAuthentication) throws TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)cookieFile, (String)"cookieFile");
        this("127.0.0.1", controlPort, cookieFile, useSafeCookieAuthentication);
    }

    public /* synthetic */ ExternalTor(int n, File file, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) throws TorCtlException {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, file, bl);
    }

    public ExternalTor(@NotNull String controlHost, int controlPort, @NotNull File cookieFile, boolean useSafeCookieAuthentication) throws TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)controlHost, (String)"controlHost");
        Intrinsics.checkParameterIsNotNull((Object)cookieFile, (String)"cookieFile");
        this.EVENTS = CollectionsKt.listOf((Object[])new String[]{"CIRC", "WARN", "ERR"});
        this.controlHost = controlHost;
        if (useSafeCookieAuthentication) {
            this.connect(controlPort, new SafeCookieAuthenticator(cookieFile));
        } else {
            this.connect(controlPort, new CookieAuthenticator(cookieFile));
        }
    }

    public /* synthetic */ ExternalTor(String string, int n, File file, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) throws TorCtlException {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(string, n, file, bl);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "", "()V", "authenticate", "", "controlConnection", "Lorg/berndpruenster/netlayer/tor/TorController;", "tor.external"})
    private static abstract class Authenticator {
        public abstract void authenticate(@NotNull TorController var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor$NullAuthenticator;", "Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "()V", "authenticate", "", "controlConnection", "Lorg/berndpruenster/netlayer/tor/TorController;", "tor.external"})
    private static final class NullAuthenticator
    extends Authenticator {
        @Override
        public void authenticate(@NotNull TorController controlConnection) {
            Intrinsics.checkParameterIsNotNull((Object)controlConnection, (String)"controlConnection");
            controlConnection.authenticate(new byte[0]);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor$PasswordAuthenticator;", "Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "password", "", "(Ljava/lang/String;)V", "authenticate", "", "controlConnection", "Lorg/berndpruenster/netlayer/tor/TorController;", "tor.external"})
    private static final class PasswordAuthenticator
    extends Authenticator {
        private final String password;

        @Override
        public void authenticate(@NotNull TorController controlConnection) {
            Intrinsics.checkParameterIsNotNull((Object)controlConnection, (String)"controlConnection");
            String string = this.password;
            TorController torController = controlConnection;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            torController.authenticate(byArray2);
        }

        public PasswordAuthenticator(@NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.password = password;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor$CookieAuthenticator;", "Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "cookieFile", "Ljava/io/File;", "(Ljava/io/File;)V", "authenticate", "", "controlConnection", "Lorg/berndpruenster/netlayer/tor/TorController;", "tor.external"})
    private static final class CookieAuthenticator
    extends Authenticator {
        private final File cookieFile;

        @Override
        public void authenticate(@NotNull TorController controlConnection) {
            Intrinsics.checkParameterIsNotNull((Object)controlConnection, (String)"controlConnection");
            byte[] cookie = null;
            try {
                cookie = FilesKt.readBytes((File)this.cookieFile);
                controlConnection.authenticate(cookie);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw (Throwable)e;
            }
        }

        public CookieAuthenticator(@NotNull File cookieFile) {
            Intrinsics.checkParameterIsNotNull((Object)cookieFile, (String)"cookieFile");
            this.cookieFile = cookieFile;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/berndpruenster/netlayer/tor/ExternalTor$SafeCookieAuthenticator;", "Lorg/berndpruenster/netlayer/tor/ExternalTor$Authenticator;", "cookieFile", "Ljava/io/File;", "(Ljava/io/File;)V", "authenticate", "", "controlConnection", "Lorg/berndpruenster/netlayer/tor/TorController;", "tor.external"})
    private static final class SafeCookieAuthenticator
    extends Authenticator {
        private final File cookieFile;

        @Override
        public void authenticate(@NotNull TorController controlConnection) {
            Intrinsics.checkParameterIsNotNull((Object)controlConnection, (String)"controlConnection");
            byte[] clientNonce = Random.Default.nextBytes(32);
            TorControlConnection.AuthChallengeResult result = controlConnection.authChallenge(clientNonce);
            String string = "Tor safe cookie authentication server-to-controller hash";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            String string2 = "HmacSHA256";
            byte[] byArray3 = byArray2;
            SecretKeySpec keySpec = new SecretKeySpec(byArray3, string2);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            try {
                byte[] cookie = FilesKt.readBytes((File)this.cookieFile);
                mac.update(cookie);
                mac.update(clientNonce);
                mac.update(result.serverNonce);
                byte[] serverHash = mac.doFinal();
                Intrinsics.checkExpressionValueIsNotNull((Object)serverHash, (String)"serverHash");
                byte[] byArray4 = serverHash;
                Intrinsics.checkExpressionValueIsNotNull((Object)result.serverHash, (String)"result.serverHash");
                Object object = result.serverHash;
                boolean bl2 = false;
                if (!Arrays.equals(byArray4, (byte[])object)) {
                    throw (Throwable)new Exception("Tor Safecookie authentication failed: Serverhash does not match computed hash");
                }
                object = "Tor safe cookie authentication controller-to-server hash";
                Charset charset2 = Charsets.UTF_8;
                boolean bl3 = false;
                byte[] byArray5 = ((String)object).getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"(this as java.lang.String).getBytes(charset)");
                byArray2 = byArray5;
                String string3 = "HmacSHA256";
                byte[] byArray6 = byArray2;
                SecretKeySpec keySpec2 = new SecretKeySpec(byArray6, string3);
                mac.init(keySpec2);
                mac.update(cookie);
                mac.update(clientNonce);
                mac.update(result.serverNonce);
                controlConnection.authenticate(mac.doFinal());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw (Throwable)e;
            }
        }

        public SafeCookieAuthenticator(@NotNull File cookieFile) {
            Intrinsics.checkParameterIsNotNull((Object)cookieFile, (String)"cookieFile");
            this.cookieFile = cookieFile;
        }
    }
}

