/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.core.api.XmrConnectionService;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.setup.DownloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.MoneroWalletFull;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmrWalletBase {
    private static final Logger log = LoggerFactory.getLogger(XmrWalletBase.class);
    private static final int SYNC_TIMEOUT_SECONDS = 180;
    private static final String SYNC_TIMEOUT_MSG = "Sync timeout called";
    private static final long SAVE_AFTER_ELAPSED_SECONDS = 300L;
    private Object saveIntervalLock = new Object();
    protected long lastSaveTimeMs = 0L;
    protected MoneroWallet wallet;
    protected final Object walletLock = new Object();
    protected Timer saveWalletDelayTimer;
    protected XmrConnectionService xmrConnectionService;
    protected boolean wasWalletSynced;
    protected final Map<String, Optional<MoneroTx>> txCache = new HashMap<String, Optional<MoneroTx>>();
    protected boolean isClosingWallet;
    protected boolean isSyncingWithProgress;
    protected Long syncStartHeight;
    protected TaskLooper syncProgressLooper;
    protected CountDownLatch syncProgressLatch;
    protected Exception syncProgressError;
    protected Timer syncProgressTimeout;
    protected final DownloadListener downloadListener = new DownloadListener();
    protected final LongProperty walletHeight = new SimpleLongProperty(0L);
    protected boolean isShutDownStarted;
    protected boolean isShutDown;
    private boolean testReconnectOnStartup = false;
    private String testReconnectMonerod1 = "http://xmr-node.cakewallet.com:18081";
    private String testReconnectMonerod2 = "http://nodex.monerujo.io:18081";

    public XmrWalletBase() {
        this.xmrConnectionService = HavenoUtils.xmrConnectionService;
    }

    public MoneroSyncResult sync() {
        return this.syncWithTimeout(180L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MoneroSyncResult syncWithTimeout(long timeoutSec) {
        Object object = this.walletLock;
        synchronized (object) {
            MoneroSyncResult moneroSyncResult;
            ExecutorService executor;
            Object object2 = HavenoUtils.getDaemonLock();
            synchronized (object2) {
                executor = Executors.newSingleThreadExecutor();
                Callable<MoneroSyncResult> task = () -> {
                    MoneroSyncResult result = this.wallet.sync();
                    this.saveWalletIfElapsedTime();
                    this.walletHeight.set(this.wallet.getHeight());
                    return result;
                };
                Future<MoneroSyncResult> future = executor.submit(task);
                try {
                    moneroSyncResult = future.get(timeoutSec, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    future.cancel(true);
                    throw new RuntimeException(SYNC_TIMEOUT_MSG, e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Sync failed", e.getCause());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Sync was interrupted", e);
                }
            }
            return moneroSyncResult;
            {
                finally {
                    executor.shutdownNow();
                }
            }
        }
    }

    public void syncWithProgress() {
        this.syncWithProgress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncWithProgress(final boolean repeatSyncToLatestHeight) {
        Object object = this.walletLock;
        synchronized (object) {
            try {
                if (this.isSyncingWithProgress) {
                    log.warn("Syncing with progress while already syncing with progress. That should never happen");
                }
                this.resetSyncProgressTimeout();
                this.isSyncingWithProgress = true;
                this.syncProgressError = null;
                final long targetHeightAtStart = this.xmrConnectionService.getTargetHeight();
                this.syncStartHeight = this.walletHeight.get();
                this.updateSyncProgress(this.syncStartHeight, targetHeightAtStart);
                if (this.testReconnectOnStartup) {
                    UserThread.runAfter(() -> {
                        log.warn("Testing connection change on startup before wallet synced");
                        if (this.xmrConnectionService.getConnection().getUri().equals(this.testReconnectMonerod1)) {
                            this.xmrConnectionService.setConnection(this.testReconnectMonerod2);
                        } else {
                            this.xmrConnectionService.setConnection(this.testReconnectMonerod1);
                        }
                    }, (long)1L);
                    this.testReconnectOnStartup = false;
                }
                if (this.wallet instanceof MoneroWalletFull) {
                    if (this.testReconnectOnStartup) {
                        HavenoUtils.waitFor(1000L);
                    }
                    this.wallet.sync((MoneroWalletListenerI)new MoneroWalletListener(){

                        public void onSyncProgress(long height, long startHeight, long endHeight, double percentDone, String message) {
                            long appliedTargetHeight = repeatSyncToLatestHeight ? XmrWalletBase.this.xmrConnectionService.getTargetHeight() : targetHeightAtStart;
                            XmrWalletBase.this.updateSyncProgress(height, appliedTargetHeight);
                        }
                    });
                    this.setWalletSyncedWithProgress();
                    return;
                }
                this.syncProgressLatch = new CountDownLatch(1);
                this.syncProgressLooper = new TaskLooper(() -> {
                    long height;
                    if (this.isShutDownStarted || this.wallet == null) {
                        this.syncProgressError = new RuntimeException("Shut down or wallet has become null while syncing with progress");
                        this.syncProgressLatch.countDown();
                        return;
                    }
                    try {
                        height = this.wallet.getHeight();
                    }
                    catch (Exception e) {
                        if (this.wallet != null && !this.isShutDownStarted) {
                            log.warn("Error getting wallet height while syncing with progress: " + e.getMessage());
                        }
                        if (this.wallet == null) {
                            this.syncProgressError = new RuntimeException("Wallet has become null while syncing with progress");
                            this.syncProgressLatch.countDown();
                        }
                        return;
                    }
                    long appliedTargetHeight = repeatSyncToLatestHeight ? this.xmrConnectionService.getTargetHeight() : targetHeightAtStart;
                    this.updateSyncProgress(height, appliedTargetHeight);
                    if (height >= appliedTargetHeight) {
                        this.setWalletSyncedWithProgress();
                        this.syncProgressLatch.countDown();
                    }
                });
                this.wallet.startSyncing(Long.valueOf(this.xmrConnectionService.getRefreshPeriodMs()));
                this.syncProgressLooper.start(1000L);
                HavenoUtils.awaitLatch(this.syncProgressLatch);
                this.syncProgressLooper.stop();
                this.syncProgressTimeout.stop();
                if (!(this.wallet == null || this.syncProgressError != null && HavenoUtils.isUnresponsive(this.syncProgressError))) {
                    this.wallet.stopSyncing();
                    this.saveWalletIfElapsedTime();
                }
                if (this.syncProgressError != null) {
                    throw new RuntimeException(this.syncProgressError);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.isSyncingWithProgress = false;
            }
        }
    }

    public boolean requestSwitchToNextBestConnection(MoneroRpcConnection sourceConnection) {
        if (this.xmrConnectionService.requestSwitchToNextBestConnection(sourceConnection)) {
            this.onConnectionChanged(this.xmrConnectionService.getConnection());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWalletIfElapsedTime() {
        Object object = this.saveIntervalLock;
        synchronized (object) {
            if (System.currentTimeMillis() - this.lastSaveTimeMs >= 300000L) {
                this.saveWallet();
                this.lastSaveTimeMs = System.currentTimeMillis();
            }
        }
    }

    public void requestSaveWalletIfElapsedTime() {
        ThreadUtils.submitToPool(() -> this.saveWalletIfElapsedTime());
    }

    public static boolean isSyncWithProgressTimeout(Throwable e) {
        return e.getMessage().contains(SYNC_TIMEOUT_MSG);
    }

    public abstract void saveWallet();

    protected abstract void onConnectionChanged(MoneroRpcConnection var1);

    private void updateSyncProgress(long height, long targetHeight) {
        if (height != this.walletHeight.get()) {
            this.resetSyncProgressTimeout();
        }
        this.walletHeight.set(height);
        if (height == 1L) {
            this.downloadListener.progress(0.0, targetHeight - height, null);
            return;
        }
        long blocksLeft = targetHeight - height;
        if (this.syncStartHeight == null) {
            this.syncStartHeight = height;
        }
        double percent = Math.min(1.0, targetHeight == this.syncStartHeight ? 1.0 : ((double)height - (double)this.syncStartHeight.longValue()) / (double)(targetHeight - this.syncStartHeight));
        this.downloadListener.progress(percent, blocksLeft, null);
    }

    private synchronized void resetSyncProgressTimeout() {
        if (this.syncProgressTimeout != null) {
            this.syncProgressTimeout.stop();
        }
        this.syncProgressTimeout = UserThread.runAfter(() -> {
            if (this.isShutDownStarted) {
                return;
            }
            this.syncProgressError = new RuntimeException(SYNC_TIMEOUT_MSG);
            this.syncProgressLatch.countDown();
        }, (long)180L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void setWalletSyncedWithProgress() {
        this.wasWalletSynced = true;
        this.isSyncingWithProgress = false;
        if (this.syncProgressTimeout != null) {
            this.syncProgressTimeout.stop();
        }
    }

    public Object getWalletLock() {
        return this.walletLock;
    }

    public XmrConnectionService getXmrConnectionService() {
        return this.xmrConnectionService;
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }
}

