/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.core.xmr.wallet.XmrKeyImageListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import monero.common.MoneroError;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemon;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrKeyImagePoller {
    private static final Logger log = LoggerFactory.getLogger(XmrKeyImagePoller.class);
    private MoneroDaemon monerod;
    private long refreshPeriodMs;
    private Object lock = new Object();
    private Map<String, Set<String>> keyImageGroups = new HashMap<String, Set<String>>();
    private LinkedHashSet<String> keyImagePollQueue = new LinkedHashSet();
    private Set<XmrKeyImageListener> listeners = new HashSet<XmrKeyImageListener>();
    private TaskLooper looper;
    private Map<String, MoneroKeyImageSpentStatus> lastStatuses = new HashMap<String, MoneroKeyImageSpentStatus>();
    private boolean isPolling = false;
    private Long lastLogPollErrorTimestamp;
    private static final int MAX_POLL_SIZE = 200;

    public XmrKeyImagePoller() {
        this.looper = new TaskLooper(() -> this.poll());
    }

    public XmrKeyImagePoller(MoneroDaemon monerod, long refreshPeriodMs) {
        this.looper = new TaskLooper(() -> this.poll());
        this.setMonerod(monerod);
        this.setRefreshPeriodMs(refreshPeriodMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(XmrKeyImageListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(listener);
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(XmrKeyImageListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                throw new MoneroError("Listener is not registered");
            }
            this.listeners.remove(listener);
            this.refreshPolling();
        }
    }

    public void setMonerod(MoneroDaemon monerod) {
        this.monerod = monerod;
    }

    public MoneroDaemon getMonerod() {
        return this.monerod;
    }

    public void setRefreshPeriodMs(long refreshPeriodMs) {
        this.refreshPeriodMs = refreshPeriodMs;
    }

    public long getRefreshPeriodMs() {
        return this.refreshPeriodMs;
    }

    public void addKeyImage(String keyImage, String groupId) {
        this.addKeyImages(Arrays.asList(keyImage), groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyImages(Collection<String> keyImages, String groupId) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.keyImageGroups.containsKey(groupId)) {
                this.keyImageGroups.put(groupId, new HashSet());
            }
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            keyImagesGroup.addAll(keyImages);
            this.keyImagePollQueue.addAll(keyImages);
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyImages(Collection<String> keyImages, String groupId) {
        Object object = this.lock;
        synchronized (object) {
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            if (keyImagesGroup == null) {
                return;
            }
            keyImagesGroup.removeAll(keyImages);
            if (keyImagesGroup.isEmpty()) {
                this.keyImageGroups.remove(groupId);
            }
            Set<String> allKeyImages = this.getKeyImages();
            for (String keyImage : keyImages) {
                if (allKeyImages.contains(keyImage)) continue;
                this.keyImagePollQueue.remove(keyImage);
                this.lastStatuses.remove(keyImage);
            }
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyImages(String groupId) {
        Object object = this.lock;
        synchronized (object) {
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            if (keyImagesGroup == null) {
                return;
            }
            this.keyImageGroups.remove(groupId);
            Set<String> allKeyImages = this.getKeyImages();
            for (String keyImage : keyImagesGroup) {
                if (allKeyImages.contains(keyImage)) continue;
                this.keyImagePollQueue.remove(keyImage);
                this.lastStatuses.remove(keyImage);
            }
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyImages() {
        Object object = this.lock;
        synchronized (object) {
            this.keyImageGroups.clear();
            this.keyImagePollQueue.clear();
            this.lastStatuses.clear();
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isSpent(String keyImage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.lastStatuses.containsKey(keyImage)) {
                return null;
            }
            return XmrKeyImagePoller.isSpent(this.lastStatuses.get(keyImage));
        }
    }

    public static boolean isSpent(MoneroKeyImageSpentStatus status) {
        return status != MoneroKeyImageSpentStatus.NOT_SPENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroKeyImageSpentStatus getLastSpentStatus(String keyImage) {
        Object object = this.lock;
        synchronized (object) {
            return this.lastStatuses.get(keyImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        if (this.monerod == null) {
            log.warn("Cannot poll key images because monerod is null");
            return;
        }
        List spentStatuses = null;
        ArrayList<String> keyImages = new ArrayList<String>(this.getNextKeyImageBatch());
        try {
            spentStatuses = keyImages.isEmpty() ? new ArrayList() : this.monerod.getKeyImageSpentStatuses(keyImages);
        }
        catch (Exception e) {
            if (this.lastLogPollErrorTimestamp == null || System.currentTimeMillis() - this.lastLogPollErrorTimestamp > 240000L) {
                log.warn("Error polling spent status of key images: " + e.getMessage());
                this.lastLogPollErrorTimestamp = System.currentTimeMillis();
            }
            return;
        }
        HashMap<String, MoneroKeyImageSpentStatus> changedStatuses = new HashMap<String, MoneroKeyImageSpentStatus>();
        Object object = this.lock;
        synchronized (object) {
            Set<String> allKeyImages = this.getKeyImages();
            for (int i = 0; i < keyImages.size(); ++i) {
                if (!allKeyImages.contains(keyImages.get(i))) continue;
                this.keyImagePollQueue.remove(keyImages.get(i));
                this.keyImagePollQueue.add((String)keyImages.get(i));
                if (spentStatuses.get(i) == this.lastStatuses.get(keyImages.get(i))) continue;
                this.lastStatuses.put((String)keyImages.get(i), (MoneroKeyImageSpentStatus)spentStatuses.get(i));
                changedStatuses.put((String)keyImages.get(i), (MoneroKeyImageSpentStatus)spentStatuses.get(i));
            }
        }
        if (!changedStatuses.isEmpty()) {
            ArrayList<XmrKeyImageListener> listeners;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                listeners = new ArrayList<XmrKeyImageListener>(this.listeners);
            }
            for (XmrKeyImageListener listener : listeners) {
                listener.onSpentStatusChanged(changedStatuses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPolling() {
        Object object = this.lock;
        synchronized (object) {
            this.setIsPolling(!this.getKeyImages().isEmpty() && this.listeners.size() > 0);
        }
    }

    private synchronized void setIsPolling(boolean enabled) {
        if (enabled) {
            if (!this.isPolling) {
                this.isPolling = true;
                this.looper.start(this.refreshPeriodMs);
            }
        } else {
            this.isPolling = false;
            this.looper.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyImages() {
        HashSet<String> allKeyImages = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (Set<String> keyImagesGroup : this.keyImageGroups.values()) {
                allKeyImages.addAll(keyImagesGroup);
            }
        }
        return allKeyImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getNextKeyImageBatch() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> keyImageBatch = new ArrayList<String>();
            int count = 0;
            for (String keyImage : this.keyImagePollQueue) {
                if (count >= 200) break;
                keyImageBatch.add(keyImage);
                ++count;
            }
            return keyImageBatch;
        }
    }
}

