/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.core.user.Preferences;
import haveno.core.xmr.exceptions.TransactionVerificationException;
import haveno.core.xmr.exceptions.WalletException;
import haveno.core.xmr.listeners.AddressConfidenceListener;
import haveno.core.xmr.listeners.BalanceListener;
import haveno.core.xmr.listeners.TxConfidenceListener;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.Restrictions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javax.annotation.Nullable;
import monero.wallet.MoneroWallet;
import monero.wallet.model.MoneroTxWallet;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.listeners.NewBestBlockListener;
import org.bitcoinj.core.listeners.TransactionConfidenceEventListener;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.DecryptingKeyBag;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.listeners.WalletChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsSentEventListener;
import org.bitcoinj.wallet.listeners.WalletReorganizeEventListener;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WalletService {
    private static final Logger log = LoggerFactory.getLogger(WalletService.class);
    protected final WalletsSetup walletsSetup;
    protected final Preferences preferences;
    protected final NetworkParameters params;
    private final HavenoWalletListener walletEventListener = new HavenoWalletListener();
    private final CopyOnWriteArraySet<AddressConfidenceListener> addressConfidenceListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<TxConfidenceListener> txConfidenceListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<BalanceListener> balanceListeners = new CopyOnWriteArraySet();
    private final WalletChangeEventListener cacheInvalidationListener;
    private final AtomicReference<Multiset<Address>> txOutputAddressCache = new AtomicReference();
    private final AtomicReference<SetMultimap<Address, Transaction>> addressToMatchingTxSetCache = new AtomicReference();
    protected Wallet wallet;
    protected KeyParameter aesKey;
    protected IntegerProperty chainHeightProperty = new SimpleIntegerProperty();

    @Inject
    WalletService(WalletsSetup walletsSetup, Preferences preferences) {
        this.walletsSetup = walletsSetup;
        this.preferences = preferences;
        this.params = walletsSetup.getParams();
        this.cacheInvalidationListener = wallet -> {
            this.txOutputAddressCache.set(null);
            this.addressToMatchingTxSetCache.set(null);
        };
    }

    protected void addListenersToWallet() {
        if (this.wallet != null) {
            this.wallet.addCoinsReceivedEventListener((WalletCoinsReceivedEventListener)this.walletEventListener);
            this.wallet.addCoinsSentEventListener((WalletCoinsSentEventListener)this.walletEventListener);
            this.wallet.addReorganizeEventListener((WalletReorganizeEventListener)this.walletEventListener);
            this.wallet.addTransactionConfidenceEventListener((TransactionConfidenceEventListener)this.walletEventListener);
            this.wallet.addChangeEventListener(Threading.SAME_THREAD, this.cacheInvalidationListener);
        }
    }

    public void shutDown() {
        if (this.wallet != null) {
            this.wallet.removeCoinsReceivedEventListener((WalletCoinsReceivedEventListener)this.walletEventListener);
            this.wallet.removeCoinsSentEventListener((WalletCoinsSentEventListener)this.walletEventListener);
            this.wallet.removeReorganizeEventListener((WalletReorganizeEventListener)this.walletEventListener);
            this.wallet.removeTransactionConfidenceEventListener((TransactionConfidenceEventListener)this.walletEventListener);
            this.wallet.removeChangeEventListener(this.cacheInvalidationListener);
        }
    }

    void decryptWallet(@NotNull KeyParameter key) {
        this.wallet.decrypt(key);
        this.aesKey = null;
    }

    void encryptWallet(KeyCrypterScrypt keyCrypterScrypt, KeyParameter key) {
        if (this.aesKey != null) {
            log.warn("encryptWallet called but we have a aesKey already set. We decryptWallet with the old key before we apply the new key.");
            this.decryptWallet(this.aesKey);
        }
        this.wallet.encrypt((KeyCrypter)keyCrypterScrypt, key);
        this.aesKey = key;
    }

    void setAesKey(KeyParameter aesKey) {
        this.aesKey = aesKey;
    }

    abstract String getWalletAsString(boolean var1);

    public void addAddressConfidenceListener(AddressConfidenceListener listener) {
        this.addressConfidenceListeners.add(listener);
    }

    public void removeAddressConfidenceListener(AddressConfidenceListener listener) {
        this.addressConfidenceListeners.remove(listener);
    }

    public void addTxConfidenceListener(TxConfidenceListener listener) {
        this.txConfidenceListeners.add(listener);
    }

    public void removeTxConfidenceListener(TxConfidenceListener listener) {
        this.txConfidenceListeners.remove(listener);
    }

    public void addBalanceListener(BalanceListener listener) {
        this.balanceListeners.add(listener);
    }

    public void removeBalanceListener(BalanceListener listener) {
        this.balanceListeners.remove(listener);
    }

    public static void checkWalletConsistency(Wallet wallet) throws WalletException {
        try {
            Preconditions.checkNotNull((Object)wallet);
            Preconditions.checkState((boolean)wallet.isConsistent());
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            throw new WalletException(t);
        }
    }

    public static void verifyTransaction(Transaction transaction) throws TransactionVerificationException {
        try {
            transaction.verify();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            throw new TransactionVerificationException(t);
        }
    }

    public static void checkAllScriptSignaturesForTx(Transaction transaction) throws TransactionVerificationException {
        for (int i = 0; i < transaction.getInputs().size(); ++i) {
            WalletService.checkScriptSig(transaction, (TransactionInput)transaction.getInputs().get(i), i);
        }
    }

    public static void checkScriptSig(Transaction transaction, TransactionInput input, int inputIndex) throws TransactionVerificationException {
        try {
            Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
            input.getScriptSig().correctlySpends(transaction, inputIndex, input.getWitness(), input.getValue(), input.getConnectedOutput().getScriptPubKey(), (Set)Script.ALL_VERIFY_FLAGS);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            throw new TransactionVerificationException(t);
        }
    }

    public static void signTransactionInput(Wallet wallet, KeyParameter aesKey, Transaction tx, TransactionInput txIn, int index) {
        DecryptingKeyBag maybeDecryptingKeyBag = new DecryptingKeyBag((KeyBag)wallet, aesKey);
        if (txIn.getConnectedOutput() != null) {
            try {
                txIn.getScriptSig().correctlySpends(tx, index, txIn.getWitness(), txIn.getValue(), txIn.getConnectedOutput().getScriptPubKey(), (Set)Script.ALL_VERIFY_FLAGS);
                log.warn("Input {} already correctly spends output, assuming SIGHASH type used will be safe and skipping signing.", (Object)index);
                return;
            }
            catch (ScriptException scriptException) {
                Script scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
                RedeemData redeemData = txIn.getConnectedRedeemData((KeyBag)maybeDecryptingKeyBag);
                Preconditions.checkNotNull((Object)redeemData, (String)"Transaction exists in wallet that we cannot redeem: %s", (Object)txIn.getOutpoint().getHash());
                txIn.setScriptSig(scriptPubKey.createEmptyInputScript((ECKey)redeemData.keys.get(0), redeemData.redeemScript));
                TransactionSigner.ProposedTransaction propTx = new TransactionSigner.ProposedTransaction(tx);
                Transaction partialTx = propTx.partialTx;
                txIn = partialTx.getInput((long)index);
                if (txIn.getConnectedOutput() != null) {
                    ECKey key;
                    List chunks = txIn.getConnectedOutput().getScriptPubKey().getChunks();
                    if (!chunks.isEmpty() && ((ScriptChunk)chunks.get((int)0)).data != null && ((ScriptChunk)chunks.get((int)0)).data.length > 0) {
                        try {
                            txIn.getScriptSig().correctlySpends(tx, index, txIn.getWitness(), txIn.getValue(), txIn.getConnectedOutput().getScriptPubKey(), (Set)Script.ALL_VERIFY_FLAGS);
                            log.warn("Input {} already correctly spends output, assuming SIGHASH type used will be safe and skipping signing.", (Object)index);
                            return;
                        }
                        catch (ScriptException scriptException2) {
                            // empty catch block
                        }
                    }
                    redeemData = txIn.getConnectedRedeemData((KeyBag)maybeDecryptingKeyBag);
                    scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
                    Preconditions.checkNotNull((Object)redeemData, (Object)"redeemData must not be null");
                    ECKey pubKey = (ECKey)redeemData.keys.get(0);
                    if (pubKey instanceof DeterministicKey) {
                        propTx.keyPaths.put(scriptPubKey, ((DeterministicKey)pubKey).getPath());
                    }
                    if ((key = redeemData.getFullKey()) == null) {
                        log.warn("No local key found for input {}", (Object)index);
                        return;
                    }
                    Script inputScript = txIn.getScriptSig();
                    byte[] script = redeemData.redeemScript.getProgram();
                    if (ScriptPattern.isP2PK((Script)scriptPubKey) || ScriptPattern.isP2PKH((Script)scriptPubKey)) {
                        try {
                            TransactionSignature signature = partialTx.calculateSignature(index, key, script, Transaction.SigHash.ALL, false);
                            inputScript = scriptPubKey.getScriptSigWithSignature(inputScript, signature.encodeToBitcoin(), 0);
                            txIn.setScriptSig(inputScript);
                        }
                        catch (ECKey.KeyIsEncryptedException e1) {
                            throw e1;
                        }
                        catch (ECKey.MissingPrivateKeyException e1) {
                            log.warn("No private key in keypair for input {}", (Object)index);
                        }
                    }
                    if (ScriptPattern.isP2WPKH((Script)scriptPubKey)) {
                        try {
                            Script scriptCode = ScriptBuilder.createP2PKHOutputScript((ECKey)key);
                            Coin value = txIn.getValue();
                            TransactionSignature txSig = tx.calculateWitnessSignature(index, key, aesKey, scriptCode, value, Transaction.SigHash.ALL, false);
                            txIn.setScriptSig(ScriptBuilder.createEmpty());
                            txIn.setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)txSig, (ECKey)key));
                        }
                        catch (ECKey.KeyIsEncryptedException e1) {
                            throw e1;
                        }
                        catch (ECKey.MissingPrivateKeyException e1) {
                            log.warn("No private key in keypair for input {}", (Object)index);
                        }
                    }
                    throw new RuntimeException("Unexpected script type.");
                }
                log.warn("Missing connected output, assuming input {} is already signed.", (Object)index);
            }
        } else {
            log.error("Missing connected output, assuming already signed.");
        }
    }

    @Nullable
    public TransactionConfidence getConfidenceForAddress(Address address) {
        ArrayList<TransactionConfidence> transactionConfidenceList = new ArrayList<TransactionConfidence>();
        if (this.wallet != null) {
            Set transactions = this.getAddressToMatchingTxSetMultiset().get((Object)address);
            transactionConfidenceList.addAll(transactions.stream().map(tx -> this.getTransactionConfidence((Transaction)tx, address)).collect(Collectors.toList()));
        }
        return this.getMostRecentConfidence(transactionConfidenceList);
    }

    private SetMultimap<Address, Transaction> getAddressToMatchingTxSetMultiset() {
        return this.addressToMatchingTxSetCache.updateAndGet(set -> set != null ? set : this.computeAddressToMatchingTxSetMultimap());
    }

    private SetMultimap<Address, Transaction> computeAddressToMatchingTxSetMultimap() {
        return ((ImmutableSetMultimap)this.wallet.getTransactions(false).stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Function.identity(), t -> this.getOutputsWithConnectedOutputs((Transaction)t).stream().map(WalletService::getAddressFromOutput).filter(Objects::nonNull)))).inverse();
    }

    @Nullable
    public TransactionConfidence getConfidenceForTxId(String txId) {
        if (this.wallet != null) {
            Set transactions = this.wallet.getTransactions(false);
            for (Transaction tx : transactions) {
                if (!tx.getTxId().toString().equals(txId)) continue;
                return tx.getConfidence();
            }
        }
        return null;
    }

    @Nullable
    private TransactionConfidence getTransactionConfidence(Transaction tx, Address address) {
        List<TransactionConfidence> transactionConfidenceList = this.getOutputsWithConnectedOutputs(tx).stream().filter(output -> address != null && address.equals((Object)WalletService.getAddressFromOutput(output))).flatMap(o -> Stream.ofNullable(o.getParentTransaction())).map(Transaction::getConfidence).collect(Collectors.toList());
        return this.getMostRecentConfidence(transactionConfidenceList);
    }

    private List<TransactionOutput> getOutputsWithConnectedOutputs(Transaction tx) {
        List transactionOutputs = tx.getOutputs();
        ArrayList<TransactionOutput> connectedOutputs = new ArrayList<TransactionOutput>();
        List transactionInputs = tx.getInputs();
        for (TransactionInput transactionInput : transactionInputs) {
            TransactionOutput transactionOutput = transactionInput.getConnectedOutput();
            if (transactionOutput == null) continue;
            connectedOutputs.add(transactionOutput);
        }
        ArrayList<TransactionOutput> mergedOutputs = new ArrayList<TransactionOutput>();
        mergedOutputs.addAll(transactionOutputs);
        mergedOutputs.addAll(connectedOutputs);
        return mergedOutputs;
    }

    @Nullable
    private TransactionConfidence getMostRecentConfidence(List<TransactionConfidence> transactionConfidenceList) {
        TransactionConfidence transactionConfidence = null;
        for (TransactionConfidence confidence : transactionConfidenceList) {
            if (confidence == null || transactionConfidence != null && !confidence.getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.PENDING) && (!confidence.getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.BUILDING) || !transactionConfidence.getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.BUILDING) || confidence.getDepthInBlocks() >= transactionConfidence.getDepthInBlocks())) continue;
            transactionConfidence = confidence;
        }
        return transactionConfidence;
    }

    public Coin getAvailableConfirmedBalance() {
        return this.wallet != null ? this.wallet.getBalance(Wallet.BalanceType.AVAILABLE) : Coin.ZERO;
    }

    public Coin getEstimatedBalance() {
        return this.wallet != null ? this.wallet.getBalance(Wallet.BalanceType.ESTIMATED) : Coin.ZERO;
    }

    public Coin getBalanceForAddress(Address address) {
        return this.wallet != null ? this.getBalance(this.wallet.calculateAllSpendCandidates(), address) : Coin.ZERO;
    }

    protected Coin getBalance(List<TransactionOutput> transactionOutputs, Address address) {
        Coin balance = Coin.ZERO;
        for (TransactionOutput output : transactionOutputs) {
            if (this.isDustAttackUtxo(output) || !WalletService.isOutputScriptConvertibleToAddress(output) || address == null || !address.equals((Object)WalletService.getAddressFromOutput(output))) continue;
            balance = balance.add(output.getValue());
        }
        return balance;
    }

    protected abstract boolean isDustAttackUtxo(TransactionOutput var1);

    public Coin getBalance(TransactionOutput output) {
        return this.getBalanceForAddress(WalletService.getAddressFromOutput(output));
    }

    public int getNumTxOutputsForAddress(Address address) {
        return this.getTxOutputAddressMultiset().count((Object)address);
    }

    private Multiset<Address> getTxOutputAddressMultiset() {
        return this.txOutputAddressCache.updateAndGet(set -> set != null ? set : this.computeTxOutputAddressMultiset());
    }

    private Multiset<Address> computeTxOutputAddressMultiset() {
        return (Multiset)this.wallet.getTransactions(false).stream().flatMap(t -> t.getOutputs().stream()).map(WalletService::getAddressFromOutput).filter(Objects::nonNull).collect(ImmutableMultiset.toImmutableMultiset());
    }

    public boolean isAddressUnused(Address address) {
        return this.getNumTxOutputsForAddress(address) == 0;
    }

    public Coin getDust(Transaction proposedTransaction) {
        Coin dust = Coin.ZERO;
        for (TransactionOutput transactionOutput : proposedTransaction.getOutputs()) {
            if (!transactionOutput.getValue().isLessThan(Restrictions.getMinNonDustOutput())) continue;
            dust = dust.add(transactionOutput.getValue());
            log.info("Dust TXO = {}", (Object)transactionOutput.toString());
        }
        return dust;
    }

    public Transaction getTxFromSerializedTx(byte[] tx) {
        return new Transaction(this.params, tx);
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    public int getBestChainHeight() {
        BlockChain chain = this.walletsSetup.getChain();
        return this.isWalletReady() && chain != null ? chain.getBestChainHeight() : 0;
    }

    public abstract boolean isWalletSyncedWithinTolerance();

    public Transaction getClonedTransaction(Transaction tx) {
        return new Transaction(this.params, tx.bitcoinSerialize());
    }

    public void addChangeEventListener(WalletChangeEventListener listener) {
        this.wallet.addChangeEventListener(Threading.USER_THREAD, listener);
    }

    public void removeChangeEventListener(WalletChangeEventListener listener) {
        this.wallet.removeChangeEventListener(listener);
    }

    public void addNewBestBlockListener(NewBestBlockListener listener) {
        BlockChain chain = this.walletsSetup.getChain();
        if (this.isWalletReady() && chain != null) {
            chain.addNewBestBlockListener(listener);
        }
    }

    public void removeNewBestBlockListener(NewBestBlockListener listener) {
        BlockChain chain = this.walletsSetup.getChain();
        if (this.isWalletReady() && chain != null) {
            chain.removeNewBestBlockListener(listener);
        }
    }

    public boolean isWalletReady() {
        return this.wallet != null;
    }

    public DeterministicSeed getKeyChainSeed() {
        return this.wallet.getKeyChainSeed();
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        return this.wallet.getKeyCrypter();
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        return this.wallet.checkAESKey(aesKey);
    }

    @Nullable
    public DeterministicKey findKeyFromPubKey(byte[] pubKey) {
        return (DeterministicKey)this.wallet.findKeyFromPubKey(pubKey);
    }

    public boolean isEncrypted() {
        return this.wallet.isEncrypted();
    }

    public List<Transaction> getRecentTransactions(int numTransactions, boolean includeDead) {
        return this.wallet.getRecentTransactions(numTransactions, includeDead);
    }

    public int getLastBlockSeenHeight() {
        return this.wallet.getLastBlockSeenHeight();
    }

    public boolean isUnconfirmedTransactionsLimitHit() {
        return this.getTransactions(false).stream().filter(tx -> tx.getLockTime() == 0L).filter(Transaction::isPending).count() > 20L;
    }

    public Set<Transaction> getTransactions(boolean includeDead) {
        return this.wallet.getTransactions(includeDead);
    }

    public Coin getBalance(Wallet.BalanceType balanceType) {
        return this.wallet.getBalance(balanceType);
    }

    @Nullable
    public Transaction getTransaction(Sha256Hash hash) {
        return this.wallet.getTransaction(hash);
    }

    @Nullable
    public Transaction getTransaction(String txId) {
        if (txId == null) {
            return null;
        }
        return this.getTransaction(Sha256Hash.wrap((String)txId));
    }

    public boolean isTransactionOutputMine(TransactionOutput transactionOutput) {
        return transactionOutput.isMine((TransactionBag)this.wallet);
    }

    public Coin getValueSentFromMeForTransaction(Transaction transaction) throws ScriptException {
        return transaction.getValueSentFromMe((TransactionBag)this.wallet);
    }

    public Coin getValueSentToMeForTransaction(Transaction transaction) throws ScriptException {
        return transaction.getValueSentToMe((TransactionBag)this.wallet);
    }

    public static void printTx(String tracePrefix, Transaction tx) {
        log.info("\n" + tracePrefix + ":\n" + tx.toString());
    }

    public static boolean isOutputScriptConvertibleToAddress(TransactionOutput output) {
        return ScriptPattern.isP2PKH((Script)output.getScriptPubKey()) || ScriptPattern.isP2SH((Script)output.getScriptPubKey()) || ScriptPattern.isP2WH((Script)output.getScriptPubKey());
    }

    @Nullable
    public static Address getAddressFromOutput(TransactionOutput output) {
        return WalletService.isOutputScriptConvertibleToAddress(output) ? output.getScriptPubKey().getToAddress(Config.baseCurrencyNetworkParameters()) : null;
    }

    @Nullable
    public static String getAddressStringFromOutput(TransactionOutput output) {
        return WalletService.isOutputScriptConvertibleToAddress(output) ? output.getScriptPubKey().getToAddress(Config.baseCurrencyNetworkParameters()).toString() : null;
    }

    public static Transaction maybeAddTxToWallet(byte[] serializedTransaction, Wallet wallet, TransactionConfidence.Source source) throws VerificationException {
        Transaction tx = new Transaction(wallet.getParams(), serializedTransaction);
        Transaction walletTransaction = wallet.getTransaction(tx.getTxId());
        if (walletTransaction == null) {
            tx.getConfidence(Context.get()).setSource(source);
            wallet.receivePending(tx, null, true);
            return tx;
        }
        return walletTransaction;
    }

    public static MoneroTxWallet maybeAddNetworkTxToWallet(byte[] serializedTransaction, MoneroWallet wallet) throws VerificationException {
        throw new RuntimeException("Not implemented");
    }

    public static Transaction maybeAddNetworkTxToWallet(byte[] serializedTransaction, Wallet wallet) throws VerificationException {
        return WalletService.maybeAddTxToWallet(serializedTransaction, wallet, TransactionConfidence.Source.NETWORK);
    }

    public static Transaction maybeAddSelfTxToWallet(Transaction transaction, Wallet wallet) throws VerificationException {
        return WalletService.maybeAddTxToWallet(transaction, wallet, TransactionConfidence.Source.SELF);
    }

    public static Transaction maybeAddTxToWallet(Transaction transaction, Wallet wallet, TransactionConfidence.Source source) throws VerificationException {
        return WalletService.maybeAddTxToWallet(transaction.bitcoinSerialize(), wallet, source);
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public KeyParameter getAesKey() {
        return this.aesKey;
    }

    public IntegerProperty getChainHeightProperty() {
        return this.chainHeightProperty;
    }

    public class HavenoWalletListener
    implements WalletCoinsReceivedEventListener,
    WalletCoinsSentEventListener,
    WalletReorganizeEventListener,
    TransactionConfidenceEventListener {
        public void onCoinsReceived(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
            this.notifyBalanceListeners(tx);
        }

        public void onCoinsSent(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
            this.notifyBalanceListeners(tx);
        }

        public void onReorganize(Wallet wallet) {
            log.warn("onReorganize ");
        }

        public void onTransactionConfidenceChanged(Wallet wallet, Transaction tx) {
            for (AddressConfidenceListener addressConfidenceListener : WalletService.this.addressConfidenceListeners) {
                TransactionConfidence confidence = WalletService.this.getTransactionConfidence(tx, addressConfidenceListener.getAddress());
                addressConfidenceListener.onTransactionConfidenceChanged(confidence);
            }
            WalletService.this.txConfidenceListeners.stream().filter(txConfidenceListener -> tx != null && tx.getTxId().toString() != null && txConfidenceListener != null && tx.getTxId().toString().equals(txConfidenceListener.getTxID())).forEach(txConfidenceListener -> txConfidenceListener.onTransactionConfidenceChanged(tx.getConfidence()));
        }

        void notifyBalanceListeners(Transaction tx) {
            for (BalanceListener balanceListener : WalletService.this.balanceListeners) {
                Coin balance = balanceListener.getAddress() != null ? WalletService.this.getBalanceForAddress(balanceListener.getAddress()) : WalletService.this.getAvailableConfirmedBalance();
                balanceListener.onBalanceChanged(balance, tx);
            }
        }
    }
}

