/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.common.util.Tuple2;
import haveno.core.user.Preferences;
import haveno.core.xmr.exceptions.SigningException;
import haveno.core.xmr.exceptions.TransactionVerificationException;
import haveno.core.xmr.exceptions.WalletException;
import haveno.core.xmr.model.InputsAndChangeOutput;
import haveno.core.xmr.model.PreparedDepositTxAndMakerInputs;
import haveno.core.xmr.model.RawTransactionInput;
import haveno.core.xmr.setup.WalletConfig;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcCoinSelector;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.WalletService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.SegwitAddress;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.SignatureDecodeException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeWalletService {
    private static final Logger log = LoggerFactory.getLogger(TradeWalletService.class);
    private static final Coin MIN_DELAYED_PAYOUT_TX_FEE = Coin.valueOf((long)1000L);
    private final WalletsSetup walletsSetup;
    private final Preferences preferences;
    private final NetworkParameters params;
    @Nullable
    private Wallet wallet;
    @Nullable
    private WalletConfig walletConfig;
    @Nullable
    private KeyParameter aesKey;

    @Inject
    public TradeWalletService(WalletsSetup walletsSetup, Preferences preferences) {
        this.walletsSetup = walletsSetup;
        this.preferences = preferences;
        this.params = Config.baseCurrencyNetworkParameters();
        walletsSetup.addSetupCompletedHandler(() -> {
            this.walletConfig = walletsSetup.getWalletConfig();
            this.wallet = walletsSetup.getBtcWallet();
        });
    }

    void setAesKey(@Nullable KeyParameter newAesKey) {
        this.aesKey = newAesKey;
    }

    @Nullable
    public KeyParameter getAesKey() {
        return this.aesKey;
    }

    public InputsAndChangeOutput takerCreatesDepositTxInputs(Transaction takeOfferFeeTx, Coin inputAmount, Coin txFee) throws TransactionVerificationException {
        Coin dummyOutputAmount = inputAmount.subtract(txFee);
        Transaction dummyTX = new Transaction(this.params);
        TransactionOutput dummyOutput = new TransactionOutput(this.params, dummyTX, dummyOutputAmount, (Address)SegwitAddress.fromKey((NetworkParameters)this.params, (ECKey)new ECKey()));
        dummyTX.addOutput(dummyOutput);
        TransactionOutput reservedForTradeOutput = (TransactionOutput)takeOfferFeeTx.getOutputs().get(1);
        Preconditions.checkArgument((boolean)reservedForTradeOutput.getValue().equals((Object)inputAmount), (Object)"Reserve amount does not equal input amount");
        dummyTX.addInput(reservedForTradeOutput);
        WalletService.verifyTransaction(dummyTX);
        List rawTransactionInputList = dummyTX.getInputs().stream().map(e -> {
            Preconditions.checkNotNull((Object)e.getConnectedOutput(), (Object)"e.getConnectedOutput() must not be null");
            Preconditions.checkNotNull((Object)e.getConnectedOutput().getParentTransaction(), (Object)"e.getConnectedOutput().getParentTransaction() must not be null");
            Preconditions.checkNotNull((Object)e.getValue(), (Object)"e.getValue() must not be null");
            return this.getRawInputFromTransactionInput((TransactionInput)e);
        }).collect(Collectors.toList());
        return new InputsAndChangeOutput(new ArrayList<RawTransactionInput>(rawTransactionInputList), 0L, null);
    }

    public PreparedDepositTxAndMakerInputs sellerAsMakerCreatesDepositTx(byte[] contractHash, Coin makerInputAmount, Coin msOutputAmount, List<RawTransactionInput> takerRawTransactionInputs, long takerChangeOutputValue, @Nullable String takerChangeAddressString, Address makerAddress, Address makerChangeAddress, byte[] buyerPubKey, byte[] sellerPubKey) throws SigningException, TransactionVerificationException, WalletException, AddressFormatException {
        return this.makerCreatesDepositTx(false, contractHash, makerInputAmount, msOutputAmount, takerRawTransactionInputs, takerChangeOutputValue, takerChangeAddressString, makerAddress, makerChangeAddress, buyerPubKey, sellerPubKey);
    }

    public PreparedDepositTxAndMakerInputs buyerAsMakerCreatesAndSignsDepositTx(byte[] contractHash, Coin makerInputAmount, Coin msOutputAmount, List<RawTransactionInput> takerRawTransactionInputs, long takerChangeOutputValue, @Nullable String takerChangeAddressString, Address makerAddress, Address makerChangeAddress, byte[] buyerPubKey, byte[] sellerPubKey) throws SigningException, TransactionVerificationException, WalletException, AddressFormatException {
        return this.makerCreatesDepositTx(true, contractHash, makerInputAmount, msOutputAmount, takerRawTransactionInputs, takerChangeOutputValue, takerChangeAddressString, makerAddress, makerChangeAddress, buyerPubKey, sellerPubKey);
    }

    private PreparedDepositTxAndMakerInputs makerCreatesDepositTx(boolean makerIsBuyer, byte[] contractHash, Coin makerInputAmount, Coin msOutputAmount, List<RawTransactionInput> takerRawTransactionInputs, long takerChangeOutputValue, @Nullable String takerChangeAddressString, Address makerAddress, Address makerChangeAddress, byte[] buyerPubKey, byte[] sellerPubKey) throws SigningException, TransactionVerificationException, WalletException, AddressFormatException {
        Preconditions.checkArgument((!takerRawTransactionInputs.isEmpty() ? 1 : 0) != 0);
        Transaction dummyTx = new Transaction(this.params);
        TransactionOutput dummyOutput = new TransactionOutput(this.params, dummyTx, makerInputAmount, (Address)SegwitAddress.fromKey((NetworkParameters)this.params, (ECKey)new ECKey()));
        dummyTx.addOutput(dummyOutput);
        this.addAvailableInputsAndChangeOutputs(dummyTx, makerAddress, makerChangeAddress);
        List makerInputs = dummyTx.getInputs();
        TransactionOutput makerOutput = null;
        Preconditions.checkArgument((dummyTx.getOutputs().size() < 3 ? 1 : 0) != 0, (Object)"dummyTx.getOutputs().size() >= 3");
        if (dummyTx.getOutputs().size() > 1) {
            makerOutput = dummyTx.getOutput(1L);
        }
        Transaction preparedDepositTx = new Transaction(this.params);
        ArrayList<RawTransactionInput> makerRawTransactionInputs = new ArrayList<RawTransactionInput>();
        if (makerIsBuyer) {
            for (TransactionInput input : makerInputs) {
                preparedDepositTx.addInput(input);
                makerRawTransactionInputs.add(this.getRawInputFromTransactionInput(input));
            }
            for (RawTransactionInput rawTransactionInput : takerRawTransactionInputs) {
                preparedDepositTx.addInput(this.getTransactionInput(preparedDepositTx, new byte[0], rawTransactionInput));
            }
        } else {
            for (RawTransactionInput rawTransactionInput : takerRawTransactionInputs) {
                preparedDepositTx.addInput(this.getTransactionInput(preparedDepositTx, new byte[0], rawTransactionInput));
            }
            for (TransactionInput input : makerInputs) {
                preparedDepositTx.addInput(input);
                makerRawTransactionInputs.add(this.getRawInputFromTransactionInput(input));
            }
        }
        Script hashedMultiSigOutputScript = this.get2of2MultiSigOutputScript(buyerPubKey, sellerPubKey, false);
        TransactionOutput hashedMultiSigOutput = new TransactionOutput(this.params, preparedDepositTx, msOutputAmount, hashedMultiSigOutputScript.getProgram());
        preparedDepositTx.addOutput(hashedMultiSigOutput);
        TransactionOutput contractHashOutput = new TransactionOutput(this.params, preparedDepositTx, Coin.ZERO, ScriptBuilder.createOpReturnScript((byte[])contractHash).getProgram());
        preparedDepositTx.addOutput(contractHashOutput);
        TransactionOutput takerTransactionOutput = null;
        if (takerChangeOutputValue > 0L && takerChangeAddressString != null) {
            takerTransactionOutput = new TransactionOutput(this.params, preparedDepositTx, Coin.valueOf((long)takerChangeOutputValue), Address.fromString((NetworkParameters)this.params, (String)takerChangeAddressString));
        }
        if (makerIsBuyer) {
            if (makerOutput != null) {
                preparedDepositTx.addOutput(makerOutput);
            }
            if (takerTransactionOutput != null) {
                preparedDepositTx.addOutput(takerTransactionOutput);
            }
        } else {
            if (takerTransactionOutput != null) {
                preparedDepositTx.addOutput(takerTransactionOutput);
            }
            if (makerOutput != null) {
                preparedDepositTx.addOutput(makerOutput);
            }
        }
        int start = makerIsBuyer ? 0 : takerRawTransactionInputs.size();
        int end = makerIsBuyer ? makerInputs.size() : preparedDepositTx.getInputs().size();
        for (int i = start; i < end; ++i) {
            TransactionInput input = preparedDepositTx.getInput((long)i);
            this.signInput(preparedDepositTx, input, i);
            WalletService.checkScriptSig(preparedDepositTx, input, i);
        }
        WalletService.printTx("makerCreatesDepositTx", preparedDepositTx);
        WalletService.verifyTransaction(preparedDepositTx);
        return new PreparedDepositTxAndMakerInputs(makerRawTransactionInputs, preparedDepositTx.bitcoinSerialize());
    }

    public Transaction takerSignsDepositTx(boolean takerIsSeller, byte[] contractHash, byte[] makersDepositTxSerialized, Coin msOutputAmount, List<RawTransactionInput> buyerInputs, List<RawTransactionInput> sellerInputs, byte[] buyerPubKey, byte[] sellerPubKey) throws SigningException, TransactionVerificationException, WalletException {
        Transaction makersDepositTx = new Transaction(this.params, makersDepositTxSerialized);
        Preconditions.checkArgument((!buyerInputs.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!sellerInputs.isEmpty() ? 1 : 0) != 0);
        Script hashedMultiSigOutputScript = this.get2of2MultiSigOutputScript(buyerPubKey, sellerPubKey, false);
        if (!makersDepositTx.getOutput(0L).getScriptPubKey().equals((Object)hashedMultiSigOutputScript)) {
            throw new TransactionVerificationException("Maker's hashedMultiSigOutputScript does not match taker's hashedMultiSigOutputScript");
        }
        if (!makersDepositTx.getOutput(0L).getValue().equals((Object)msOutputAmount)) {
            throw new TransactionVerificationException("Maker's MultiSig output amount does not match taker's MultiSig output amount");
        }
        Transaction depositTx = new Transaction(this.params);
        if (takerIsSeller) {
            for (int i = 0; i < buyerInputs.size(); ++i) {
                TransactionInput makersInput = (TransactionInput)makersDepositTx.getInputs().get(i);
                byte[] makersScriptSigProgram = makersInput.getScriptSig().getProgram();
                TransactionInput input = this.getTransactionInput(depositTx, makersScriptSigProgram, buyerInputs.get(i));
                Script scriptPubKey = ((TransactionOutput)Preconditions.checkNotNull((Object)input.getConnectedOutput())).getScriptPubKey();
                if (makersScriptSigProgram.length == 0 && !ScriptPattern.isP2WH((Script)scriptPubKey)) {
                    throw new TransactionVerificationException("Non-segwit inputs from maker not signed.");
                }
                if (!TransactionWitness.EMPTY.equals((Object)makersInput.getWitness())) {
                    input.setWitness(makersInput.getWitness());
                }
                depositTx.addInput(input);
            }
            for (RawTransactionInput rawTransactionInput : sellerInputs) {
                depositTx.addInput(this.getTransactionInput(depositTx, new byte[0], rawTransactionInput));
            }
        } else {
            for (RawTransactionInput rawTransactionInput : buyerInputs) {
                depositTx.addInput(this.getTransactionInput(depositTx, new byte[0], rawTransactionInput));
            }
            int i = buyerInputs.size();
            int k = 0;
            while (i < makersDepositTx.getInputs().size()) {
                TransactionInput transactionInput = (TransactionInput)makersDepositTx.getInputs().get(i);
                depositTx.addInput(this.getTransactionInput(depositTx, new byte[0], sellerInputs.get(k)));
                ++i;
                ++k;
            }
        }
        TransactionOutput contractHashOutput = new TransactionOutput(this.params, makersDepositTx, Coin.ZERO, ScriptBuilder.createOpReturnScript((byte[])contractHash).getProgram());
        log.debug("contractHashOutput {}", (Object)contractHashOutput);
        TransactionOutput makersContractHashOutput = (TransactionOutput)makersDepositTx.getOutputs().get(1);
        log.debug("makersContractHashOutput {}", (Object)makersContractHashOutput);
        if (!makersContractHashOutput.getScriptPubKey().equals((Object)contractHashOutput.getScriptPubKey())) {
            throw new TransactionVerificationException("Maker's transaction output for the contract hash is not matching taker's version.");
        }
        makersDepositTx.getOutputs().forEach(arg_0 -> ((Transaction)depositTx).addOutput(arg_0));
        WalletService.printTx("makersDepositTx", makersDepositTx);
        int start = takerIsSeller ? buyerInputs.size() : 0;
        int end = takerIsSeller ? depositTx.getInputs().size() : buyerInputs.size();
        for (int i = start; i < end; ++i) {
            TransactionInput input = depositTx.getInput((long)i);
            this.signInput(depositTx, input, i);
            WalletService.checkScriptSig(depositTx, input, i);
        }
        WalletService.printTx("takerSignsDepositTx", depositTx);
        WalletService.verifyTransaction(depositTx);
        WalletService.checkWalletConsistency(this.wallet);
        return depositTx;
    }

    public void sellerAsMakerFinalizesDepositTx(Transaction myDepositTx, Transaction takersDepositTx, int numTakersInputs) throws TransactionVerificationException, AddressFormatException {
        for (int i = 0; i < numTakersInputs; ++i) {
            TransactionInput takersInput = takersDepositTx.getInput((long)i);
            Script takersScriptSig = takersInput.getScriptSig();
            TransactionInput txInput = myDepositTx.getInput((long)i);
            txInput.setScriptSig(takersScriptSig);
            TransactionWitness witness = takersInput.getWitness();
            if (TransactionWitness.EMPTY.equals((Object)witness)) continue;
            txInput.setWitness(witness);
        }
        WalletService.printTx("sellerAsMakerFinalizesDepositTx", myDepositTx);
        WalletService.verifyTransaction(myDepositTx);
    }

    public void sellerAddsBuyerWitnessesToDepositTx(Transaction myDepositTx, Transaction buyersDepositTxWithWitnesses) {
        int numberInputs = myDepositTx.getInputs().size();
        for (int i = 0; i < numberInputs; ++i) {
            TransactionInput txInput = myDepositTx.getInput((long)i);
            TransactionWitness witnessFromBuyer = buyersDepositTxWithWitnesses.getInput((long)i).getWitness();
            if (!TransactionWitness.EMPTY.equals((Object)txInput.getWitness()) || TransactionWitness.EMPTY.equals((Object)witnessFromBuyer)) continue;
            txInput.setWitness(witnessFromBuyer);
        }
    }

    public Transaction createDelayedUnsignedPayoutTx(Transaction depositTx, String donationAddressString, Coin minerFee, long lockTime) throws AddressFormatException, TransactionVerificationException {
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        Transaction delayedPayoutTx = new Transaction(this.params);
        delayedPayoutTx.addInput(hashedMultiSigOutput);
        this.applyLockTime(lockTime, delayedPayoutTx);
        Coin outputAmount = hashedMultiSigOutput.getValue().subtract(minerFee);
        delayedPayoutTx.addOutput(outputAmount, Address.fromString((NetworkParameters)this.params, (String)donationAddressString));
        WalletService.printTx("Unsigned delayedPayoutTx ToDonationAddress", delayedPayoutTx);
        WalletService.verifyTransaction(delayedPayoutTx);
        return delayedPayoutTx;
    }

    public byte[] signDelayedPayoutTx(Transaction delayedPayoutTx, Transaction preparedDepositTx, DeterministicKey myMultiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey) throws AddressFormatException, TransactionVerificationException {
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        Coin delayedPayoutTxInputValue = preparedDepositTx.getOutput(0L).getValue();
        Sha256Hash sigHash = delayedPayoutTx.hashForWitnessSignature(0, redeemScript, delayedPayoutTxInputValue, Transaction.SigHash.ALL, false);
        Preconditions.checkNotNull((Object)myMultiSigKeyPair, (Object)"myMultiSigKeyPair must not be null");
        if (myMultiSigKeyPair.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        ECKey.ECDSASignature mySignature = myMultiSigKeyPair.sign(sigHash, this.aesKey).toCanonicalised();
        WalletService.printTx("delayedPayoutTx for sig creation", delayedPayoutTx);
        WalletService.verifyTransaction(delayedPayoutTx);
        return mySignature.encodeToDER();
    }

    public Transaction finalizeUnconnectedDelayedPayoutTx(Transaction delayedPayoutTx, byte[] buyerPubKey, byte[] sellerPubKey, byte[] buyerSignature, byte[] sellerSignature, Coin inputValue) throws AddressFormatException, TransactionVerificationException, SignatureDecodeException {
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        ECKey.ECDSASignature buyerECDSASignature = ECKey.ECDSASignature.decodeFromDER((byte[])buyerSignature);
        ECKey.ECDSASignature sellerECDSASignature = ECKey.ECDSASignature.decodeFromDER((byte[])sellerSignature);
        TransactionSignature buyerTxSig = new TransactionSignature(buyerECDSASignature, Transaction.SigHash.ALL, false);
        TransactionSignature sellerTxSig = new TransactionSignature(sellerECDSASignature, Transaction.SigHash.ALL, false);
        TransactionInput input = delayedPayoutTx.getInput(0L);
        input.setScriptSig(ScriptBuilder.createEmpty());
        TransactionWitness witness = TransactionWitness.redeemP2WSH((Script)redeemScript, (TransactionSignature[])new TransactionSignature[]{sellerTxSig, buyerTxSig});
        input.setWitness(witness);
        WalletService.printTx("finalizeDelayedPayoutTx", delayedPayoutTx);
        WalletService.verifyTransaction(delayedPayoutTx);
        if (((Coin)Preconditions.checkNotNull((Object)inputValue)).isLessThan(delayedPayoutTx.getOutputSum().add(MIN_DELAYED_PAYOUT_TX_FEE))) {
            throw new TransactionVerificationException("Delayed payout tx is paying less than the minimum allowed tx fee");
        }
        Script scriptPubKey = this.get2of2MultiSigOutputScript(buyerPubKey, sellerPubKey, false);
        input.getScriptSig().correctlySpends(delayedPayoutTx, 0, witness, inputValue, scriptPubKey, (Set)Script.ALL_VERIFY_FLAGS);
        return delayedPayoutTx;
    }

    public Transaction finalizeDelayedPayoutTx(Transaction delayedPayoutTx, byte[] buyerPubKey, byte[] sellerPubKey, byte[] buyerSignature, byte[] sellerSignature) throws AddressFormatException, TransactionVerificationException, WalletException, SignatureDecodeException {
        TransactionInput input = delayedPayoutTx.getInput(0L);
        this.finalizeUnconnectedDelayedPayoutTx(delayedPayoutTx, buyerPubKey, sellerPubKey, buyerSignature, sellerSignature, input.getValue());
        WalletService.checkWalletConsistency(this.wallet);
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        input.verify(input.getConnectedOutput());
        return delayedPayoutTx;
    }

    public byte[] buyerSignsPayoutTx(Transaction depositTx, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerPayoutAddressString, String sellerPayoutAddressString, DeterministicKey multiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey) throws AddressFormatException, TransactionVerificationException {
        Sha256Hash sigHash;
        Transaction preparedPayoutTx = this.createPayoutTx(depositTx, buyerPayoutAmount, sellerPayoutAmount, buyerPayoutAddressString, sellerPayoutAddressString);
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        if (ScriptPattern.isP2SH((Script)hashedMultiSigOutput.getScriptPubKey())) {
            sigHash = preparedPayoutTx.hashForSignature(0, redeemScript, Transaction.SigHash.ALL, false);
        } else {
            Coin inputValue = hashedMultiSigOutput.getValue();
            sigHash = preparedPayoutTx.hashForWitnessSignature(0, redeemScript, inputValue, Transaction.SigHash.ALL, false);
        }
        Preconditions.checkNotNull((Object)multiSigKeyPair, (Object)"multiSigKeyPair must not be null");
        if (multiSigKeyPair.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        ECKey.ECDSASignature buyerSignature = multiSigKeyPair.sign(sigHash, this.aesKey).toCanonicalised();
        WalletService.printTx("prepared payoutTx", preparedPayoutTx);
        WalletService.verifyTransaction(preparedPayoutTx);
        return buyerSignature.encodeToDER();
    }

    @Deprecated
    public Transaction sellerSignsAndFinalizesPayoutTx(Transaction depositTx, byte[] buyerSignature, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerPayoutAddressString, String sellerPayoutAddressString, DeterministicKey multiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey) throws AddressFormatException, TransactionVerificationException, WalletException, SignatureDecodeException {
        Sha256Hash sigHash;
        Transaction payoutTx = this.createPayoutTx(depositTx, buyerPayoutAmount, sellerPayoutAmount, buyerPayoutAddressString, sellerPayoutAddressString);
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        boolean hashedMultiSigOutputIsLegacy = ScriptPattern.isP2SH((Script)hashedMultiSigOutput.getScriptPubKey());
        if (hashedMultiSigOutputIsLegacy) {
            sigHash = payoutTx.hashForSignature(0, redeemScript, Transaction.SigHash.ALL, false);
        } else {
            Coin inputValue = hashedMultiSigOutput.getValue();
            sigHash = payoutTx.hashForWitnessSignature(0, redeemScript, inputValue, Transaction.SigHash.ALL, false);
        }
        Preconditions.checkNotNull((Object)multiSigKeyPair, (Object)"multiSigKeyPair must not be null");
        if (multiSigKeyPair.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        ECKey.ECDSASignature sellerSignature = multiSigKeyPair.sign(sigHash, this.aesKey).toCanonicalised();
        TransactionSignature buyerTxSig = new TransactionSignature(ECKey.ECDSASignature.decodeFromDER((byte[])buyerSignature), Transaction.SigHash.ALL, false);
        TransactionSignature sellerTxSig = new TransactionSignature(sellerSignature, Transaction.SigHash.ALL, false);
        TransactionInput input = payoutTx.getInput(0L);
        if (hashedMultiSigOutputIsLegacy) {
            Script inputScript = ScriptBuilder.createP2SHMultiSigInputScript((List)ImmutableList.of((Object)sellerTxSig, (Object)buyerTxSig), (Script)redeemScript);
            input.setScriptSig(inputScript);
        } else {
            input.setScriptSig(ScriptBuilder.createEmpty());
            TransactionWitness witness = TransactionWitness.redeemP2WSH((Script)redeemScript, (TransactionSignature[])new TransactionSignature[]{sellerTxSig, buyerTxSig});
            input.setWitness(witness);
        }
        WalletService.printTx("payoutTx", payoutTx);
        WalletService.verifyTransaction(payoutTx);
        WalletService.checkWalletConsistency(this.wallet);
        WalletService.checkScriptSig(payoutTx, input, 0);
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        input.verify(input.getConnectedOutput());
        return payoutTx;
    }

    public byte[] signMediatedPayoutTx(Transaction depositTx, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerPayoutAddressString, String sellerPayoutAddressString, DeterministicKey myMultiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey) throws AddressFormatException, TransactionVerificationException {
        Sha256Hash sigHash;
        Transaction preparedPayoutTx = this.createPayoutTx(depositTx, buyerPayoutAmount, sellerPayoutAmount, buyerPayoutAddressString, sellerPayoutAddressString);
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        boolean hashedMultiSigOutputIsLegacy = ScriptPattern.isP2SH((Script)hashedMultiSigOutput.getScriptPubKey());
        if (hashedMultiSigOutputIsLegacy) {
            sigHash = preparedPayoutTx.hashForSignature(0, redeemScript, Transaction.SigHash.ALL, false);
        } else {
            Coin inputValue = hashedMultiSigOutput.getValue();
            sigHash = preparedPayoutTx.hashForWitnessSignature(0, redeemScript, inputValue, Transaction.SigHash.ALL, false);
        }
        Preconditions.checkNotNull((Object)myMultiSigKeyPair, (Object)"myMultiSigKeyPair must not be null");
        if (myMultiSigKeyPair.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        ECKey.ECDSASignature mySignature = myMultiSigKeyPair.sign(sigHash, this.aesKey).toCanonicalised();
        WalletService.printTx("prepared mediated payoutTx for sig creation", preparedPayoutTx);
        WalletService.verifyTransaction(preparedPayoutTx);
        return mySignature.encodeToDER();
    }

    public Transaction finalizeMediatedPayoutTx(Transaction depositTx, byte[] buyerSignature, byte[] sellerSignature, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerPayoutAddressString, String sellerPayoutAddressString, DeterministicKey multiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey) throws AddressFormatException, TransactionVerificationException, WalletException, SignatureDecodeException {
        Transaction payoutTx = this.createPayoutTx(depositTx, buyerPayoutAmount, sellerPayoutAmount, buyerPayoutAddressString, sellerPayoutAddressString);
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        Preconditions.checkNotNull((Object)multiSigKeyPair, (Object)"multiSigKeyPair must not be null");
        TransactionSignature buyerTxSig = new TransactionSignature(ECKey.ECDSASignature.decodeFromDER((byte[])buyerSignature), Transaction.SigHash.ALL, false);
        TransactionSignature sellerTxSig = new TransactionSignature(ECKey.ECDSASignature.decodeFromDER((byte[])sellerSignature), Transaction.SigHash.ALL, false);
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        boolean hashedMultiSigOutputIsLegacy = ScriptPattern.isP2SH((Script)hashedMultiSigOutput.getScriptPubKey());
        TransactionInput input = payoutTx.getInput(0L);
        if (hashedMultiSigOutputIsLegacy) {
            Script inputScript = ScriptBuilder.createP2SHMultiSigInputScript((List)ImmutableList.of((Object)sellerTxSig, (Object)buyerTxSig), (Script)redeemScript);
            input.setScriptSig(inputScript);
        } else {
            input.setScriptSig(ScriptBuilder.createEmpty());
            TransactionWitness witness = TransactionWitness.redeemP2WSH((Script)redeemScript, (TransactionSignature[])new TransactionSignature[]{sellerTxSig, buyerTxSig});
            input.setWitness(witness);
        }
        WalletService.printTx("mediated payoutTx", payoutTx);
        WalletService.verifyTransaction(payoutTx);
        WalletService.checkWalletConsistency(this.wallet);
        WalletService.checkScriptSig(payoutTx, input, 0);
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        input.verify(input.getConnectedOutput());
        return payoutTx;
    }

    public Transaction traderSignAndFinalizeDisputedPayoutTx(byte[] depositTxSerialized, byte[] arbitratorSignature, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerAddressString, String sellerAddressString, DeterministicKey tradersMultiSigKeyPair, byte[] buyerPubKey, byte[] sellerPubKey, byte[] arbitratorPubKey) throws AddressFormatException, TransactionVerificationException, WalletException, SignatureDecodeException {
        Sha256Hash sigHash;
        boolean hashedMultiSigOutputIsLegacy;
        Transaction depositTx = new Transaction(this.params, depositTxSerialized);
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        Transaction payoutTx = new Transaction(this.params);
        payoutTx.addInput(hashedMultiSigOutput);
        if (buyerPayoutAmount.isPositive()) {
            payoutTx.addOutput(buyerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)buyerAddressString));
        }
        if (sellerPayoutAmount.isPositive()) {
            payoutTx.addOutput(sellerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)sellerAddressString));
        }
        Script redeemScript = this.get2of3MultiSigRedeemScript(buyerPubKey, sellerPubKey, arbitratorPubKey);
        boolean bl = hashedMultiSigOutputIsLegacy = !ScriptPattern.isP2SH((Script)hashedMultiSigOutput.getScriptPubKey());
        if (hashedMultiSigOutputIsLegacy) {
            sigHash = payoutTx.hashForSignature(0, redeemScript, Transaction.SigHash.ALL, false);
        } else {
            Coin inputValue = hashedMultiSigOutput.getValue();
            sigHash = payoutTx.hashForWitnessSignature(0, redeemScript, inputValue, Transaction.SigHash.ALL, false);
        }
        Preconditions.checkNotNull((Object)tradersMultiSigKeyPair, (Object)"tradersMultiSigKeyPair must not be null");
        if (tradersMultiSigKeyPair.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        ECKey.ECDSASignature tradersSignature = tradersMultiSigKeyPair.sign(sigHash, this.aesKey).toCanonicalised();
        TransactionSignature tradersTxSig = new TransactionSignature(tradersSignature, Transaction.SigHash.ALL, false);
        TransactionSignature arbitratorTxSig = new TransactionSignature(ECKey.ECDSASignature.decodeFromDER((byte[])arbitratorSignature), Transaction.SigHash.ALL, false);
        TransactionInput input = payoutTx.getInput(0L);
        if (hashedMultiSigOutputIsLegacy) {
            Script inputScript = ScriptBuilder.createP2SHMultiSigInputScript((List)ImmutableList.of((Object)arbitratorTxSig, (Object)tradersTxSig), (Script)redeemScript);
            input.setScriptSig(inputScript);
        } else {
            input.setScriptSig(ScriptBuilder.createEmpty());
            TransactionWitness witness = TransactionWitness.redeemP2WSH((Script)redeemScript, (TransactionSignature[])new TransactionSignature[]{arbitratorTxSig, tradersTxSig});
            input.setWitness(witness);
        }
        WalletService.printTx("disputed payoutTx", payoutTx);
        WalletService.verifyTransaction(payoutTx);
        WalletService.checkWalletConsistency(this.wallet);
        WalletService.checkScriptSig(payoutTx, input, 0);
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        input.verify(input.getConnectedOutput());
        return payoutTx;
    }

    public Tuple2<String, String> emergencyBuildPayoutTxFrom2of2MultiSig(String depositTxHex, Coin buyerPayoutAmount, Coin sellerPayoutAmount, Coin txFee, String buyerAddressString, String sellerAddressString, String buyerPubKeyAsHex, String sellerPubKeyAsHex, boolean hashedMultiSigOutputIsLegacy) {
        byte[] buyerPubKey = ECKey.fromPublicOnly((byte[])Utils.HEX.decode((CharSequence)buyerPubKeyAsHex)).getPubKey();
        byte[] sellerPubKey = ECKey.fromPublicOnly((byte[])Utils.HEX.decode((CharSequence)sellerPubKeyAsHex)).getPubKey();
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        Coin msOutputValue = buyerPayoutAmount.add(sellerPayoutAmount).add(txFee);
        Transaction payoutTx = new Transaction(this.params);
        Sha256Hash spendTxHash = Sha256Hash.wrap((String)depositTxHex);
        payoutTx.addInput(new TransactionInput(this.params, payoutTx, new byte[0], new TransactionOutPoint(this.params, 0L, spendTxHash), msOutputValue));
        if (buyerPayoutAmount.isPositive()) {
            payoutTx.addOutput(buyerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)buyerAddressString));
        }
        if (sellerPayoutAmount.isPositive()) {
            payoutTx.addOutput(sellerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)sellerAddressString));
        }
        String redeemScriptHex = Utils.HEX.encode(redeemScript.getProgram());
        String unsignedTxHex = Utils.HEX.encode(payoutTx.bitcoinSerialize(!hashedMultiSigOutputIsLegacy));
        return new Tuple2((Object)redeemScriptHex, (Object)unsignedTxHex);
    }

    public String emergencyGenerateSignature(String rawTxHex, String redeemScriptHex, Coin inputValue, String myPrivKeyAsHex) throws IllegalArgumentException {
        boolean hashedMultiSigOutputIsLegacy = true;
        if (rawTxHex.startsWith("010000000001")) {
            hashedMultiSigOutputIsLegacy = false;
        }
        byte[] payload = Utils.HEX.decode((CharSequence)rawTxHex);
        Transaction payoutTx = new Transaction(this.params, payload, null, this.params.getDefaultSerializer(), payload.length);
        Script redeemScript = new Script(Utils.HEX.decode((CharSequence)redeemScriptHex));
        Sha256Hash sigHash = hashedMultiSigOutputIsLegacy ? payoutTx.hashForSignature(0, redeemScript, Transaction.SigHash.ALL, false) : payoutTx.hashForWitnessSignature(0, redeemScript, inputValue, Transaction.SigHash.ALL, false);
        ECKey myPrivateKey = ECKey.fromPrivate((byte[])Utils.HEX.decode((CharSequence)myPrivKeyAsHex));
        Preconditions.checkNotNull((Object)myPrivateKey, (Object)"key must not be null");
        ECKey.ECDSASignature myECDSASignature = myPrivateKey.sign(sigHash, this.aesKey).toCanonicalised();
        TransactionSignature myTxSig = new TransactionSignature(myECDSASignature, Transaction.SigHash.ALL, false);
        return Utils.HEX.encode(myTxSig.encodeToBitcoin());
    }

    public Tuple2<String, String> emergencyApplySignatureToPayoutTxFrom2of2MultiSig(String unsignedTxHex, String redeemScriptHex, String buyerSignatureAsHex, String sellerSignatureAsHex, boolean hashedMultiSigOutputIsLegacy) throws AddressFormatException, SignatureDecodeException {
        Transaction payoutTx = new Transaction(this.params, Utils.HEX.decode((CharSequence)unsignedTxHex));
        TransactionSignature buyerTxSig = TransactionSignature.decodeFromBitcoin((byte[])Utils.HEX.decode((CharSequence)buyerSignatureAsHex), (boolean)true, (boolean)true);
        TransactionSignature sellerTxSig = TransactionSignature.decodeFromBitcoin((byte[])Utils.HEX.decode((CharSequence)sellerSignatureAsHex), (boolean)true, (boolean)true);
        Script redeemScript = new Script(Utils.HEX.decode((CharSequence)redeemScriptHex));
        TransactionInput input = payoutTx.getInput(0L);
        if (hashedMultiSigOutputIsLegacy) {
            Script inputScript = ScriptBuilder.createP2SHMultiSigInputScript((List)ImmutableList.of((Object)sellerTxSig, (Object)buyerTxSig), (Script)redeemScript);
            input.setScriptSig(inputScript);
        } else {
            input.setScriptSig(ScriptBuilder.createEmpty());
            TransactionWitness witness = TransactionWitness.redeemP2WSH((Script)redeemScript, (TransactionSignature[])new TransactionSignature[]{sellerTxSig, buyerTxSig});
            input.setWitness(witness);
        }
        String txId = payoutTx.getTxId().toString();
        String signedTxHex = Utils.HEX.encode(payoutTx.bitcoinSerialize(!hashedMultiSigOutputIsLegacy));
        return new Tuple2((Object)txId, (Object)signedTxHex);
    }

    public Transaction getWalletTx(Sha256Hash txId) {
        Preconditions.checkNotNull((Object)this.wallet);
        return this.wallet.getTransaction(txId);
    }

    public void commitTx(Transaction tx) {
        Preconditions.checkNotNull((Object)this.wallet);
        this.wallet.commitTx(tx);
    }

    public Transaction getClonedTransaction(Transaction tx) {
        return new Transaction(this.params, tx.bitcoinSerialize());
    }

    private RawTransactionInput getRawInputFromTransactionInput(@NotNull TransactionInput input) {
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        Preconditions.checkNotNull((Object)input.getConnectedOutput().getParentTransaction(), (Object)"input.getConnectedOutput().getParentTransaction() must not be null");
        Preconditions.checkNotNull((Object)input.getValue(), (Object)"input.getValue() must not be null");
        return new RawTransactionInput(input.getOutpoint().getIndex(), input.getConnectedOutput().getParentTransaction().bitcoinSerialize(false), input.getValue().value);
    }

    private TransactionInput getTransactionInput(Transaction depositTx, byte[] scriptProgram, RawTransactionInput rawTransactionInput) {
        return new TransactionInput(this.params, depositTx, scriptProgram, this.getConnectedOutPoint(rawTransactionInput), Coin.valueOf((long)rawTransactionInput.value));
    }

    private TransactionOutPoint getConnectedOutPoint(RawTransactionInput rawTransactionInput) {
        return new TransactionOutPoint(this.params, rawTransactionInput.index, new Transaction(this.params, rawTransactionInput.parentTransaction));
    }

    public boolean isP2WH(RawTransactionInput rawTransactionInput) {
        return ScriptPattern.isP2WH((Script)((TransactionOutput)Preconditions.checkNotNull((Object)this.getConnectedOutPoint(rawTransactionInput).getConnectedOutput())).getScriptPubKey());
    }

    private Script get2of3MultiSigRedeemScript(byte[] buyerPubKey, byte[] sellerPubKey, byte[] arbitratorPubKey) {
        ECKey buyerKey = ECKey.fromPublicOnly((byte[])buyerPubKey);
        ECKey sellerKey = ECKey.fromPublicOnly((byte[])sellerPubKey);
        ECKey arbitratorKey = ECKey.fromPublicOnly((byte[])arbitratorPubKey);
        ImmutableList keys = ImmutableList.of((Object)arbitratorKey, (Object)sellerKey, (Object)buyerKey);
        return ScriptBuilder.createMultiSigOutputScript((int)2, (List)keys);
    }

    private Script get2of2MultiSigRedeemScript(byte[] buyerPubKey, byte[] sellerPubKey) {
        ECKey buyerKey = ECKey.fromPublicOnly((byte[])buyerPubKey);
        ECKey sellerKey = ECKey.fromPublicOnly((byte[])sellerPubKey);
        ImmutableList keys = ImmutableList.of((Object)sellerKey, (Object)buyerKey);
        return ScriptBuilder.createMultiSigOutputScript((int)2, (List)keys);
    }

    private Script get2of2MultiSigOutputScript(byte[] buyerPubKey, byte[] sellerPubKey, boolean legacy) {
        Script redeemScript = this.get2of2MultiSigRedeemScript(buyerPubKey, sellerPubKey);
        if (legacy) {
            return ScriptBuilder.createP2SHOutputScript((Script)redeemScript);
        }
        return ScriptBuilder.createP2WSHOutputScript((Script)redeemScript);
    }

    private Transaction createPayoutTx(Transaction depositTx, Coin buyerPayoutAmount, Coin sellerPayoutAmount, String buyerAddressString, String sellerAddressString) throws AddressFormatException {
        TransactionOutput hashedMultiSigOutput = depositTx.getOutput(0L);
        Transaction transaction = new Transaction(this.params);
        transaction.addInput(hashedMultiSigOutput);
        if (buyerPayoutAmount.isPositive()) {
            transaction.addOutput(buyerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)buyerAddressString));
        }
        if (sellerPayoutAmount.isPositive()) {
            transaction.addOutput(sellerPayoutAmount, Address.fromString((NetworkParameters)this.params, (String)sellerAddressString));
        }
        Preconditions.checkArgument((transaction.getOutputs().size() >= 1 ? 1 : 0) != 0, (Object)"We need at least one output.");
        return transaction;
    }

    private void signInput(Transaction transaction, TransactionInput input, int inputIndex) throws SigningException {
        Preconditions.checkNotNull((Object)input.getConnectedOutput(), (Object)"input.getConnectedOutput() must not be null");
        Script scriptPubKey = input.getConnectedOutput().getScriptPubKey();
        Preconditions.checkNotNull((Object)this.wallet);
        ECKey sigKey = input.getOutpoint().getConnectedKey((KeyBag)this.wallet);
        Preconditions.checkNotNull((Object)sigKey, (Object)("signInput: sigKey must not be null. input.getOutpoint()=" + input.getOutpoint().toString()));
        if (sigKey.isEncrypted()) {
            Preconditions.checkNotNull((Object)this.aesKey);
        }
        if (ScriptPattern.isP2PK((Script)scriptPubKey) || ScriptPattern.isP2PKH((Script)scriptPubKey)) {
            Sha256Hash hash = transaction.hashForSignature(inputIndex, scriptPubKey, Transaction.SigHash.ALL, false);
            ECKey.ECDSASignature signature = sigKey.sign(hash, this.aesKey);
            TransactionSignature txSig = new TransactionSignature(signature, Transaction.SigHash.ALL, false);
            if (ScriptPattern.isP2PK((Script)scriptPubKey)) {
                input.setScriptSig(ScriptBuilder.createInputScript((TransactionSignature)txSig));
            } else if (ScriptPattern.isP2PKH((Script)scriptPubKey)) {
                input.setScriptSig(ScriptBuilder.createInputScript((TransactionSignature)txSig, (ECKey)sigKey));
            }
        } else if (ScriptPattern.isP2WPKH((Script)scriptPubKey)) {
            Script scriptCode = ScriptBuilder.createP2PKHOutputScript((ECKey)sigKey);
            Coin value = input.getValue();
            TransactionSignature txSig = transaction.calculateWitnessSignature(inputIndex, sigKey, this.aesKey, scriptCode, value, Transaction.SigHash.ALL, false);
            input.setScriptSig(ScriptBuilder.createEmpty());
            input.setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)txSig, (ECKey)sigKey));
        } else {
            throw new SigningException("Don't know how to sign for this kind of scriptPubKey: " + String.valueOf(scriptPubKey));
        }
    }

    private void addAvailableInputsAndChangeOutputs(Transaction transaction, Address address, Address changeAddress) throws WalletException {
        SendRequest sendRequest = null;
        try {
            sendRequest = SendRequest.forTx((Transaction)transaction);
            sendRequest.shuffleOutputs = false;
            sendRequest.aesKey = this.aesKey;
            sendRequest.fee = Coin.ZERO;
            sendRequest.feePerKb = Coin.ZERO;
            sendRequest.ensureMinRequiredFee = false;
            sendRequest.coinSelector = new BtcCoinSelector(address, (long)this.preferences.getIgnoreDustThreshold());
            sendRequest.changeAddress = changeAddress;
            Preconditions.checkNotNull((Object)this.wallet, (Object)"wallet must not be null");
            this.wallet.completeTx(sendRequest);
        }
        catch (Throwable t) {
            if (sendRequest != null && sendRequest.tx != null) {
                log.warn("addAvailableInputsAndChangeOutputs: sendRequest.tx={}, sendRequest.tx.getOutputs()={}", (Object)sendRequest.tx, (Object)sendRequest.tx.getOutputs());
            }
            throw new WalletException(t);
        }
    }

    private void applyLockTime(long lockTime, Transaction tx) {
        Preconditions.checkArgument((!tx.getInputs().isEmpty() ? 1 : 0) != 0, (String)"The tx must have inputs. tx={}", (Object)tx);
        tx.getInputs().forEach(input -> input.setSequenceNumber(0xFFFFFFFEL));
        tx.setLockTime(lockTime);
    }

    private boolean removeDust(Transaction transaction) {
        List originalTransactionOutputs = transaction.getOutputs();
        ArrayList<TransactionOutput> keepTransactionOutputs = new ArrayList<TransactionOutput>();
        for (TransactionOutput transactionOutput : originalTransactionOutputs) {
            if (transactionOutput.getValue().isLessThan(Restrictions.getMinNonDustOutput())) {
                log.info("your transaction would have contained a dust output of {}", (Object)transactionOutput.toString());
                continue;
            }
            keepTransactionOutputs.add(transactionOutput);
        }
        if (keepTransactionOutputs.size() != originalTransactionOutputs.size()) {
            log.info("dust output was detected and removed, the new output is as follows:");
            transaction.clearOutputs();
            for (TransactionOutput transactionOutput : keepTransactionOutputs) {
                transaction.addOutput(transactionOutput);
                log.info("{}", (Object)transactionOutput.toString());
            }
            return true;
        }
        return false;
    }
}

