/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.core.xmr.wallet.Restrictions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HavenoDefaultCoinSelector
implements CoinSelector {
    private static final Logger log = LoggerFactory.getLogger(HavenoDefaultCoinSelector.class);
    protected final boolean permitForeignPendingTx;
    @Nullable
    protected Set<TransactionOutput> utxoCandidates;

    public CoinSelection select(Coin target, Set<TransactionOutput> candidates) {
        return this.select(target, new ArrayList<TransactionOutput>(candidates));
    }

    public HavenoDefaultCoinSelector(boolean permitForeignPendingTx) {
        this.permitForeignPendingTx = permitForeignPendingTx;
    }

    public HavenoDefaultCoinSelector() {
        this.permitForeignPendingTx = false;
    }

    public CoinSelection select(Coin target, List<TransactionOutput> candidates) {
        ArrayList<TransactionOutput> sortedOutputs;
        ArrayList<TransactionOutput> selected = new ArrayList<TransactionOutput>();
        if (this.utxoCandidates != null) {
            sortedOutputs = new ArrayList<TransactionOutput>(this.utxoCandidates);
            this.utxoCandidates = null;
        } else {
            sortedOutputs = new ArrayList<TransactionOutput>(candidates);
        }
        if (!target.equals((Object)NetworkParameters.MAX_MONEY)) {
            this.sortOutputs(sortedOutputs);
        }
        long total = 0L;
        long targetValue = target.value;
        for (TransactionOutput output : sortedOutputs) {
            long change;
            if (this.isDustAttackUtxo(output)) continue;
            if (total >= targetValue && ((change = total - targetValue) == 0L || change >= Restrictions.getMinNonDustOutput().value)) break;
            if (output.getParentTransaction() == null || !this.isTxSpendable(output.getParentTransaction()) || !this.isTxOutputSpendable(output)) continue;
            selected.add(output);
            total += output.getValue().value;
        }
        return new CoinSelection(Coin.valueOf((long)total), selected);
    }

    protected abstract boolean isDustAttackUtxo(TransactionOutput var1);

    public Coin getChange(Coin target, CoinSelection coinSelection) throws InsufficientMoneyException {
        long available = coinSelection.valueGathered.value;
        long value = target.value;
        long change = available - value;
        if (change < 0L) {
            throw new InsufficientMoneyException(Coin.valueOf((long)(change * -1L)));
        }
        return Coin.valueOf((long)change);
    }

    protected boolean isTxSpendable(Transaction tx) {
        TransactionConfidence confidence = tx.getConfidence();
        TransactionConfidence.ConfidenceType type = confidence.getConfidenceType();
        boolean isConfirmed = type.equals((Object)TransactionConfidence.ConfidenceType.BUILDING);
        boolean isPending = type.equals((Object)TransactionConfidence.ConfidenceType.PENDING);
        boolean isOwnTx = confidence.getSource().equals((Object)TransactionConfidence.Source.SELF);
        return isConfirmed || isPending && (this.permitForeignPendingTx || isOwnTx);
    }

    abstract boolean isTxOutputSpendable(TransactionOutput var1);

    protected void sortOutputs(ArrayList<TransactionOutput> outputs) {
        Collections.sort(outputs, (a, b) -> {
            int depth1 = a.getParentTransactionDepthInBlocks();
            int depth2 = b.getParentTransactionDepthInBlocks();
            Coin aValue = a.getValue();
            Coin bValue = b.getValue();
            BigInteger aCoinDepth = BigInteger.valueOf(aValue.value).multiply(BigInteger.valueOf(depth1));
            BigInteger bCoinDepth = BigInteger.valueOf(bValue.value).multiply(BigInteger.valueOf(depth2));
            int c1 = bCoinDepth.compareTo(aCoinDepth);
            if (c1 != 0) {
                return c1;
            }
            int c2 = bValue.compareTo(aValue);
            if (c2 != 0) {
                return c2;
            }
            BigInteger aHash = a.getParentTransactionHash() != null ? a.getParentTransactionHash().toBigInteger() : BigInteger.ZERO;
            BigInteger bHash = b.getParentTransactionHash() != null ? b.getParentTransactionHash().toBigInteger() : BigInteger.ZERO;
            return aHash.compareTo(bHash);
        });
    }

    public void setUtxoCandidates(@Nullable Set<TransactionOutput> utxoCandidates) {
        this.utxoCandidates = utxoCandidates;
    }
}

