/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import haveno.common.util.Tuple2;
import haveno.core.user.Preferences;
import haveno.core.xmr.exceptions.AddressEntryException;
import haveno.core.xmr.exceptions.InsufficientFundsException;
import haveno.core.xmr.exceptions.TransactionVerificationException;
import haveno.core.xmr.exceptions.WalletException;
import haveno.core.xmr.model.AddressEntry;
import haveno.core.xmr.model.AddressEntryList;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcCoinSelector;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.WalletService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.SegwitAddress;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.wallet.SendRequest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BtcWalletService
extends WalletService {
    private static final Logger log = LoggerFactory.getLogger(BtcWalletService.class);
    private final AddressEntryList addressEntryList;

    @Inject
    public BtcWalletService(WalletsSetup walletsSetup, AddressEntryList addressEntryList, Preferences preferences) {
        super(walletsSetup, preferences);
        this.addressEntryList = addressEntryList;
        walletsSetup.addSetupCompletedHandler(() -> {});
    }

    @Override
    public boolean isWalletSyncedWithinTolerance() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    void decryptWallet(@NotNull KeyParameter key) {
        super.decryptWallet(key);
        this.addressEntryList.getAddressEntriesAsListImmutable().forEach(e -> {
            DeterministicKey keyPair = e.getKeyPair();
            if (keyPair.isEncrypted()) {
                e.setDeterministicKey(keyPair.decrypt(key));
            }
        });
        this.addressEntryList.requestPersistence();
    }

    @Override
    void encryptWallet(KeyCrypterScrypt keyCrypterScrypt, KeyParameter key) {
        super.encryptWallet(keyCrypterScrypt, key);
        this.addressEntryList.getAddressEntriesAsListImmutable().forEach(e -> {
            DeterministicKey keyPair = e.getKeyPair();
            if (keyPair.isEncrypted()) {
                e.setDeterministicKey(keyPair.encrypt((KeyCrypter)keyCrypterScrypt, key));
            }
        });
        this.addressEntryList.requestPersistence();
    }

    @Override
    String getWalletAsString(boolean includePrivKeys) {
        StringBuilder sb = new StringBuilder();
        this.getAddressEntryListAsImmutableList().forEach(e -> sb.append(e.toString()).append("\n"));
        return "Address entry list:\n" + sb.toString() + "\n\n" + this.wallet.toString(true, includePrivKeys, this.aesKey, true, true, (AbstractBlockChain)this.walletsSetup.getChain()) + "\n\nAll pubKeys as hex:\n" + this.wallet.printAllPubKeysAsHex();
    }

    private Tuple2<Integer, Integer> getNumInputs(Transaction tx) {
        int numLegacyInputs = 0;
        int numSegwitInputs = 0;
        for (TransactionInput input : tx.getInputs()) {
            TransactionOutput connectedOutput = input.getConnectedOutput();
            if (connectedOutput == null || ScriptPattern.isP2PKH((Script)connectedOutput.getScriptPubKey()) || ScriptPattern.isP2PK((Script)connectedOutput.getScriptPubKey())) {
                ++numLegacyInputs;
                continue;
            }
            if (ScriptPattern.isP2WPKH((Script)connectedOutput.getScriptPubKey())) {
                ++numSegwitInputs;
                continue;
            }
            throw new IllegalArgumentException("Inputs should spend a P2PKH, P2PK or P2WPKH ouput");
        }
        return new Tuple2((Object)numLegacyInputs, (Object)numSegwitInputs);
    }

    public void commitTx(Transaction tx) {
        this.wallet.commitTx(tx);
    }

    public Optional<AddressEntry> getAddressEntry(String offerId, AddressEntry.Context context) {
        return this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).findAny();
    }

    public AddressEntry getOrCreateAddressEntry(String offerId, AddressEntry.Context context) {
        Optional<AddressEntry> addressEntry = this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).findAny();
        if (addressEntry.isPresent()) {
            return addressEntry.get();
        }
        Optional<AddressEntry> emptyAvailableAddressEntry = this.getAddressEntryListAsImmutableList().stream().filter(e -> AddressEntry.Context.AVAILABLE == e.getContext()).filter(e -> this.isAddressUnused(e.getAddress())).filter(e -> Script.ScriptType.P2WPKH.equals((Object)e.getAddress().getOutputScriptType())).findAny();
        if (emptyAvailableAddressEntry.isPresent()) {
            return this.addressEntryList.swapAvailableToAddressEntryWithOfferId(emptyAvailableAddressEntry.get(), context, offerId);
        }
        DeterministicKey key = (DeterministicKey)this.wallet.findKeyFromAddress(this.wallet.freshReceiveAddress(Script.ScriptType.P2WPKH));
        AddressEntry entry = new AddressEntry(key, context, offerId, true);
        log.info("getOrCreateAddressEntry: new AddressEntry={}", (Object)entry);
        this.addressEntryList.addAddressEntry(entry);
        return entry;
    }

    public AddressEntry getArbitratorAddressEntry() {
        AddressEntry.Context context = AddressEntry.Context.ARBITRATOR;
        Optional<AddressEntry> addressEntry = this.getAddressEntryListAsImmutableList().stream().filter(e -> context == e.getContext()).findAny();
        return this.getOrCreateAddressEntry(context, addressEntry, false);
    }

    public AddressEntry getFreshAddressEntry() {
        return this.getFreshAddressEntry(true);
    }

    public AddressEntry getFreshAddressEntry(boolean segwit) {
        AddressEntry.Context context = AddressEntry.Context.AVAILABLE;
        Optional<AddressEntry> addressEntry = this.getAddressEntryListAsImmutableList().stream().filter(e -> context == e.getContext()).filter(e -> this.isAddressUnused(e.getAddress())).filter(e -> {
            boolean isSegwitOutputScriptType = Script.ScriptType.P2WPKH.equals((Object)e.getAddress().getOutputScriptType());
            return isSegwitOutputScriptType == segwit;
        }).findAny();
        return this.getOrCreateAddressEntry(context, addressEntry, segwit);
    }

    public void recoverAddressEntry(String offerId, String address, AddressEntry.Context context) {
        this.findAddressEntry(address, AddressEntry.Context.AVAILABLE).ifPresent(addressEntry -> this.addressEntryList.swapAvailableToAddressEntryWithOfferId((AddressEntry)addressEntry, context, offerId));
    }

    private AddressEntry getOrCreateAddressEntry(AddressEntry.Context context, Optional<AddressEntry> addressEntry, boolean segwit) {
        if (addressEntry.isPresent()) {
            return addressEntry.get();
        }
        DeterministicKey key = segwit ? (DeterministicKey)this.wallet.findKeyFromAddress(this.wallet.freshReceiveAddress(Script.ScriptType.P2WPKH)) : (DeterministicKey)this.wallet.findKeyFromAddress(this.wallet.freshReceiveAddress(Script.ScriptType.P2PKH));
        AddressEntry entry = new AddressEntry(key, context, segwit);
        log.info("getOrCreateAddressEntry: add new AddressEntry {}", (Object)entry);
        this.addressEntryList.addAddressEntry(entry);
        return entry;
    }

    private Optional<AddressEntry> findAddressEntry(String address, AddressEntry.Context context) {
        return this.getAddressEntryListAsImmutableList().stream().filter(e -> address.equals(e.getAddressString())).filter(e -> context == e.getContext()).findAny();
    }

    public List<AddressEntry> getAvailableAddressEntries() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> AddressEntry.Context.AVAILABLE == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<AddressEntry> getAddressEntriesForOpenOffer() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> AddressEntry.Context.OFFER_FUNDING == addressEntry.getContext() || AddressEntry.Context.RESERVED_FOR_TRADE == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<AddressEntry> getAddressEntriesForTrade() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> AddressEntry.Context.MULTI_SIG == addressEntry.getContext() || AddressEntry.Context.TRADE_PAYOUT == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<AddressEntry> getAddressEntries(AddressEntry.Context context) {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> context == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<AddressEntry> getFundedAvailableAddressEntries() {
        return this.getAvailableAddressEntries().stream().filter(addressEntry -> this.getBalanceForAddress(addressEntry.getAddress()).isPositive()).collect(Collectors.toList());
    }

    public List<AddressEntry> getAddressEntryListAsImmutableList() {
        return this.addressEntryList.getAddressEntriesAsListImmutable();
    }

    public void swapAddressEntryToAvailable(String offerId, AddressEntry.Context context) {
        if (context == AddressEntry.Context.MULTI_SIG) {
            log.error("swapAddressEntryToAvailable called with MULTI_SIG context. This in not permitted as we must not reuse those address entries and there are no redeemable funds on that addresses. Only the keys are used for creating the Multisig address. offerId={}, context={}", (Object)offerId, (Object)context);
            return;
        }
        this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).forEach(e -> {
            log.info("swap addressEntry with address {} and offerId {} from context {} to available", new Object[]{e.getAddressString(), e.getOfferId(), context});
            this.addressEntryList.swapToAvailable((AddressEntry)e);
        });
    }

    public void resetCoinLockedInMultiSigAddressEntry(String offerId) {
        this.setCoinLockedInMultiSigAddressEntry(offerId, 0L);
    }

    public void setCoinLockedInMultiSigAddressEntry(String offerId, long value) {
        this.getAddressEntryListAsImmutableList().stream().filter(e -> AddressEntry.Context.MULTI_SIG == e.getContext()).filter(e -> offerId.equals(e.getOfferId())).forEach(addressEntry -> this.setCoinLockedInMultiSigAddressEntry((AddressEntry)addressEntry, value));
    }

    public void setCoinLockedInMultiSigAddressEntry(AddressEntry addressEntry, long value) {
        log.info("Set coinLockedInMultiSig for addressEntry {} to value {}", (Object)addressEntry, (Object)value);
        this.addressEntryList.setCoinLockedInMultiSigAddressEntry(addressEntry, value);
    }

    public void resetAddressEntriesForOpenOffer(String offerId) {
        log.info("resetAddressEntriesForOpenOffer offerId={}", (Object)offerId);
        this.swapAddressEntryToAvailable(offerId, AddressEntry.Context.OFFER_FUNDING);
        this.swapAddressEntryToAvailable(offerId, AddressEntry.Context.RESERVED_FOR_TRADE);
    }

    public void resetAddressEntriesForPendingTrade(String offerId) {
        this.swapAddressEntryToAvailable(offerId, AddressEntry.Context.TRADE_PAYOUT);
    }

    public void swapAnyTradeEntryContextToAvailableEntry(String offerId) {
        this.resetAddressEntriesForOpenOffer(offerId);
        this.resetAddressEntriesForPendingTrade(offerId);
    }

    public void saveAddressEntryList() {
        this.addressEntryList.requestPersistence();
    }

    public DeterministicKey getMultiSigKeyPair(String tradeId, byte[] pubKey) {
        DeterministicKey multiSigKeyPair;
        Optional<AddressEntry> multiSigAddressEntryOptional = this.getAddressEntry(tradeId, AddressEntry.Context.MULTI_SIG);
        if (multiSigAddressEntryOptional.isPresent()) {
            AddressEntry multiSigAddressEntry = multiSigAddressEntryOptional.get();
            multiSigKeyPair = multiSigAddressEntry.getKeyPair();
            if (!Arrays.equals(pubKey, multiSigAddressEntry.getPubKey())) {
                log.error("Pub Key from AddressEntry does not match key pair from trade data. Trade ID={}\nWe try to find the keypair in the wallet with the pubKey we found in the trade data.", (Object)tradeId);
                multiSigKeyPair = this.findKeyFromPubKey(pubKey);
            }
        } else {
            log.error("multiSigAddressEntry not found for trade ID={}.\nWe try to find the keypair in the wallet with the pubKey we found in the trade data.", (Object)tradeId);
            multiSigKeyPair = this.findKeyFromPubKey(pubKey);
        }
        return multiSigKeyPair;
    }

    public Coin getSavingWalletBalance() {
        return Coin.valueOf((long)this.getFundedAvailableAddressEntries().stream().mapToLong(addressEntry -> this.getBalanceForAddress((Address)addressEntry.getAddress()).value).sum());
    }

    public Stream<AddressEntry> getAddressEntriesForAvailableBalanceStream() {
        Stream availableAndPayout = Stream.concat(this.getAddressEntries(AddressEntry.Context.TRADE_PAYOUT).stream(), this.getFundedAvailableAddressEntries().stream());
        Stream available = Stream.concat(availableAndPayout, this.getAddressEntries(AddressEntry.Context.ARBITRATOR).stream());
        available = Stream.concat(available, this.getAddressEntries(AddressEntry.Context.OFFER_FUNDING).stream());
        return available.filter(addressEntry -> this.getBalanceForAddress(addressEntry.getAddress()).isPositive());
    }

    public Coin getTxFeeForWithdrawalPerVbyte() {
        throw new RuntimeException("BTC fee estimation removed");
    }

    public Transaction getFeeEstimationTransaction(String fromAddress, String toAddress, Coin amount, AddressEntry.Context context) throws AddressFormatException, AddressEntryException, InsufficientFundsException {
        Optional<AddressEntry> addressEntry = this.findAddressEntry(fromAddress, context);
        if (!addressEntry.isPresent()) {
            throw new AddressEntryException("WithdrawFromAddress is not found in our wallet.");
        }
        Preconditions.checkNotNull((Object)addressEntry.get().getAddress(), (Object)"addressEntry.get().getAddress() must nto be null");
        try {
            Transaction tx;
            int counter = 0;
            int txVsize = 0;
            Coin txFeeForWithdrawalPerVbyte = this.getTxFeeForWithdrawalPerVbyte();
            do {
                ++counter;
                Coin fee = txFeeForWithdrawalPerVbyte.multiply((long)txVsize);
                SendRequest sendRequest = this.getSendRequest(fromAddress, toAddress, amount, fee, this.aesKey, context);
                this.wallet.completeTx(sendRequest);
                tx = sendRequest.tx;
                txVsize = tx.getVsize();
                BtcWalletService.printTx("FeeEstimationTransaction", tx);
            } while (this.feeEstimationNotSatisfied(counter, tx));
            if (counter == 10) {
                log.error("Could not calculate the fee. Tx=" + String.valueOf(tx));
            }
            return tx;
        }
        catch (InsufficientMoneyException e) {
            throw new InsufficientFundsException("The fees for that transaction exceed the available funds or the resulting output value is below the min. dust value:\nMissing " + (e.missing != null ? e.missing.toFriendlyString() : "null"));
        }
    }

    public Transaction getFeeEstimationTransactionForMultipleAddresses(Set<String> fromAddresses, Coin amount) throws AddressFormatException, AddressEntryException, InsufficientFundsException {
        Coin txFeeForWithdrawalPerVbyte = this.getTxFeeForWithdrawalPerVbyte();
        return this.getFeeEstimationTransactionForMultipleAddresses(fromAddresses, amount, txFeeForWithdrawalPerVbyte);
    }

    public Transaction getFeeEstimationTransactionForMultipleAddresses(Set<String> fromAddresses, Coin amount, Coin txFeeForWithdrawalPerVbyte) throws AddressFormatException, AddressEntryException, InsufficientFundsException {
        Set addressEntries = fromAddresses.stream().map(address -> {
            Optional<AddressEntry> addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.AVAILABLE);
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.OFFER_FUNDING);
            }
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.TRADE_PAYOUT);
            }
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.ARBITRATOR);
            }
            return addressEntryOptional;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (addressEntries.isEmpty()) {
            throw new AddressEntryException("No Addresses for withdraw  found in our wallet");
        }
        try {
            Transaction tx;
            int counter = 0;
            int txVsize = 0;
            do {
                ++counter;
                Coin fee = txFeeForWithdrawalPerVbyte.multiply((long)txVsize);
                String dummyReceiver = SegwitAddress.fromKey((NetworkParameters)this.params, (ECKey)new ECKey()).toString();
                SendRequest sendRequest = this.getSendRequestForMultipleAddresses(fromAddresses, dummyReceiver, amount, fee, null, this.aesKey);
                this.wallet.completeTx(sendRequest);
                tx = sendRequest.tx;
                txVsize = tx.getVsize();
                BtcWalletService.printTx("FeeEstimationTransactionForMultipleAddresses", tx);
            } while (this.feeEstimationNotSatisfied(counter, tx));
            if (counter == 10) {
                log.error("Could not calculate the fee. Tx=" + String.valueOf(tx));
            }
            return tx;
        }
        catch (InsufficientMoneyException e) {
            throw new InsufficientFundsException("The fees for that transaction exceed the available funds or the resulting output value is below the min. dust value:\nMissing " + (e.missing != null ? e.missing.toFriendlyString() : "null"));
        }
    }

    private boolean feeEstimationNotSatisfied(int counter, Transaction tx) {
        return this.feeEstimationNotSatisfied(counter, tx, this.getTxFeeForWithdrawalPerVbyte());
    }

    private boolean feeEstimationNotSatisfied(int counter, Transaction tx, Coin txFeeForWithdrawalPerVbyte) {
        long targetFee = txFeeForWithdrawalPerVbyte.multiply((long)((long)tx.getVsize())).value;
        return counter < 10 && (tx.getFee().value < targetFee || tx.getFee().value - targetFee > 1000L);
    }

    public int getEstimatedFeeTxVsize(List<Coin> outputValues, Coin txFee) throws InsufficientMoneyException, AddressFormatException {
        Transaction transaction = new Transaction(this.params);
        SegwitAddress dummyAddress = SegwitAddress.fromKey((NetworkParameters)this.params, (ECKey)new ECKey());
        outputValues.forEach(arg_0 -> BtcWalletService.lambda$getEstimatedFeeTxVsize$32(transaction, (Address)dummyAddress, arg_0));
        SendRequest sendRequest = SendRequest.forTx((Transaction)transaction);
        sendRequest.shuffleOutputs = false;
        sendRequest.aesKey = this.aesKey;
        sendRequest.coinSelector = new BtcCoinSelector(this.walletsSetup.getAddressesByContext(AddressEntry.Context.AVAILABLE), (long)this.preferences.getIgnoreDustThreshold());
        sendRequest.fee = txFee;
        sendRequest.feePerKb = Coin.ZERO;
        sendRequest.ensureMinRequiredFee = false;
        sendRequest.changeAddress = dummyAddress;
        this.wallet.completeTx(sendRequest);
        return transaction.getVsize();
    }

    private SendRequest getSendRequest(String fromAddress, String toAddress, Coin amount, Coin fee, @Nullable KeyParameter aesKey, AddressEntry.Context context) throws AddressFormatException, AddressEntryException {
        Transaction tx = new Transaction(this.params);
        Coin receiverAmount = amount.subtract(fee);
        Preconditions.checkArgument((boolean)Restrictions.isAboveDust(receiverAmount), (Object)"The amount is too low (dust limit).");
        tx.addOutput(receiverAmount, Address.fromString((NetworkParameters)this.params, (String)toAddress));
        SendRequest sendRequest = SendRequest.forTx((Transaction)tx);
        sendRequest.fee = fee;
        sendRequest.feePerKb = Coin.ZERO;
        sendRequest.ensureMinRequiredFee = false;
        sendRequest.aesKey = aesKey;
        sendRequest.shuffleOutputs = false;
        Optional<AddressEntry> addressEntry = this.findAddressEntry(fromAddress, context);
        if (!addressEntry.isPresent()) {
            throw new AddressEntryException("WithdrawFromAddress is not found in our wallet.");
        }
        Preconditions.checkNotNull((Object)addressEntry.get(), (Object)"addressEntry.get() must not be null");
        Preconditions.checkNotNull((Object)addressEntry.get().getAddress(), (Object)"addressEntry.get().getAddress() must not be null");
        sendRequest.coinSelector = new BtcCoinSelector(addressEntry.get().getAddress(), (long)this.preferences.getIgnoreDustThreshold());
        sendRequest.changeAddress = addressEntry.get().getAddress();
        return sendRequest;
    }

    private SendRequest getSendRequestForMultipleAddresses(Set<String> fromAddresses, String toAddress, Coin amount, Coin fee, @Nullable String changeAddress, @Nullable KeyParameter aesKey) throws AddressFormatException, AddressEntryException {
        Transaction tx = new Transaction(this.params);
        Coin netValue = amount.subtract(fee);
        Preconditions.checkArgument((boolean)Restrictions.isAboveDust(netValue), (Object)"The amount is too low (dust limit).");
        tx.addOutput(netValue, Address.fromString((NetworkParameters)this.params, (String)toAddress));
        SendRequest sendRequest = SendRequest.forTx((Transaction)tx);
        sendRequest.fee = fee;
        sendRequest.feePerKb = Coin.ZERO;
        sendRequest.ensureMinRequiredFee = false;
        sendRequest.aesKey = aesKey;
        sendRequest.shuffleOutputs = false;
        Set<AddressEntry> addressEntries = fromAddresses.stream().map(address -> {
            Optional<AddressEntry> addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.AVAILABLE);
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.OFFER_FUNDING);
            }
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.TRADE_PAYOUT);
            }
            if (!addressEntryOptional.isPresent()) {
                addressEntryOptional = this.findAddressEntry((String)address, AddressEntry.Context.ARBITRATOR);
            }
            return addressEntryOptional;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (addressEntries.isEmpty()) {
            throw new AddressEntryException("No Addresses for withdraw found in our wallet");
        }
        sendRequest.coinSelector = new BtcCoinSelector(this.walletsSetup.getAddressesFromAddressEntries(addressEntries), (long)this.preferences.getIgnoreDustThreshold());
        Optional<AddressEntry> addressEntryOptional = Optional.empty();
        if (changeAddress != null) {
            addressEntryOptional = this.findAddressEntry(changeAddress, AddressEntry.Context.AVAILABLE);
        }
        AddressEntry changeAddressAddressEntry = addressEntryOptional.orElseGet(this::getFreshAddressEntry);
        Preconditions.checkNotNull((Object)changeAddressAddressEntry, (Object)"change address must not be null");
        sendRequest.changeAddress = changeAddressAddressEntry.getAddress();
        return sendRequest;
    }

    @Override
    protected boolean isDustAttackUtxo(TransactionOutput output) {
        return output.getValue().value < (long)this.preferences.getIgnoreDustThreshold();
    }

    public Transaction createRefundPayoutTx(Coin buyerAmount, Coin sellerAmount, Coin fee, String buyerAddressString, String sellerAddressString) throws AddressFormatException, InsufficientMoneyException, WalletException, TransactionVerificationException {
        Transaction tx = new Transaction(this.params);
        Preconditions.checkArgument((boolean)buyerAmount.add(sellerAmount).isPositive(), (Object)"The sellerAmount + buyerAmount must be positive.");
        if (buyerAmount.isPositive()) {
            Preconditions.checkArgument((boolean)Restrictions.isAboveDust(buyerAmount), (Object)"The buyerAmount is too low (dust limit).");
            tx.addOutput(buyerAmount, Address.fromString((NetworkParameters)this.params, (String)buyerAddressString));
        }
        if (sellerAmount.isPositive()) {
            Preconditions.checkArgument((boolean)Restrictions.isAboveDust(sellerAmount), (Object)"The sellerAmount is too low (dust limit).");
            tx.addOutput(sellerAmount, Address.fromString((NetworkParameters)this.params, (String)sellerAddressString));
        }
        SendRequest sendRequest = SendRequest.forTx((Transaction)tx);
        sendRequest.fee = fee;
        sendRequest.feePerKb = Coin.ZERO;
        sendRequest.ensureMinRequiredFee = false;
        sendRequest.aesKey = this.aesKey;
        sendRequest.shuffleOutputs = false;
        sendRequest.coinSelector = new BtcCoinSelector(this.walletsSetup.getAddressesByContext(AddressEntry.Context.AVAILABLE), (long)this.preferences.getIgnoreDustThreshold());
        sendRequest.changeAddress = this.getFreshAddressEntry().getAddress();
        Preconditions.checkNotNull((Object)this.wallet);
        this.wallet.completeTx(sendRequest);
        Transaction resultTx = sendRequest.tx;
        BtcWalletService.checkWalletConsistency(this.wallet);
        BtcWalletService.verifyTransaction(resultTx);
        WalletService.printTx("createRefundPayoutTx", resultTx);
        return resultTx;
    }

    private static /* synthetic */ void lambda$getEstimatedFeeTxVsize$32(Transaction transaction, Address dummyAddress, Coin outputValue) {
        transaction.addOutput(outputValue, dummyAddress);
    }
}

