/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.setup;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import monero.common.MoneroError;
import monero.wallet.MoneroWalletRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoneroWalletRpcManager {
    private static final Logger log = LoggerFactory.getLogger(MoneroWalletRpcManager.class);
    private static final String RPC_BIND_PORT_ARGUMENT = "--rpc-bind-port";
    private static int NUM_ALLOWED_ATTEMPTS = 2;
    private Integer startPort;
    private final Map<Integer, MoneroWalletRpc> registeredPorts = new HashMap<Integer, MoneroWalletRpc>();

    public MoneroWalletRpcManager() {
    }

    public MoneroWalletRpcManager(int startPort) {
        this.startPort = startPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroWalletRpc startInstance(List<String> cmd) {
        try {
            if (cmd.contains(RPC_BIND_PORT_ARGUMENT)) {
                int portArgumentPosition = cmd.indexOf(RPC_BIND_PORT_ARGUMENT) + 1;
                int port = Integer.parseInt(cmd.get(portArgumentPosition));
                Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
                synchronized (map) {
                    if (this.registeredPorts.containsKey(port)) {
                        throw new RuntimeException("Port " + port + " is already registered");
                    }
                    this.registeredPorts.put(port, null);
                }
                MoneroWalletRpc walletRpc = new MoneroWalletRpc(cmd);
                Map<Integer, MoneroWalletRpc> map2 = this.registeredPorts;
                synchronized (map2) {
                    this.registeredPorts.put(port, walletRpc);
                }
                return walletRpc;
            }
            int numAttempts = 0;
            while (numAttempts < NUM_ALLOWED_ATTEMPTS) {
                try {
                    int port;
                    ++numAttempts;
                    if (this.startPort != null) {
                        port = this.registerNextPort();
                    } else {
                        ServerSocket socket = new ServerSocket(0);
                        port = socket.getLocalPort();
                        socket.close();
                        Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
                        synchronized (map) {
                            this.registeredPorts.put(port, null);
                        }
                    }
                    ArrayList<String> cmdCopy = new ArrayList<String>(cmd);
                    cmdCopy.add(RPC_BIND_PORT_ARGUMENT);
                    cmdCopy.add("" + port);
                    MoneroWalletRpc walletRpc = new MoneroWalletRpc(cmdCopy);
                    Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
                    synchronized (map) {
                        this.registeredPorts.put(port, walletRpc);
                    }
                    return walletRpc;
                }
                catch (Exception e) {
                    if (numAttempts < NUM_ALLOWED_ATTEMPTS) continue;
                    log.error("Unable to start monero-wallet-rpc instance after {} attempts", (Object)NUM_ALLOWED_ATTEMPTS);
                    throw e;
                }
            }
            throw new MoneroError("Failed to start monero-wallet-rpc instance after " + NUM_ALLOWED_ATTEMPTS + " attempts");
        }
        catch (IOException e) {
            throw new MoneroError((Throwable)e);
        }
    }

    public void stopInstance(MoneroWalletRpc walletRpc, String path, boolean force) {
        int port = this.unregisterPort(walletRpc);
        String pid = walletRpc.getProcess() == null ? null : String.valueOf(walletRpc.getProcess().pid());
        log.info("Stopping MoneroWalletRpc path={}, port={}, pid={}, force={}", new Object[]{path, port, pid, force});
        walletRpc.stopProcess(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerNextPort() throws IOException {
        Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
        synchronized (map) {
            int port = this.startPort;
            while (this.registeredPorts.containsKey(port)) {
                ++port;
            }
            this.registeredPorts.put(port, null);
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unregisterPort(MoneroWalletRpc walletRpc) {
        Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
        synchronized (map) {
            int port = -1;
            boolean found = false;
            for (Map.Entry<Integer, MoneroWalletRpc> entry : this.registeredPorts.entrySet()) {
                if (walletRpc != entry.getValue()) continue;
                found = true;
                try {
                    port = entry.getKey();
                    this.removePort(port);
                    break;
                }
                catch (Exception e) {
                    throw new MoneroError((Throwable)e);
                }
            }
            if (!found) {
                throw new RuntimeException("MoneroWalletRpc instance not registered with a port");
            }
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePort(int port) {
        Map<Integer, MoneroWalletRpc> map = this.registeredPorts;
        synchronized (map) {
            this.registeredPorts.remove(port);
        }
    }
}

