/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.network.DnsLookupException;
import haveno.network.DnsLookupTor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.net.OnionCatConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmrNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(XmrNodeConverter.class);
    private final Facade facade;

    XmrNodeConverter() {
        this.facade = new Facade();
    }

    XmrNodeConverter(Facade facade) {
        this.facade = facade;
    }

    @Nullable
    PeerAddress convertOnionHost(XmrNodes.XmrNode node) {
        String onionAddress = Objects.requireNonNull(node.getOnionAddress());
        return new PeerAddress(onionAddress, node.getPort());
    }

    @Nullable
    PeerAddress convertClearNode(XmrNodes.XmrNode node) {
        int port = node.getPort();
        PeerAddress result = XmrNodeConverter.create(node.getHostNameOrAddress(), port);
        if (result == null) {
            String address = node.getAddress();
            if (address != null) {
                result = XmrNodeConverter.create(address, port);
            } else {
                log.warn("Lookup failed, no address for node {}", (Object)node);
            }
        }
        return result;
    }

    @Nullable
    PeerAddress convertWithTor(XmrNodes.XmrNode node, Socks5Proxy proxy) {
        int port = node.getPort();
        PeerAddress result = this.create(proxy, node.getHostNameOrAddress(), port);
        if (result == null) {
            String address = node.getAddress();
            if (address != null) {
                result = this.create(proxy, address, port);
            } else {
                log.warn("Lookup failed, no address for node {}", (Object)node);
            }
        }
        return result;
    }

    @Nullable
    private PeerAddress create(Socks5Proxy proxy, String host, int port) {
        try {
            InetAddress lookupAddress = this.facade.torLookup(proxy, host);
            InetSocketAddress address = new InetSocketAddress(lookupAddress, port);
            return new PeerAddress(address);
        }
        catch (Exception e) {
            log.error("Failed to create peer address", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static PeerAddress create(String hostName, int port) {
        try {
            InetSocketAddress address = new InetSocketAddress(hostName, port);
            return new PeerAddress(address);
        }
        catch (Exception e) {
            log.error("Failed to create peer address", (Throwable)e);
            return null;
        }
    }

    static class Facade {
        Facade() {
        }

        InetAddress onionHostToInetAddress(String onionAddress) throws UnknownHostException {
            return OnionCatConverter.onionHostToInetAddress((String)onionAddress);
        }

        InetAddress torLookup(Socks5Proxy proxy, String host) throws DnsLookupException {
            return DnsLookupTor.lookup((Socks5Proxy)proxy, (String)host);
        }
    }
}

