/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.SocksSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedPeersSocks5Dns
implements PeerDiscovery {
    private final Socks5Proxy proxy;
    private final NetworkParameters params;
    private final InetSocketAddress[] seedAddrs;
    private InetSocketAddress[] seedAddrsIP;
    private int pnseedIndex;
    private final InetSocketAddress[] seedAddrsResolved;
    private static final Logger log = LoggerFactory.getLogger(SeedPeersSocks5Dns.class);

    public SeedPeersSocks5Dns(Socks5Proxy proxy, NetworkParameters params) {
        this.proxy = proxy;
        this.params = params;
        this.seedAddrs = this.convertAddrsString(params.getDnsSeeds(), params.getPort());
        this.seedAddrsResolved = new InetSocketAddress[this.seedAddrs.length];
        System.arraycopy(this.seedAddrsIP, this.seedAddrs.length, this.seedAddrsResolved, this.seedAddrs.length, this.seedAddrsResolved.length - this.seedAddrs.length);
    }

    @Nullable
    public InetSocketAddress getPeer() throws PeerDiscoveryException {
        try {
            return this.nextPeer();
        }
        catch (PeerDiscoveryException e) {
            throw new PeerDiscoveryException((Throwable)e);
        }
    }

    @Nullable
    private InetSocketAddress nextPeer() throws PeerDiscoveryException {
        if (this.seedAddrs == null || this.seedAddrs.length == 0) {
            throw new PeerDiscoveryException("No IP address seeds configured; unable to find any peers");
        }
        if (this.pnseedIndex >= this.seedAddrsResolved.length) {
            return null;
        }
        if (this.seedAddrsResolved[this.pnseedIndex] == null) {
            this.seedAddrsResolved[this.pnseedIndex] = SeedPeersSocks5Dns.lookup(this.proxy, this.seedAddrs[this.pnseedIndex]);
        }
        log.error("SeedPeersSocks5Dns::nextPeer: " + String.valueOf(this.seedAddrsResolved[this.pnseedIndex]));
        return this.seedAddrsResolved[this.pnseedIndex++];
    }

    public InetSocketAddress[] getPeers(long services, long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        if (services != 0L) {
            throw new PeerDiscoveryException("DNS seeds cannot filter by services: " + services);
        }
        return this.allPeers();
    }

    private InetSocketAddress[] allPeers() {
        for (int i = 0; i < this.seedAddrsResolved.length; ++i) {
            if (this.seedAddrsResolved[i] != null) continue;
            this.seedAddrsResolved[i] = SeedPeersSocks5Dns.lookup(this.proxy, this.seedAddrs[i]);
        }
        return this.seedAddrsResolved;
    }

    @Nullable
    public static InetSocketAddress lookup(Socks5Proxy proxy, InetSocketAddress addr) {
        if (!addr.isUnresolved()) {
            return addr;
        }
        try {
            SocksSocket proxySocket = new SocksSocket((SocksProxyBase)proxy, addr.getHostString(), addr.getPort());
            InetAddress addrResolved = proxySocket.getInetAddress();
            proxySocket.close();
            if (addrResolved != null) {
                return new InetSocketAddress(addrResolved, addr.getPort());
            }
            log.error("Connected to " + addr.getHostString() + ".  But did not resolve to address.");
        }
        catch (Exception e) {
            log.warn("Error resolving " + addr.getHostString() + ". Exception:\n" + e.toString());
        }
        return null;
    }

    private InetSocketAddress[] convertAddrsString(String[] addrs, int port) {
        InetSocketAddress[] list = new InetSocketAddress[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            list[i] = InetSocketAddress.createUnresolved(addrs[i], port);
        }
        return list;
    }

    public void shutdown() {
    }
}

