/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.exceptions;

import haveno.core.xmr.exceptions.TxBroadcastException;
import javax.annotation.Nullable;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.wallet.Wallet;

public class TxBroadcastTimeoutException
extends TxBroadcastException {
    @Nullable
    private final Transaction localTx;
    private final int delay;
    private final Wallet wallet;

    public TxBroadcastTimeoutException(Transaction localTx, int delay, Wallet wallet) {
        super("The transaction was not broadcasted in " + delay + " seconds. txId=" + localTx.getTxId().toString());
        this.localTx = localTx;
        this.delay = delay;
        this.wallet = wallet;
    }

    @Override
    public String toString() {
        return "TxBroadcastTimeoutException{\n     localTx=" + String.valueOf(this.localTx) + ",\n     delay=" + this.delay + "\n} " + super.toString();
    }

    @Nullable
    public Transaction getLocalTx() {
        return this.localTx;
    }

    public int getDelay() {
        return this.delay;
    }

    public Wallet getWallet() {
        return this.wallet;
    }
}

