/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;

public class StringValidator
extends InputValidator {
    private int length = 0;

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult validationResult = super.validate(input);
        if (!validationResult.isValid) {
            return validationResult;
        }
        if (!this.isStringWithFixedLength(input, this.length)) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", input));
        }
        return validationResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringValidator)) {
            return false;
        }
        StringValidator other = (StringValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLength();
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        return "StringValidator(length=" + this.getLength() + ")";
    }
}

