/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.NumberValidator;

public abstract class MonetaryValidator
extends NumberValidator {
    public abstract double getMinValue();

    public abstract double getMaxValue();

    @Inject
    public MonetaryValidator() {
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (result.isValid) {
            input = this.cleanInput(input);
            result = this.validateIfNumber(input);
        }
        if (result.isValid) {
            result = result.andValidation(input, this::validateIfNotZero, this::validateIfNotNegative, this::validateIfNotExceedsMinValue, this::validateIfNotExceedsMaxValue);
        }
        return result;
    }

    protected InputValidator.ValidationResult validateIfNotExceedsMinValue(String input) {
        double d = Double.parseDouble(input);
        if (d < this.getMinValue()) {
            return new InputValidator.ValidationResult(false, Res.get("validation.traditional.tooSmall"));
        }
        return new InputValidator.ValidationResult(true);
    }

    protected InputValidator.ValidationResult validateIfNotExceedsMaxValue(String input) {
        double d = Double.parseDouble(input);
        if (d > this.getMaxValue()) {
            return new InputValidator.ValidationResult(false, Res.get("validation.traditional.tooLarge"));
        }
        return new InputValidator.ValidationResult(true);
    }
}

