/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import haveno.core.locale.Res;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;

public class InputValidator {
    public ValidationResult validate(String input) {
        return this.validateIfNotEmpty(input);
    }

    protected ValidationResult validateIfNotEmpty(String input) {
        if (input == null || input.trim().length() == 0) {
            return new ValidationResult(false, Res.get("validation.empty"));
        }
        return new ValidationResult(true);
    }

    protected boolean isPositiveNumber(String input) {
        try {
            return input != null && new BigInteger(input).compareTo(BigInteger.ZERO) >= 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean isNumberWithFixedLength(String input, int length) {
        return this.isPositiveNumber(input) && input.length() == length;
    }

    protected boolean isNumberInRange(String input, int minLength, int maxLength) {
        return this.isPositiveNumber(input) && input.length() >= minLength && input.length() <= maxLength;
    }

    protected boolean isStringWithFixedLength(String input, int length) {
        return input != null && input.length() == length;
    }

    protected boolean isStringInRange(String input, int minLength, int maxLength) {
        return input != null && input.length() >= minLength && input.length() <= maxLength;
    }

    public static class ValidationResult {
        public final boolean isValid;
        public final String errorMessage;

        public ValidationResult(boolean isValid, String errorMessage) {
            this.isValid = isValid;
            this.errorMessage = errorMessage;
        }

        public ValidationResult(boolean isValid) {
            this(isValid, null);
        }

        public ValidationResult and(ValidationResult next) {
            if (this.isValid) {
                return next;
            }
            return this;
        }

        public String toString() {
            return "ValidationResult{isValid=" + this.isValid + ", errorMessage='" + this.errorMessage + "'}";
        }

        public boolean errorMessageEquals(ValidationResult other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return Objects.equals(this.errorMessage, other.errorMessage);
        }

        public ValidationResult andValidation(String input, Validator ... validators) {
            ValidationResult result = null;
            for (Validator validator : validators) {
                result = (ValidationResult)validator.apply(input);
                if (result.isValid) continue;
                return result;
            }
            return result;
        }

        public static interface Validator
        extends Function<String, ValidationResult> {
        }
    }
}

