/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;

public class HexStringValidator
extends InputValidator {
    private int minLength = Integer.MIN_VALUE;
    private int maxLength = Integer.MAX_VALUE;

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult validationResult = super.validate(input);
        if (!validationResult.isValid) {
            return validationResult;
        }
        if (input.length() > this.maxLength || input.length() < this.minLength) {
            new InputValidator.ValidationResult(false, Res.get("validation.length", this.minLength, this.maxLength));
        }
        try {
            Utilities.decodeFromHex((String)input);
            return validationResult;
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.noHexString", input));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HexStringValidator)) {
            return false;
        }
        HexStringValidator other = (HexStringValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        return this.getMaxLength() == other.getMaxLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HexStringValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMinLength();
        result = result * 59 + this.getMaxLength();
        return result;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String toString() {
        return "HexStringValidator(minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ")";
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

