/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;

public final class BtcAddressValidator
extends InputValidator {
    @Inject
    public BtcAddressValidator() {
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (result.isValid) {
            return this.validateBtcAddress(input);
        }
        return result;
    }

    private InputValidator.ValidationResult validateBtcAddress(String input) {
        try {
            Address.fromString((NetworkParameters)Config.baseCurrencyNetworkParameters(), (String)input);
            return new InputValidator.ValidationResult(true);
        }
        catch (AddressFormatException e) {
            return new InputValidator.ValidationResult(false, Res.get("validation.btc.invalidFormat"));
        }
    }
}

