/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.coin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.xmr.wallet.Restrictions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.bitcoinj.core.Coin;

public class CoinUtil {
    public static Coin minCoin(Coin a, Coin b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static Coin maxCoin(Coin a, Coin b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static double getAsPercentPerXmr(BigInteger value) {
        return CoinUtil.getAsPercentPerXmr(value, HavenoUtils.xmrToAtomicUnits(1.0));
    }

    public static double getAsPercentPerXmr(BigInteger part, BigInteger total) {
        return MathUtils.roundDouble((double)HavenoUtils.divide(part == null ? BigInteger.ZERO : part, total == null ? BigInteger.valueOf(1L) : total), (int)4);
    }

    public static BigInteger getPercentOfAmount(double percent, BigInteger amount) {
        if (amount == null) {
            amount = BigInteger.ZERO;
        }
        return BigDecimal.valueOf(percent).multiply(new BigDecimal(amount)).setScale(8, RoundingMode.DOWN).toBigInteger();
    }

    public static BigInteger getRoundedAmount(BigInteger amount, Price price, BigInteger minAmount, BigInteger maxAmount, String currencyCode, String paymentMethodId) {
        if (price != null) {
            if (PaymentMethod.isRoundedForAtmCash(paymentMethodId)) {
                return CoinUtil.getRoundedAtmCashAmount(amount, price, minAmount, maxAmount);
            }
            if (CurrencyUtil.isVolumeRoundedToNearestUnit(currencyCode)) {
                return CoinUtil.getRoundedAmountUnit(amount, price, minAmount, maxAmount);
            }
        }
        return CoinUtil.getRoundedAmount4Decimals(amount);
    }

    public static BigInteger getRoundedAtmCashAmount(BigInteger amount, Price price, BigInteger minAmount, BigInteger maxAmount) {
        return CoinUtil.getAdjustedAmount(amount, price, minAmount, maxAmount, 10);
    }

    public static BigInteger getRoundedAmountUnit(BigInteger amount, Price price, BigInteger minAmount, BigInteger maxAmount) {
        return CoinUtil.getAdjustedAmount(amount, price, minAmount, maxAmount, 1);
    }

    public static BigInteger getRoundedAmount4Decimals(BigInteger amount) {
        DecimalFormat decimalFormat = new DecimalFormat("#.####", HavenoUtils.DECIMAL_FORMAT_SYMBOLS);
        double roundedXmrAmount = Double.parseDouble(decimalFormat.format(HavenoUtils.atomicUnitsToXmr(amount)));
        return HavenoUtils.xmrToAtomicUnits(roundedXmrAmount);
    }

    @VisibleForTesting
    static BigInteger getAdjustedAmount(BigInteger amount, Price price, BigInteger minAmount, BigInteger maxAmount, int factor) {
        long adjustedAmount;
        Volume volume;
        Preconditions.checkArgument((amount.longValueExact() >= Restrictions.getMinTradeAmount().longValueExact() ? 1 : 0) != 0, (Object)("amount must be above minimum of " + HavenoUtils.atomicUnitsToXmr(Restrictions.getMinTradeAmount()) + " xmr but was " + HavenoUtils.atomicUnitsToXmr(amount) + " xmr"));
        if (minAmount == null) {
            minAmount = Restrictions.getMinTradeAmount();
        }
        Preconditions.checkArgument((minAmount.longValueExact() >= Restrictions.getMinTradeAmount().longValueExact() ? 1 : 0) != 0, (Object)("minAmount must be above minimum of " + HavenoUtils.atomicUnitsToXmr(Restrictions.getMinTradeAmount()) + " xmr but was " + HavenoUtils.atomicUnitsToXmr(minAmount) + " xmr"));
        if (maxAmount != null) {
            Preconditions.checkArgument((amount.longValueExact() <= maxAmount.longValueExact() ? 1 : 0) != 0, (Object)("amount must be below maximum of " + HavenoUtils.atomicUnitsToXmr(maxAmount) + " xmr but was " + HavenoUtils.atomicUnitsToXmr(amount) + " xmr"));
            Preconditions.checkArgument((maxAmount.longValueExact() >= minAmount.longValueExact() ? 1 : 0) != 0, (Object)("maxAmount must be above minimum of " + HavenoUtils.atomicUnitsToXmr(Restrictions.getMinTradeAmount()) + " xmr but was " + HavenoUtils.atomicUnitsToXmr(maxAmount) + " xmr"));
        }
        Preconditions.checkArgument((factor > 0 ? 1 : 0) != 0, (Object)"factor must be positive");
        Volume smallestUnitForVolume = Volume.parse(String.valueOf(factor), price.getCurrencyCode());
        if (smallestUnitForVolume.getValue() <= 0L) {
            return BigInteger.ZERO;
        }
        BigInteger smallestUnitForAmount = price.getAmountByVolume(smallestUnitForVolume);
        smallestUnitForAmount = BigInteger.valueOf(Math.max(minAmount.longValueExact(), smallestUnitForAmount.longValueExact()));
        boolean useSmallestUnitForAmount = amount.compareTo(smallestUnitForAmount) < 0;
        Volume volume2 = volume = useSmallestUnitForAmount ? VolumeUtil.getAdjustedVolumeUnit(price.getVolumeByAmount(smallestUnitForAmount), factor) : VolumeUtil.getAdjustedVolumeUnit(price.getVolumeByAmount(amount), factor);
        if (volume.getValue() <= 0L) {
            return BigInteger.ZERO;
        }
        BigInteger amountByVolume = price.getAmountByVolume(volume);
        BigInteger smallestUnitForAmountUnadjusted = price.getAmountByVolume(smallestUnitForVolume);
        if (minAmount != null) {
            for (adjustedAmount = HavenoUtils.centinerosToAtomicUnits(Math.round((double)HavenoUtils.atomicUnitsToCentineros(amountByVolume) / 10000.0) * 10000L).longValueExact(); adjustedAmount < minAmount.longValueExact(); adjustedAmount += smallestUnitForAmountUnadjusted.longValueExact()) {
            }
        }
        if (maxAmount != null) {
            while (adjustedAmount > maxAmount.longValueExact()) {
                adjustedAmount -= smallestUnitForAmountUnadjusted.longValueExact();
            }
        }
        adjustedAmount = Math.max(minAmount.longValueExact(), adjustedAmount);
        if (maxAmount != null) {
            adjustedAmount = Math.min(maxAmount.longValueExact(), adjustedAmount);
        }
        return BigInteger.valueOf(adjustedAmount);
    }
}

