/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import java.util.ArrayList;
import java.util.List;

public class SimpleMarkdownParser {
    public static List<? extends MarkdownNode> parse(String markdown) {
        ArrayList<MarkdownNode> items = new ArrayList<MarkdownNode>();
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        MarkdownParsingState state = MarkdownParsingState.TEXT;
        for (int i = 0; i < markdown.length(); ++i) {
            char c = markdown.charAt(i);
            if (c == '[') {
                if (sb.length() > 0) {
                    items.add(new TextNode(sb.toString()));
                    sb = new StringBuilder();
                }
                state = MarkdownParsingState.LINK_TEXT;
                continue;
            }
            if (c == '(' && state == MarkdownParsingState.LINK_TEXT) {
                state = MarkdownParsingState.LINK_HREF;
                continue;
            }
            if (c == ')' && state == MarkdownParsingState.LINK_HREF) {
                state = MarkdownParsingState.TEXT;
                items.add(new HyperlinkNode(sb.toString(), sb2.toString()));
                sb = new StringBuilder();
                sb2 = new StringBuilder();
                continue;
            }
            if (c == ']') continue;
            if (state == MarkdownParsingState.LINK_HREF) {
                sb2.append(c);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            items.add(new TextNode(sb.toString()));
        }
        return items;
    }

    private static enum MarkdownParsingState {
        TEXT,
        LINK_TEXT,
        LINK_HREF;

    }

    public static class TextNode
    extends MarkdownNode {
        private final String text;

        public TextNode(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class HyperlinkNode
    extends MarkdownNode {
        private final String text;
        private final String href;

        public HyperlinkNode(String text, String href) {
            this.text = text;
            this.href = href;
        }

        public String getText() {
            return this.text;
        }

        public String getHref() {
            return this.href;
        }
    }

    public static class MarkdownNode {
    }
}

