/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import haveno.common.util.MathUtils;
import haveno.core.monetary.Price;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Coin;
import org.bitcoinj.utils.MonetaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingUtils {
    private static final Logger log = LoggerFactory.getLogger(ParsingUtils.class);

    public static Coin parseToCoin(String input, CoinFormatter coinFormatter) {
        return ParsingUtils.parseToCoin(input, coinFormatter.getMonetaryFormat());
    }

    public static Coin parseToCoin(String input, MonetaryFormat coinFormat) {
        if (input != null && input.length() > 0) {
            try {
                return coinFormat.parse(ParsingUtils.cleanDoubleInput(input));
            }
            catch (Throwable t) {
                log.warn("Exception at parseToBtc: " + t.toString());
                return Coin.ZERO;
            }
        }
        return Coin.ZERO;
    }

    public static double parseNumberStringToDouble(String input) throws NumberFormatException {
        return Double.parseDouble(ParsingUtils.cleanDoubleInput(input));
    }

    public static double parsePercentStringToDouble(String percentString) throws NumberFormatException {
        String input = percentString.replace("%", "");
        input = ParsingUtils.cleanDoubleInput(input);
        double value = Double.parseDouble(input);
        return MathUtils.roundDouble((double)(value / 100.0), (int)4);
    }

    public static long parsePriceStringToLong(String currencyCode, String amount, int precision) {
        if (amount == null || amount.isEmpty()) {
            return 0L;
        }
        long value = 0L;
        try {
            double amountValue = Double.parseDouble(amount);
            amount = FormattingUtils.formatRoundedDoubleWithPrecision(amountValue, precision);
            value = Price.parse(currencyCode, amount).getValue();
        }
        catch (NumberFormatException amountValue) {
        }
        catch (Throwable t) {
            log.error("parsePriceStringToLong: " + t.toString());
        }
        return value;
    }

    public static String convertCharsForNumber(String input) {
        input = input.replace("\u2212", "-");
        input = StringUtils.deleteWhitespace((String)input);
        return input.replace(",", ".");
    }

    public static String cleanDoubleInput(String input) {
        if ((input = ParsingUtils.convertCharsForNumber(input)).equals(".")) {
            input = input.replace(".", "0.");
        }
        if (input.equals("-.")) {
            input = input.replace("-.", "-0.");
        }
        Double.parseDouble(input);
        return input;
    }
}

