/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import haveno.common.util.MathUtils;
import haveno.common.util.Tuple2;
import haveno.core.monetary.Price;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.util.InlierUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;

public class AveragePriceUtil {
    private static final double HOW_MANY_STD_DEVS_CONSTITUTE_OUTLIER = 10.0;

    public static Tuple2<Price, Price> getAveragePriceTuple(Preferences preferences, TradeStatisticsManager tradeStatisticsManager, int days) {
        double percentToTrim = Math.max(0.0, Math.min(49.0, preferences.getBsqAverageTrimThreshold() * 100.0));
        Date pastXDays = AveragePriceUtil.getPastDate(days);
        List<TradeStatistics3> bsqAllTradePastXDays = tradeStatisticsManager.getObservableTradeStatisticsSet().stream().filter(e -> e.getCurrency().equals("BSQ")).filter(e -> e.getDate().after(pastXDays)).collect(Collectors.toList());
        List<TradeStatistics3> bsqTradePastXDays = percentToTrim > 0.0 ? AveragePriceUtil.removeOutliers(bsqAllTradePastXDays, percentToTrim) : bsqAllTradePastXDays;
        List<TradeStatistics3> usdAllTradePastXDays = tradeStatisticsManager.getObservableTradeStatisticsSet().stream().filter(e -> e.getCurrency().equals("USD")).filter(e -> e.getDate().after(pastXDays)).collect(Collectors.toList());
        List<TradeStatistics3> usdTradePastXDays = percentToTrim > 0.0 ? AveragePriceUtil.removeOutliers(usdAllTradePastXDays, percentToTrim) : usdAllTradePastXDays;
        Price usdPrice = Price.valueOf("USD", AveragePriceUtil.getUSDAverage(bsqTradePastXDays, usdTradePastXDays));
        Price bsqPrice = Price.valueOf("BSQ", AveragePriceUtil.getBTCAverage(bsqTradePastXDays));
        return new Tuple2((Object)usdPrice, (Object)bsqPrice);
    }

    private static List<TradeStatistics3> removeOutliers(List<TradeStatistics3> list, double percentToTrim) {
        List<Double> yValues = list.stream().filter(TradeStatistics3::isValid).map(e -> e.getNormalizedPrice()).collect(Collectors.toList());
        Tuple2<Double, Double> tuple = InlierUtil.findInlierRange(yValues, percentToTrim, 10.0);
        double lowerBound = (Double)tuple.first;
        double upperBound = (Double)tuple.second;
        return list.stream().filter(e -> (double)e.getNormalizedPrice() > lowerBound).filter(e -> (double)e.getNormalizedPrice() < upperBound).collect(Collectors.toList());
    }

    private static long getBTCAverage(List<TradeStatistics3> list) {
        long accumulatedVolume = 0L;
        long accumulatedAmount = 0L;
        for (TradeStatistics3 item : list) {
            accumulatedVolume += item.getTradeVolume().getValue();
            accumulatedAmount += item.getTradeAmount().longValueExact();
        }
        double accumulatedAmountAsDouble = MathUtils.scaleUpByPowerOf10((double)accumulatedAmount, (int)8);
        long averagePrice = accumulatedVolume > 0L ? MathUtils.roundDoubleToLong((double)(accumulatedAmountAsDouble / (double)accumulatedVolume)) : 0L;
        return averagePrice;
    }

    private static long getUSDAverage(List<TradeStatistics3> bsqList, List<TradeStatistics3> usdList) {
        ArrayList<Tuple2> usdBsqList = new ArrayList<Tuple2>(bsqList.size());
        usdList.sort(Comparator.comparing(TradeStatistics3::getDateAsLong));
        double usdBTCPrice = 10000.0;
        for (TradeStatistics3 item2 : bsqList) {
            usdBTCPrice = usdList.stream().filter(usd -> usd.getDateAsLong() > item2.getDateAsLong()).map(usd -> MathUtils.scaleDownByPowerOf10((double)usd.getTradePrice().getValue(), (int)8)).findFirst().orElse(usdBTCPrice);
            double bsqAmount = MathUtils.scaleDownByPowerOf10((double)item2.getTradeVolume().getValue(), (int)8);
            double btcAmount = MathUtils.scaleDownByPowerOf10((double)item2.getTradeAmount().longValueExact(), (int)8);
            usdBsqList.add(new Tuple2((Object)(usdBTCPrice * btcAmount), (Object)bsqAmount));
        }
        double usdTraded = usdBsqList.stream().mapToDouble(item -> (Double)item.first).sum();
        double bsqTraded = usdBsqList.stream().mapToDouble(item -> (Double)item.second).sum();
        double averageAsDouble = bsqTraded > 0.0 ? usdTraded / bsqTraded : 0.0;
        double averageScaledUp = MathUtils.scaleUpByPowerOf10((double)averageAsDouble, (int)8);
        long averagePrice = bsqTraded > 0.0 ? MathUtils.roundDoubleToLong((double)averageScaledUp) : 0L;
        return averagePrice;
    }

    private static Date getPastDate(int days) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(5, -1 * days);
        return cal.getTime();
    }
}

