/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.user;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.KeyRing;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.alert.Alert;
import haveno.core.filter.Filter;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.notifications.alerts.market.MarketAlertFilter;
import haveno.core.notifications.alerts.price.PriceAlertFilter;
import haveno.core.payment.PaymentAccount;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.core.user.Cookie;
import haveno.core.user.UserPayload;
import haveno.network.p2p.NodeAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class User
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(User.class);
    private final PersistenceManager<UserPayload> persistenceManager;
    private final KeyRing keyRing;
    private ObservableSet<PaymentAccount> paymentAccountsAsObservable;
    private ObjectProperty<PaymentAccount> currentPaymentAccountProperty;
    private UserPayload userPayload = new UserPayload();
    private boolean isPaymentAccountImport = false;

    @Inject
    public User(PersistenceManager<UserPayload> persistenceManager, KeyRing keyRing) {
        this.persistenceManager = persistenceManager;
        this.keyRing = keyRing;
    }

    public User() {
        this.persistenceManager = null;
        this.keyRing = null;
    }

    public void readPersisted(Runnable completeHandler) {
        ((PersistenceManager)Preconditions.checkNotNull(this.persistenceManager)).readPersisted("UserPayload", persisted -> {
            this.userPayload = persisted;
            this.init();
            completeHandler.run();
        }, () -> {
            this.init();
            completeHandler.run();
        });
    }

    private void init() {
        ((PersistenceManager)Preconditions.checkNotNull(this.persistenceManager)).initialize((PersistableEnvelope)this.userPayload, PersistenceManager.Source.PRIVATE);
        Preconditions.checkNotNull(this.userPayload.getPaymentAccounts(), (Object)"userPayload.getPaymentAccounts() must not be null");
        Preconditions.checkNotNull(this.userPayload.getAcceptedLanguageLocaleCodes(), (Object)"userPayload.getAcceptedLanguageLocaleCodes() must not be null");
        this.paymentAccountsAsObservable = FXCollections.observableSet(this.userPayload.getPaymentAccounts());
        this.currentPaymentAccountProperty = new SimpleObjectProperty((Object)this.userPayload.getCurrentPaymentAccount());
        this.userPayload.setAccountId(String.valueOf(Math.abs(((KeyRing)Preconditions.checkNotNull((Object)this.keyRing)).getPubKeyRing().hashCode())));
        if (!this.userPayload.getAcceptedLanguageLocaleCodes().contains(LanguageUtil.getDefaultLanguageLocaleAsCode())) {
            this.userPayload.getAcceptedLanguageLocaleCodes().add(LanguageUtil.getDefaultLanguageLocaleAsCode());
        }
        String english = LanguageUtil.getEnglishLanguageLocaleCode();
        if (!this.userPayload.getAcceptedLanguageLocaleCodes().contains(english)) {
            this.userPayload.getAcceptedLanguageLocaleCodes().add(english);
        }
        this.paymentAccountsAsObservable.addListener(change -> {
            ObservableSet<PaymentAccount> observableSet = this.paymentAccountsAsObservable;
            synchronized (observableSet) {
                this.userPayload.setPaymentAccounts(new HashSet<PaymentAccount>((Collection<PaymentAccount>)this.paymentAccountsAsObservable));
                this.requestPersistence();
            }
        });
        this.currentPaymentAccountProperty.addListener(ov -> {
            this.userPayload.setCurrentPaymentAccount((PaymentAccount)this.currentPaymentAccountProperty.get());
            this.requestPersistence();
        });
        this.requestPersistence();
    }

    public void requestPersistence() {
        if (this.persistenceManager != null) {
            this.persistenceManager.requestPersistence();
        }
    }

    @Nullable
    public Arbitrator getAcceptedArbitratorByAddress(NodeAddress nodeAddress) {
        List<Arbitrator> acceptedArbitrators = this.userPayload.getAcceptedArbitrators();
        if (acceptedArbitrators != null) {
            Optional<Arbitrator> arbitratorOptional = acceptedArbitrators.stream().filter(e -> e.getNodeAddress().equals((Object)nodeAddress)).findFirst();
            return arbitratorOptional.orElse(null);
        }
        return null;
    }

    @Nullable
    public Mediator getAcceptedMediatorByAddress(NodeAddress nodeAddress) {
        List<Mediator> acceptedMediators = this.userPayload.getAcceptedMediators();
        if (acceptedMediators != null) {
            Optional<Mediator> mediatorOptionalOptional = acceptedMediators.stream().filter(e -> e.getNodeAddress().equals((Object)nodeAddress)).findFirst();
            return mediatorOptionalOptional.orElse(null);
        }
        return null;
    }

    @Nullable
    public RefundAgent getAcceptedRefundAgentByAddress(NodeAddress nodeAddress) {
        List<RefundAgent> acceptedRefundAgents = this.userPayload.getAcceptedRefundAgents();
        if (acceptedRefundAgents != null) {
            Optional<RefundAgent> refundAgentOptional = acceptedRefundAgents.stream().filter(e -> e.getNodeAddress().equals((Object)nodeAddress)).findFirst();
            return refundAgentOptional.orElse(null);
        }
        return null;
    }

    @Nullable
    public PaymentAccount findFirstPaymentAccountWithCurrency(TradeCurrency tradeCurrency) {
        if (this.userPayload.getPaymentAccounts() != null) {
            for (PaymentAccount paymentAccount : this.userPayload.getPaymentAccounts()) {
                for (TradeCurrency currency : paymentAccount.getTradeCurrencies()) {
                    if (!currency.equals(tradeCurrency)) continue;
                    return paymentAccount;
                }
            }
            return null;
        }
        return null;
    }

    public boolean hasPaymentAccountForCurrency(TradeCurrency tradeCurrency) {
        return this.findFirstPaymentAccountWithCurrency(tradeCurrency) != null;
    }

    public void addPaymentAccountIfNotExists(PaymentAccount paymentAccount) {
        if (!this.paymentAccountExists(paymentAccount)) {
            this.addPaymentAccount(paymentAccount);
            this.requestPersistence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaymentAccount(PaymentAccount paymentAccount) {
        paymentAccount.onAddToUser();
        ObservableSet<PaymentAccount> observableSet = this.paymentAccountsAsObservable;
        synchronized (observableSet) {
            boolean changed = this.paymentAccountsAsObservable.add((Object)paymentAccount);
            this.setCurrentPaymentAccount(paymentAccount);
            if (changed) {
                this.requestPersistence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportedPaymentAccounts(Collection<PaymentAccount> paymentAccounts) {
        ObservableSet<PaymentAccount> observableSet = this.paymentAccountsAsObservable;
        synchronized (observableSet) {
            this.isPaymentAccountImport = true;
            boolean changed = this.paymentAccountsAsObservable.addAll(paymentAccounts);
            paymentAccounts.stream().findFirst().ifPresent(this::setCurrentPaymentAccount);
            if (changed) {
                this.requestPersistence();
            }
            this.isPaymentAccountImport = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaymentAccount(PaymentAccount paymentAccount) {
        ObservableSet<PaymentAccount> observableSet = this.paymentAccountsAsObservable;
        synchronized (observableSet) {
            boolean changed = this.paymentAccountsAsObservable.remove((Object)paymentAccount);
            if (changed) {
                this.requestPersistence();
            }
        }
    }

    public boolean addAcceptedArbitrator(Arbitrator arbitrator) {
        List<Arbitrator> arbitrators = this.userPayload.getAcceptedArbitrators();
        if (arbitrators != null && !arbitrators.contains(arbitrator) && !this.isMyOwnRegisteredArbitrator(arbitrator)) {
            arbitrators.add(arbitrator);
            this.requestPersistence();
            return true;
        }
        return false;
    }

    public void removeAcceptedArbitrator(Arbitrator arbitrator) {
        boolean changed;
        if (this.userPayload.getAcceptedArbitrators() != null && (changed = this.userPayload.getAcceptedArbitrators().remove(arbitrator))) {
            this.requestPersistence();
        }
    }

    public void clearAcceptedArbitrators() {
        if (this.userPayload.getAcceptedArbitrators() != null) {
            this.userPayload.getAcceptedArbitrators().clear();
            this.requestPersistence();
        }
    }

    public boolean addAcceptedMediator(Mediator mediator) {
        List<Mediator> mediators = this.userPayload.getAcceptedMediators();
        if (mediators != null && !mediators.contains(mediator) && !this.isMyOwnRegisteredMediator(mediator)) {
            mediators.add(mediator);
            this.requestPersistence();
            return true;
        }
        return false;
    }

    public void removeAcceptedMediator(Mediator mediator) {
        boolean changed;
        if (this.userPayload.getAcceptedMediators() != null && (changed = this.userPayload.getAcceptedMediators().remove(mediator))) {
            this.requestPersistence();
        }
    }

    public void clearAcceptedMediators() {
        if (this.userPayload.getAcceptedMediators() != null) {
            this.userPayload.getAcceptedMediators().clear();
            this.requestPersistence();
        }
    }

    public boolean addAcceptedRefundAgent(RefundAgent refundAgent) {
        List<RefundAgent> refundAgents = this.userPayload.getAcceptedRefundAgents();
        if (refundAgents != null && !refundAgents.contains(refundAgent) && !this.isMyOwnRegisteredRefundAgent(refundAgent)) {
            refundAgents.add(refundAgent);
            this.requestPersistence();
            return true;
        }
        return false;
    }

    public void removeAcceptedRefundAgent(RefundAgent refundAgent) {
        boolean changed;
        if (this.userPayload.getAcceptedRefundAgents() != null && (changed = this.userPayload.getAcceptedRefundAgents().remove(refundAgent))) {
            this.requestPersistence();
        }
    }

    public void clearAcceptedRefundAgents() {
        if (this.userPayload.getAcceptedRefundAgents() != null) {
            this.userPayload.getAcceptedRefundAgents().clear();
            this.requestPersistence();
        }
    }

    public void setCurrentPaymentAccount(PaymentAccount paymentAccount) {
        this.currentPaymentAccountProperty.set((Object)paymentAccount);
        this.requestPersistence();
    }

    public void setRegisteredArbitrator(@Nullable Arbitrator arbitrator) {
        this.userPayload.setRegisteredArbitrator(arbitrator);
        this.requestPersistence();
    }

    public void setRegisteredMediator(@Nullable Mediator mediator) {
        this.userPayload.setRegisteredMediator(mediator);
        this.requestPersistence();
    }

    public void setRegisteredRefundAgent(@Nullable RefundAgent refundAgent) {
        this.userPayload.setRegisteredRefundAgent(refundAgent);
        this.requestPersistence();
    }

    public void setDevelopersFilter(@Nullable Filter developersFilter) {
        this.userPayload.setDevelopersFilter(developersFilter);
        this.requestPersistence();
    }

    public void setDevelopersAlert(@Nullable Alert developersAlert) {
        this.userPayload.setDevelopersAlert(developersAlert);
        this.requestPersistence();
    }

    public void setDisplayedAlert(@Nullable Alert displayedAlert) {
        this.userPayload.setDisplayedAlert(displayedAlert);
        this.requestPersistence();
    }

    public void addMarketAlertFilter(MarketAlertFilter filter) {
        this.getMarketAlertFilters().add(filter);
        this.requestPersistence();
    }

    public void removeMarketAlertFilter(MarketAlertFilter filter) {
        this.getMarketAlertFilters().remove(filter);
        this.requestPersistence();
    }

    public void setPriceAlertFilter(PriceAlertFilter filter) {
        this.userPayload.setPriceAlertFilter(filter);
        this.requestPersistence();
    }

    public void removePriceAlertFilter() {
        this.userPayload.setPriceAlertFilter(null);
        this.requestPersistence();
    }

    public void setWalletCreationDate(long walletCreationDate) {
        this.userPayload.setWalletCreationDate(walletCreationDate);
        this.requestPersistence();
    }

    @Nullable
    public PaymentAccount getPaymentAccount(String paymentAccountId) {
        Optional<Object> optional = this.userPayload.getPaymentAccounts() != null ? this.userPayload.getPaymentAccounts().stream().filter(e -> e.getId().equals(paymentAccountId)).findAny() : Optional.empty();
        return optional.orElse(null);
    }

    public String getAccountId() {
        return this.userPayload.getAccountId();
    }

    public ReadOnlyObjectProperty<PaymentAccount> currentPaymentAccountProperty() {
        return this.currentPaymentAccountProperty;
    }

    @Nullable
    public Set<PaymentAccount> getPaymentAccounts() {
        return this.userPayload.getPaymentAccounts();
    }

    @Nullable
    public ObservableSet<PaymentAccount> getPaymentAccountsAsObservable() {
        return this.paymentAccountsAsObservable;
    }

    @Nullable
    public Arbitrator getRegisteredArbitrator() {
        return this.userPayload.getRegisteredArbitrator();
    }

    @Nullable
    public Mediator getRegisteredMediator() {
        return this.userPayload.getRegisteredMediator();
    }

    @Nullable
    public RefundAgent getRegisteredRefundAgent() {
        return this.userPayload.getRegisteredRefundAgent();
    }

    @Nullable
    public List<Arbitrator> getAcceptedArbitrators() {
        return this.userPayload.getAcceptedArbitrators();
    }

    @Nullable
    public List<Mediator> getAcceptedMediators() {
        return this.userPayload.getAcceptedMediators();
    }

    @Nullable
    public List<RefundAgent> getAcceptedRefundAgents() {
        return this.userPayload.getAcceptedRefundAgents();
    }

    @Nullable
    public List<NodeAddress> getAcceptedArbitratorAddresses() {
        return this.userPayload.getAcceptedArbitrators() != null ? this.userPayload.getAcceptedArbitrators().stream().map(DisputeAgent::getNodeAddress).collect(Collectors.toList()) : null;
    }

    @Nullable
    public List<NodeAddress> getAcceptedMediatorAddresses() {
        return this.userPayload.getAcceptedMediators() != null ? this.userPayload.getAcceptedMediators().stream().map(DisputeAgent::getNodeAddress).collect(Collectors.toList()) : null;
    }

    @Nullable
    public List<NodeAddress> getAcceptedRefundAgentAddresses() {
        return this.userPayload.getAcceptedRefundAgents() != null ? this.userPayload.getAcceptedRefundAgents().stream().map(DisputeAgent::getNodeAddress).collect(Collectors.toList()) : null;
    }

    public boolean hasAcceptedArbitrators() {
        return this.getAcceptedArbitrators() != null && !this.getAcceptedArbitrators().isEmpty();
    }

    public boolean hasAcceptedMediators() {
        return this.getAcceptedMediators() != null && !this.getAcceptedMediators().isEmpty();
    }

    public boolean hasAcceptedRefundAgents() {
        return this.getAcceptedRefundAgents() != null && !this.getAcceptedRefundAgents().isEmpty();
    }

    @Nullable
    public Filter getDevelopersFilter() {
        return this.userPayload.getDevelopersFilter();
    }

    @Nullable
    public Alert getDevelopersAlert() {
        return this.userPayload.getDevelopersAlert();
    }

    @Nullable
    public Alert getDisplayedAlert() {
        return this.userPayload.getDisplayedAlert();
    }

    public boolean isMyOwnRegisteredArbitrator(Arbitrator arbitrator) {
        return arbitrator.equals(this.userPayload.getRegisteredArbitrator());
    }

    public boolean isMyOwnRegisteredMediator(Mediator mediator) {
        return mediator.equals(this.userPayload.getRegisteredMediator());
    }

    public boolean isMyOwnRegisteredRefundAgent(RefundAgent refundAgent) {
        return refundAgent.equals(this.userPayload.getRegisteredRefundAgent());
    }

    public List<MarketAlertFilter> getMarketAlertFilters() {
        return this.userPayload.getMarketAlertFilters();
    }

    @Nullable
    public PriceAlertFilter getPriceAlertFilter() {
        return this.userPayload.getPriceAlertFilter();
    }

    public boolean isPaymentAccountImport() {
        return this.isPaymentAccountImport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean paymentAccountExists(PaymentAccount paymentAccount) {
        ObservableSet<PaymentAccount> observableSet = this.paymentAccountsAsObservable;
        synchronized (observableSet) {
            return this.getPaymentAccountsAsObservable().stream().anyMatch(e -> e.equals(paymentAccount));
        }
    }

    public Cookie getCookie() {
        return this.userPayload.getCookie();
    }

    public long getWalletCreationDate() {
        return this.userPayload.getWalletCreationDate();
    }

    public User(PersistenceManager<UserPayload> persistenceManager, KeyRing keyRing, ObservableSet<PaymentAccount> paymentAccountsAsObservable, ObjectProperty<PaymentAccount> currentPaymentAccountProperty, UserPayload userPayload, boolean isPaymentAccountImport) {
        this.persistenceManager = persistenceManager;
        this.keyRing = keyRing;
        this.paymentAccountsAsObservable = paymentAccountsAsObservable;
        this.currentPaymentAccountProperty = currentPaymentAccountProperty;
        this.userPayload = userPayload;
        this.isPaymentAccountImport = isPaymentAccountImport;
    }
}

