/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.file.JsonFileManager;
import haveno.core.locale.CurrencyTuple;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatistics3StorageService;
import haveno.core.trade.statistics.TradeStatisticsForJson;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import haveno.network.p2p.storage.persistence.MapStoreService;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeStatisticsManager {
    private static final Logger log = LoggerFactory.getLogger(TradeStatisticsManager.class);
    private final P2PService p2PService;
    private final PriceFeedService priceFeedService;
    private final TradeStatistics3StorageService tradeStatistics3StorageService;
    private final File storageDir;
    private final boolean dumpStatistics;
    private final ObservableSet<TradeStatistics3> observableTradeStatisticsSet = FXCollections.observableSet((Object[])new TradeStatistics3[0]);
    private JsonFileManager jsonFileManager;
    public static final int PUBLISH_STATS_RANDOM_DELAY_HOURS = 24;
    private static final double FUZZ_AMOUNT_PCT = 0.05;
    private static final int FUZZ_DATE_HOURS = 24;

    @Inject
    public TradeStatisticsManager(P2PService p2PService, PriceFeedService priceFeedService, TradeStatistics3StorageService tradeStatistics3StorageService, AppendOnlyDataStoreService appendOnlyDataStoreService, @Named(value="storageDir") File storageDir, @Named(value="dumpStatistics") boolean dumpStatistics) {
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.tradeStatistics3StorageService = tradeStatistics3StorageService;
        this.storageDir = storageDir;
        this.dumpStatistics = dumpStatistics;
        appendOnlyDataStoreService.addService((MapStoreService)tradeStatistics3StorageService);
        HavenoUtils.tradeStatisticsManager = this;
    }

    public void shutDown() {
        if (this.jsonFileManager != null) {
            this.jsonFileManager.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAllServicesInitialized() {
        this.p2PService.getP2PDataStorage().addAppendOnlyDataStoreListener(payload -> {
            if (payload instanceof TradeStatistics3) {
                TradeStatistics3 tradeStatistics = (TradeStatistics3)payload;
                if (!tradeStatistics.isValid()) {
                    return;
                }
                ObservableSet<TradeStatistics3> observableSet = this.observableTradeStatisticsSet;
                synchronized (observableSet) {
                    this.observableTradeStatisticsSet.add((Object)tradeStatistics);
                    this.priceFeedService.applyLatestHavenoMarketPrice((Set<TradeStatistics3>)this.observableTradeStatisticsSet);
                }
                this.maybeDumpStatistics();
            }
        });
        Set<TradeStatistics3> set = this.tradeStatistics3StorageService.getMapOfAllData().values().stream().filter(e -> e instanceof TradeStatistics3).map(e -> (TradeStatistics3)e).filter(TradeStatistics3::isValid).collect(Collectors.toSet());
        this.removeDuplicateStats(set);
        ObservableSet<TradeStatistics3> observableSet = this.observableTradeStatisticsSet;
        synchronized (observableSet) {
            this.observableTradeStatisticsSet.addAll(set);
            this.priceFeedService.applyLatestHavenoMarketPrice((Set<TradeStatistics3>)this.observableTradeStatisticsSet);
        }
        this.maybeDumpStatistics();
    }

    private void removeDuplicateStats(Set<TradeStatistics3> tradeStats) {
        this.removeEarlyDuplicateStats(tradeStats);
        this.removeEarlyDuplicateStatsFuzzy(tradeStats);
    }

    private void removeEarlyDuplicateStats(Set<TradeStatistics3> tradeStats) {
        Set earlyTrades = tradeStats.stream().filter(e -> e.getDate().toInstant().isBefore(Instant.parse("2024-09-30T00:00:00Z"))).collect(Collectors.toSet());
        HashSet<TradeStatistics3> duplicates = new HashSet<TradeStatistics3>();
        HashSet<TradeStatistics3> deduplicates = new HashSet<TradeStatistics3>();
        for (TradeStatistics3 tradeStatistic : earlyTrades) {
            TradeStatistics3 duplicate = this.findDuplicate(tradeStatistic, deduplicates);
            if (duplicate == null) {
                deduplicates.add(tradeStatistic);
                continue;
            }
            duplicates.add(tradeStatistic);
        }
        tradeStats.removeAll(duplicates);
    }

    private TradeStatistics3 findDuplicate(TradeStatistics3 tradeStatistics, Set<TradeStatistics3> set) {
        return set.stream().filter(e -> this.isDuplicate(tradeStatistics, (TradeStatistics3)e)).findFirst().orElse(null);
    }

    private boolean isDuplicate(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        if (!tradeStatistics1.getPaymentMethodId().equals(tradeStatistics2.getPaymentMethodId())) {
            return false;
        }
        if (!tradeStatistics1.getCurrency().equals(tradeStatistics2.getCurrency())) {
            return false;
        }
        return tradeStatistics1.getDateAsLong() == tradeStatistics2.getDateAsLong();
    }

    private void removeEarlyDuplicateStatsFuzzy(Set<TradeStatistics3> tradeStats) {
        Set earlyTrades = tradeStats.stream().filter(e -> e.getDate().toInstant().isBefore(Instant.parse("2024-08-07T00:00:00Z"))).collect(Collectors.toSet());
        HashSet<TradeStatistics3> duplicates = new HashSet<TradeStatistics3>();
        HashSet<TradeStatistics3> deduplicates = new HashSet<TradeStatistics3>();
        for (TradeStatistics3 tradeStatistic : earlyTrades) {
            TradeStatistics3 fuzzyDuplicate = this.findFuzzyDuplicate(tradeStatistic, deduplicates);
            if (fuzzyDuplicate == null) {
                deduplicates.add(tradeStatistic);
                continue;
            }
            duplicates.add(tradeStatistic);
        }
        tradeStats.removeAll(duplicates);
    }

    private TradeStatistics3 findFuzzyDuplicate(TradeStatistics3 tradeStatistics, Set<TradeStatistics3> set) {
        return set.stream().filter(e -> this.isFuzzyDuplicate(tradeStatistics, (TradeStatistics3)e)).findFirst().orElse(null);
    }

    private boolean isFuzzyDuplicate(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        if (!tradeStatistics1.getPaymentMethodId().equals(tradeStatistics2.getPaymentMethodId())) {
            return false;
        }
        if (!tradeStatistics1.getCurrency().equals(tradeStatistics2.getCurrency())) {
            return false;
        }
        if (tradeStatistics1.getNormalizedPrice() != tradeStatistics2.getNormalizedPrice()) {
            return false;
        }
        return this.isFuzzyDuplicateV1(tradeStatistics1, tradeStatistics2) || this.isFuzzyDuplicateV2(tradeStatistics1, tradeStatistics2);
    }

    private boolean isFuzzyDuplicateV1(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        boolean isWithin2Minutes = Math.abs(tradeStatistics1.getDate().getTime() - tradeStatistics2.getDate().getTime()) <= TimeUnit.MINUTES.toMillis(2L);
        return isWithin2Minutes;
    }

    private boolean isFuzzyDuplicateV2(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        boolean isWithinFuzzedHours = Math.abs(tradeStatistics1.getDate().getTime() - tradeStatistics2.getDate().getTime()) <= TimeUnit.HOURS.toMillis(24L);
        boolean isWithinFuzzedAmount = (double)Math.abs(tradeStatistics1.getAmount() - tradeStatistics2.getAmount()) <= 0.05 * (double)tradeStatistics1.getAmount();
        return isWithinFuzzedHours && isWithinFuzzedAmount;
    }

    public ObservableSet<TradeStatistics3> getObservableTradeStatisticsSet() {
        return this.observableTradeStatisticsSet;
    }

    private void maybeDumpStatistics() {
        if (!this.dumpStatistics) {
            return;
        }
        if (this.jsonFileManager == null) {
            this.jsonFileManager = new JsonFileManager(this.storageDir);
            ArrayList traditionalCurrencyList = CurrencyUtil.getAllSortedTraditionalCurrencies().stream().map(e -> new CurrencyTuple(e.getCode(), e.getName(), 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(traditionalCurrencyList), "traditional_currency_list");
            ArrayList cryptoCurrencyList = CurrencyUtil.getAllSortedCryptoCurrencies().stream().map(e -> new CurrencyTuple(e.getCode(), e.getName(), 8)).collect(Collectors.toCollection(ArrayList::new));
            cryptoCurrencyList.add(0, new CurrencyTuple(Res.getBaseCurrencyCode(), Res.getBaseCurrencyName(), 8));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(cryptoCurrencyList), "crypto_currency_list");
            Instant yearAgo = Instant.ofEpochSecond(Instant.now().getEpochSecond() - TimeUnit.DAYS.toSeconds(365L));
            Set activeCurrencies = this.observableTradeStatisticsSet.stream().filter(e -> e.getDate().toInstant().isAfter(yearAgo)).map(p -> p.getCurrency()).collect(Collectors.toSet());
            ArrayList activeTraditionalCurrencyList = traditionalCurrencyList.stream().filter(e -> activeCurrencies.contains(e.code)).map(e -> new CurrencyTuple(e.code, e.name, 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(activeTraditionalCurrencyList), "active_traditional_currency_list");
            ArrayList activeCryptoCurrencyList = cryptoCurrencyList.stream().filter(e -> activeCurrencies.contains(e.code)).map(e -> new CurrencyTuple(e.code, e.name, 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(activeCryptoCurrencyList), "active_crypto_currency_list");
        }
        List<TradeStatisticsForJson> list = this.observableTradeStatisticsSet.stream().map(TradeStatisticsForJson::new).sorted((o1, o2) -> Long.compare(o2.tradeDate, o1.tradeDate)).collect(Collectors.toList());
        TradeStatisticsForJson[] array = new TradeStatisticsForJson[list.size()];
        list.toArray(array);
        this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(array), "trade_statistics");
    }

    public void maybePublishTradeStatistics(Trade trade, @Nullable String referralId, boolean isTorNetworkNode) {
        HashSet<Trade> trades = new HashSet<Trade>();
        trades.add(trade);
        this.maybePublishTradeStatistics(trades, referralId, isTorNetworkNode);
    }

    public void maybePublishTradeStatistics(Set<Trade> trades, @Nullable String referralId, boolean isTorNetworkNode) {
        long ts = System.currentTimeMillis();
        Set hashes = this.tradeStatistics3StorageService.getMapOfAllData().keySet();
        trades.forEach(trade -> {
            if (!trade.shouldPublishTradeStatistics()) {
                log.debug("Trade: {} should not publish trade statistics", (Object)trade.getShortId());
                return;
            }
            TradeStatistics3 tradeStatistics3V0 = null;
            try {
                tradeStatistics3V0 = TradeStatistics3.fromV0(trade, referralId, isTorNetworkNode);
            }
            catch (Exception e) {
                log.warn("Error getting trade statistic for {} {}: {}", new Object[]{trade.getClass().getName(), trade.getId(), e.getMessage()});
                return;
            }
            TradeStatistics3 tradeStatistics3V1 = null;
            try {
                tradeStatistics3V1 = TradeStatistics3.fromV1(trade, referralId, isTorNetworkNode);
            }
            catch (Exception e) {
                log.warn("Error getting trade statistic for {} {}: {}", new Object[]{trade.getClass().getName(), trade.getId(), e.getMessage()});
                return;
            }
            TradeStatistics3 tradeStatistics3V2 = null;
            try {
                tradeStatistics3V2 = TradeStatistics3.fromV2(trade, referralId, isTorNetworkNode);
            }
            catch (Exception e) {
                log.warn("Error getting trade statistic for {} {}: {}", new Object[]{trade.getClass().getName(), trade.getId(), e.getMessage()});
                return;
            }
            boolean hasTradeStatistics3V0 = hashes.contains(new P2PDataStorage.ByteArray(tradeStatistics3V0.getHash()));
            boolean hasTradeStatistics3V1 = hashes.contains(new P2PDataStorage.ByteArray(tradeStatistics3V1.getHash()));
            boolean hasTradeStatistics3V2 = hashes.contains(new P2PDataStorage.ByteArray(tradeStatistics3V2.getHash()));
            if (hasTradeStatistics3V0 || hasTradeStatistics3V1 || hasTradeStatistics3V2) {
                log.debug("Trade: {}. We have already a tradeStatistics matching the hash of tradeStatistics3.", (Object)trade.getShortId());
                return;
            }
            if (!tradeStatistics3V2.isValid()) {
                log.warn("Trade statistics are invalid for {} {}. We do not publish: {}", new Object[]{trade.getClass().getSimpleName(), trade.getShortId(), tradeStatistics3V1});
                return;
            }
            log.info("Scheduling to publish trade statistics at random time for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getShortId());
            TradeStatistics3 tradeStatistics3V2Final = tradeStatistics3V2;
            UserThread.runAfterRandomDelay(() -> this.p2PService.addPersistableNetworkPayload((PersistableNetworkPayload)tradeStatistics3V2Final, true), (long)0L, (long)43200000L, (TimeUnit)TimeUnit.MILLISECONDS);
        });
        log.info("maybeRepublishTradeStatistics took {} ms. Number of tradeStatistics: {}. Number of own trades: {}", new Object[]{System.currentTimeMillis() - ts, hashes.size(), trades.size()});
    }
}

