/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.trade.statistics.TradeStatistics3;
import java.math.BigInteger;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TradeStatisticsForJson {
    private static final Logger log = LoggerFactory.getLogger(TradeStatisticsForJson.class);
    public final String currency;
    public final long tradePrice;
    public final long tradeAmount;
    public final long tradeDate;
    public final String paymentMethod;
    public String currencyPair;
    public long primaryMarketTradePrice;
    public long primaryMarketTradeAmount;
    public long primaryMarketTradeVolume;

    public TradeStatisticsForJson(TradeStatistics3 tradeStatistics) {
        this.currency = tradeStatistics.getCurrency();
        this.paymentMethod = tradeStatistics.getPaymentMethodId();
        this.tradePrice = tradeStatistics.getNormalizedPrice();
        this.tradeAmount = tradeStatistics.getAmount();
        this.tradeDate = tradeStatistics.getDateAsLong();
        try {
            Price tradePrice = this.getPrice();
            this.currencyPair = Res.getBaseCurrencyCode() + "/" + this.currency;
            this.primaryMarketTradePrice = tradePrice.getValue();
            this.primaryMarketTradeAmount = this.getTradeAmount().longValueExact();
            this.primaryMarketTradeVolume = this.getTradeVolume() != null ? this.getTradeVolume().getValue() : 0L;
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            t.printStackTrace();
        }
    }

    public Price getPrice() {
        return Price.valueOf(this.currency, this.tradePrice);
    }

    public BigInteger getTradeAmount() {
        return BigInteger.valueOf(this.tradeAmount);
    }

    public Volume getTradeVolume() {
        try {
            return this.getPrice().getVolumeByAmount(this.getTradeAmount());
        }
        catch (Throwable t) {
            return Volume.parse("0", this.currency);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeStatisticsForJson)) {
            return false;
        }
        TradeStatisticsForJson other = (TradeStatisticsForJson)o;
        if (this.tradePrice != other.tradePrice) {
            return false;
        }
        BigInteger this$tradeAmount = this.getTradeAmount();
        BigInteger other$tradeAmount = other.getTradeAmount();
        if (this$tradeAmount == null ? other$tradeAmount != null : !((Object)this$tradeAmount).equals(other$tradeAmount)) {
            return false;
        }
        if (this.tradeDate != other.tradeDate) {
            return false;
        }
        if (this.primaryMarketTradePrice != other.primaryMarketTradePrice) {
            return false;
        }
        if (this.primaryMarketTradeAmount != other.primaryMarketTradeAmount) {
            return false;
        }
        if (this.primaryMarketTradeVolume != other.primaryMarketTradeVolume) {
            return false;
        }
        String this$currency = this.currency;
        String other$currency = other.currency;
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$paymentMethod = this.paymentMethod;
        String other$paymentMethod = other.paymentMethod;
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        String this$currencyPair = this.currencyPair;
        String other$currencyPair = other.currencyPair;
        return !(this$currencyPair == null ? other$currencyPair != null : !this$currencyPair.equals(other$currencyPair));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tradePrice = this.tradePrice;
        result = result * 59 + (int)($tradePrice >>> 32 ^ $tradePrice);
        BigInteger $tradeAmount = this.getTradeAmount();
        result = result * 59 + ($tradeAmount == null ? 43 : ((Object)$tradeAmount).hashCode());
        long $tradeDate = this.tradeDate;
        result = result * 59 + (int)($tradeDate >>> 32 ^ $tradeDate);
        long $primaryMarketTradePrice = this.primaryMarketTradePrice;
        result = result * 59 + (int)($primaryMarketTradePrice >>> 32 ^ $primaryMarketTradePrice);
        long $primaryMarketTradeAmount = this.primaryMarketTradeAmount;
        result = result * 59 + (int)($primaryMarketTradeAmount >>> 32 ^ $primaryMarketTradeAmount);
        long $primaryMarketTradeVolume = this.primaryMarketTradeVolume;
        result = result * 59 + (int)($primaryMarketTradeVolume >>> 32 ^ $primaryMarketTradeVolume);
        String $currency = this.currency;
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $paymentMethod = this.paymentMethod;
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        String $currencyPair = this.currencyPair;
        result = result * 59 + ($currencyPair == null ? 43 : $currencyPair.hashCode());
        return result;
    }

    public String toString() {
        return "TradeStatisticsForJson(currency=" + this.currency + ", tradePrice=" + this.tradePrice + ", tradeAmount=" + String.valueOf(this.getTradeAmount()) + ", tradeDate=" + this.tradeDate + ", paymentMethod=" + this.paymentMethod + ", currencyPair=" + this.currencyPair + ", primaryMarketTradePrice=" + this.primaryMarketTradePrice + ", primaryMarketTradeAmount=" + this.primaryMarketTradeAmount + ", primaryMarketTradeVolume=" + this.primaryMarketTradeVolume + ")";
    }
}

