/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPeersAccountAgeWitness
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(VerifyPeersAccountAgeWitness.class);

    public VerifyPeersAccountAgeWitness(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            Offer offer = (Offer)Preconditions.checkNotNull((Object)this.trade.getOffer());
            if (CurrencyUtil.isCryptoCurrency(offer.getCounterCurrencyCode())) {
                this.complete();
                return;
            }
            if (this.trade instanceof ArbitratorTrade) {
                this.complete();
                return;
            }
            TradePeer tradePeer = this.trade.getTradePeer();
            if (tradePeer.getPaymentAccountPayload() == null) {
                this.complete();
                return;
            }
            AccountAgeWitnessService accountAgeWitnessService = this.processModel.getAccountAgeWitnessService();
            PaymentAccountPayload peersPaymentAccountPayload = (PaymentAccountPayload)Preconditions.checkNotNull((Object)tradePeer.getPaymentAccountPayload(), (Object)"Peers peersPaymentAccountPayload must not be null");
            PubKeyRing peersPubKeyRing = (PubKeyRing)Preconditions.checkNotNull((Object)tradePeer.getPubKeyRing(), (Object)"peersPubKeyRing must not be null");
            byte[] nonce = (byte[])Preconditions.checkNotNull((Object)tradePeer.getAccountAgeWitnessNonce());
            byte[] signature = (byte[])Preconditions.checkNotNull((Object)tradePeer.getAccountAgeWitnessSignature());
            AtomicReference errorMsg = new AtomicReference();
            boolean isValid = accountAgeWitnessService.verifyAccountAgeWitness(this.trade, peersPaymentAccountPayload, peersPubKeyRing, nonce, signature, errorMsg::set);
            if (isValid) {
                this.trade.getTradePeer().setAccountAgeWitness(this.processModel.getAccountAgeWitnessService().findWitness(this.trade.getTradePeer().getPaymentAccountPayload(), this.trade.getTradePeer().getPubKeyRing()).orElse(null));
                log.info("{} {} verified witness data of peer {}", new Object[]{this.trade.getClass().getSimpleName(), this.trade.getId(), tradePeer.getNodeAddress()});
                this.complete();
            } else {
                this.failed((String)errorMsg.get());
            }
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }
}

