/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.Model;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.ProcessModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradeTask
extends Task<Trade> {
    private static final Logger log = LoggerFactory.getLogger(TradeTask.class);
    protected final ProcessModel processModel;
    protected final Trade trade;

    protected TradeTask(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, (Model)trade);
        this.trade = trade;
        this.processModel = trade.getProcessModel();
    }

    protected void complete() {
        this.processModel.getTradeManager().requestPersistence();
        super.complete();
    }

    protected void failed() {
        this.trade.setErrorMessage(this.errorMessage);
        this.processModel.getTradeManager().requestPersistence();
        super.failed();
    }

    protected void failed(String message) {
        this.appendToErrorMessage(message);
        this.trade.setErrorMessage(this.errorMessage);
        this.processModel.getTradeManager().requestPersistence();
        super.failed();
    }

    protected void failed(Throwable t) {
        log.error("Trade task failed, error={}\n", (Object)t.getMessage(), (Object)t);
        this.appendExceptionToErrorMessage(t);
        this.trade.setErrorMessage(this.errorMessage);
        this.processModel.getTradeManager().requestPersistence();
        super.failed();
    }
}

