/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.app.Version;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.TradeProtocolVersion;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.user.User;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakerSendInitTradeRequestToMaker
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(TakerSendInitTradeRequestToMaker.class);

    public TakerSendInitTradeRequestToMaker(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            if (!this.trade.isBuyerAsTakerWithoutDeposit() && this.trade.getSelf().getReserveTxHash() == null) {
                throw new IllegalStateException("Taker reserve tx id is not initialized: " + this.trade.getSelf().getReserveTxHash());
            }
            Offer offer = ((Trade)this.model).getOffer();
            User user = this.processModel.getUser();
            P2PService p2PService = this.processModel.getP2PService();
            XmrWalletService walletService = ((Trade)this.model).getXmrWalletService();
            String payoutAddress = walletService.getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString();
            String challenge = ((Trade)this.model).getChallenge();
            byte[] sig = HavenoUtils.sign(p2PService.getKeyRing(), offer.getId());
            InitTradeRequest makerRequest = new InitTradeRequest(TradeProtocolVersion.MULTISIG_2_3, offer.getId(), this.trade.getAmount().longValueExact(), this.trade.getPrice().getValue(), this.trade.getSelf().getPaymentMethodId(), null, user.getAccountId(), this.trade.getMaker().getPaymentAccountId(), this.trade.getTaker().getPaymentAccountId(), p2PService.getKeyRing().getPubKeyRing(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), sig, new Date().getTime(), offer.getMakerNodeAddress(), P2PService.getMyNodeAddress(), null, null, null, null, payoutAddress, challenge);
            log.info("Sending {} with offerId {} and uid {} to maker {}", new Object[]{((Object)((Object)makerRequest)).getClass().getSimpleName(), makerRequest.getOfferId(), makerRequest.getUid(), this.trade.getMaker().getNodeAddress()});
            this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getMaker().getNodeAddress(), this.trade.getMaker().getPubKeyRing(), (NetworkEnvelope)makerRequest, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at maker: offerId={}", (Object)InitTradeRequest.class.getSimpleName(), (Object)TakerSendInitTradeRequestToMaker.this.trade.getId());
                    TakerSendInitTradeRequestToMaker.this.complete();
                }

                public void onFault(String errorMessage) {
                    log.warn("Failed to send {} to maker, error={}.", (Object)InitTradeRequest.class.getSimpleName(), (Object)errorMessage);
                    TakerSendInitTradeRequestToMaker.this.failed();
                }
            });
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }
}

