/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.app.Version;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.TradeProtocolVersion;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakerSendInitTradeRequestToArbitrator
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(TakerSendInitTradeRequestToArbitrator.class);

    public TakerSendInitTradeRequestToArbitrator(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            InitTradeRequest sourceRequest = (InitTradeRequest)this.processModel.getTradeMessage();
            Preconditions.checkNotNull((Object)((Object)sourceRequest));
            Validator.checkTradeId(this.processModel.getOfferId(), sourceRequest);
            if (!this.trade.isBuyerAsTakerWithoutDeposit() && this.trade.getSelf().getReserveTxHash() == null) {
                throw new IllegalStateException("Taker reserve tx id is not initialized: " + this.trade.getSelf().getReserveTxHash());
            }
            Offer offer = this.processModel.getOffer();
            InitTradeRequest arbitratorRequest = new InitTradeRequest(TradeProtocolVersion.MULTISIG_2_3, offer.getId(), this.trade.getAmount().longValueExact(), this.trade.getPrice().getValue(), this.trade.getSelf().getPaymentMethodId(), this.trade.getMaker().getAccountId(), this.trade.getTaker().getAccountId(), this.trade.getMaker().getPaymentAccountId(), this.trade.getTaker().getPaymentAccountId(), this.trade.getTaker().getPubKeyRing(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), null, sourceRequest.getCurrentDate(), this.trade.getMaker().getNodeAddress(), this.trade.getTaker().getNodeAddress(), this.trade.getArbitrator().getNodeAddress(), this.trade.getSelf().getReserveTxHash(), this.trade.getSelf().getReserveTxHex(), this.trade.getSelf().getReserveTxKey(), ((Trade)this.model).getXmrWalletService().getAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString(), this.trade.getChallenge());
            log.info("Sending {} with offerId {} and uid {} to arbitrator {}", new Object[]{((Object)((Object)arbitratorRequest)).getClass().getSimpleName(), arbitratorRequest.getOfferId(), arbitratorRequest.getUid(), this.trade.getArbitrator().getNodeAddress()});
            this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getArbitrator().getNodeAddress(), this.trade.getArbitrator().getPubKeyRing(), (NetworkEnvelope)arbitratorRequest, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at arbitrator: offerId={}", (Object)InitTradeRequest.class.getSimpleName(), (Object)TakerSendInitTradeRequestToArbitrator.this.trade.getId());
                    TakerSendInitTradeRequestToArbitrator.this.complete();
                }

                public void onFault(String errorMessage) {
                    log.warn("Failed to send {} to arbitrator, error={}.", (Object)InitTradeRequest.class.getSimpleName(), (Object)errorMessage);
                    TakerSendInitTradeRequestToArbitrator.this.failed();
                }
            });
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }
}

