/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.SellerSendPaymentReceivedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerSendPaymentReceivedMessageToBuyer
extends SellerSendPaymentReceivedMessage {
    private static final Logger log = LoggerFactory.getLogger(SellerSendPaymentReceivedMessageToBuyer.class);

    public SellerSendPaymentReceivedMessageToBuyer(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected TradePeer getReceiver() {
        return this.trade.getBuyer();
    }

    @Override
    protected void setStateSent() {
        this.trade.advanceState(Trade.State.SELLER_SENT_PAYMENT_RECEIVED_MSG);
        super.setStateSent();
    }

    @Override
    protected void setStateFault() {
        this.trade.advanceState(Trade.State.SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG);
        super.setStateFault();
    }

    @Override
    protected void setStateStoredInMailbox() {
        this.trade.advanceState(Trade.State.SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG);
        super.setStateStoredInMailbox();
    }

    @Override
    protected void setStateArrived() {
        this.trade.advanceState(Trade.State.SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG);
        super.setStateArrived();
    }

    @Override
    protected void onFault(String errorMessage, TradeMessage message) {
        this.setStateFault();
        this.appendToErrorMessage("Sending message failed: message=" + String.valueOf((Object)message) + "\nerrorMessage=" + errorMessage);
        this.complete();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SellerSendPaymentReceivedMessageToBuyer)) {
            return false;
        }
        SellerSendPaymentReceivedMessageToBuyer other = (SellerSendPaymentReceivedMessageToBuyer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SellerSendPaymentReceivedMessageToBuyer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

