/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.Sig;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.network.MessageState;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.SendMailboxMessageTask;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.NodeAddress;
import java.security.PrivateKey;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SellerSendPaymentReceivedMessage
extends SendMailboxMessageTask {
    private static final Logger log = LoggerFactory.getLogger(SellerSendPaymentReceivedMessage.class);
    private SignedWitness signedWitness = null;
    private ChangeListener<MessageState> listener;
    private Timer timer;
    private static final int MAX_RESEND_ATTEMPTS = 20;
    private int delayInMin = 10;
    private int resendCounter = 0;
    private String unsignedPayoutTxHex = null;
    private String signedPayoutTxHex = null;
    private String updatedMultisigHex = null;
    private PaymentReceivedMessage message = null;

    public SellerSendPaymentReceivedMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected abstract TradePeer getReceiver();

    @Override
    protected NodeAddress getReceiverNodeAddress() {
        return this.getReceiver().getNodeAddress();
    }

    @Override
    protected PubKeyRing getReceiverPubKeyRing() {
        return this.getReceiver().getPubKeyRing();
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.getReceiver().isPaymentReceivedMessageNacked()) {
                this.getReceiver().setPaymentReceivedMessageState(MessageState.UNDEFINED);
            }
            if (this.stopSending()) {
                if (!this.isCompleted()) {
                    this.complete();
                }
                return;
            }
            this.getReceiver().setPaymentReceivedMessageState(MessageState.UNDEFINED);
            super.run();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    @Override
    protected TradeMailboxMessage getTradeMailboxMessage(String tradeId) {
        if (this.getReceiver().getPaymentReceivedMessage() == null) {
            if (this.trade.getSelf().getPaymentAccountPayload() == null) {
                log.warn("Cannot sign account age witness for {} {} as no payment account is set", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
            } else {
                AccountAgeWitnessService accountAgeWitnessService = this.processModel.getAccountAgeWitnessService();
                if (accountAgeWitnessService.isSignWitnessTrade(this.trade)) {
                    try {
                        accountAgeWitnessService.traderSignAndPublishPeersAccountAgeWitness(this.trade).ifPresent(witness -> {
                            this.signedWitness = witness;
                        });
                        log.info("{} {} signed and published peers account age witness", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                    }
                    catch (Exception e) {
                        log.warn("Failed to sign and publish peer's account age witness for {} {}, error={}\n", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.trade.getId(), e.getMessage(), e});
                    }
                }
            }
            String deterministicId = HavenoUtils.getDeterministicId(this.trade, PaymentReceivedMessage.class, this.getReceiverNodeAddress());
            boolean deferPublishPayout = this.getReceiver() == this.trade.getArbitrator() && (this.trade.isPayoutPublished() || this.trade.getOtherPeer(this.getReceiver()).isPaymentReceivedMessageArrived());
            this.unsignedPayoutTxHex = this.trade.getPayoutTxHex() == null ? this.trade.getSelf().getUnsignedPayoutTxHex() : null;
            this.signedPayoutTxHex = this.trade.getPayoutTxHex();
            this.updatedMultisigHex = this.trade.getSelf().getUpdatedMultisigHex();
            this.message = new PaymentReceivedMessage(tradeId, this.processModel.getMyNodeAddress(), deterministicId, this.unsignedPayoutTxHex, this.signedPayoutTxHex, this.updatedMultisigHex, deferPublishPayout, this.trade.getTradePeer().getAccountAgeWitness(), this.signedWitness, this.getReceiver() == this.trade.getArbitrator() ? this.trade.getBuyer().getPaymentSentMessage() : null, this.trade.getPayoutTxId());
            if (this.trade.isPayoutPublished()) {
                Preconditions.checkArgument((this.message.getUpdatedMultisigHex() != null || this.message.getPayoutTxId() != null ? 1 : 0) != 0, (Object)"PaymentReceivedMessage does not include updated multisig hex or payout tx id after payout published");
            }
            try {
                String messageAsJson = JsonUtil.objectToJson((Object)this.message);
                byte[] sig = Sig.sign((PrivateKey)this.processModel.getP2PService().getKeyRing().getSignatureKeyPair().getPrivate(), (byte[])messageAsJson.getBytes(Charsets.UTF_8));
                this.message.setSellerSignature(sig);
                this.getReceiver().setPaymentReceivedMessage(this.message);
                this.trade.requestPersistence();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getReceiver().getPaymentReceivedMessage();
    }

    @Override
    protected void setStateSent() {
        log.info("{} sent: tradeId={} at peer {} SignedWitness {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness});
        this.getReceiver().setPaymentReceivedMessageState(MessageState.SENT);
        this.tryToSendAgainLater();
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateFault() {
        log.error("{} failed: tradeId={} at peer {} SignedWitness {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness});
        this.getReceiver().setPaymentReceivedMessageState(MessageState.FAILED);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateStoredInMailbox() {
        log.info("{} stored in mailbox: tradeId={} at peer {} SignedWitness {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness});
        this.getReceiver().setPaymentReceivedMessageState(MessageState.STORED_IN_MAILBOX);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateArrived() {
        log.info("{} arrived: tradeId={} at peer {} SignedWitness {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness});
        this.getReceiver().setPaymentReceivedMessageState(MessageState.ARRIVED);
        this.processModel.getTradeManager().requestPersistence();
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.listener != null) {
            this.trade.getBuyer().getPaymentReceivedMessageStateProperty().removeListener(this.listener);
        }
    }

    private void tryToSendAgainLater() {
        if (this.stopSending()) {
            return;
        }
        if (this.resendCounter >= 20) {
            this.cleanup();
            log.warn("We never received an ACK message when sending the PaymentReceivedMessage to the peer. We stop trying to send the message.");
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = UserThread.runAfter(this::run, (long)this.delayInMin, (TimeUnit)TimeUnit.MINUTES);
        if (this.resendCounter == 0) {
            this.listener = (observable, oldValue, newValue) -> this.onMessageStateChange((MessageState)((Object)newValue));
            this.getReceiver().getPaymentReceivedMessageStateProperty().addListener(this.listener);
            this.onMessageStateChange((MessageState)((Object)this.getReceiver().getPaymentReceivedMessageStateProperty().get()));
        }
        if (this.resendCounter == 0) {
            int shortDelay = 2;
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)shortDelay);
            this.timer = UserThread.runAfter(this::run, (long)shortDelay, (TimeUnit)TimeUnit.MINUTES);
        } else {
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)this.delayInMin);
            this.timer = UserThread.runAfter(this::run, (long)this.delayInMin, (TimeUnit)TimeUnit.MINUTES);
            this.delayInMin = (int)((double)this.delayInMin * 1.5);
        }
        ++this.resendCounter;
    }

    private void onMessageStateChange(MessageState newValue) {
        if (this.isMessageReceived()) {
            this.cleanup();
        }
    }

    protected boolean isMessageReceived() {
        return this.getReceiver().isPaymentReceivedMessageReceived();
    }

    protected boolean stopSending() {
        if (this.isMessageReceived()) {
            return true;
        }
        if (!this.trade.isPaymentReceived()) {
            return true;
        }
        if (this.trade.isPayoutPublished() && !((SellerTrade)this.trade).resendPaymentReceivedMessagesWithinDuration()) {
            return true;
        }
        if (this.message != null && !this.message.equals((Object)this.getReceiver().getPaymentReceivedMessage())) {
            return true;
        }
        if (this.unsignedPayoutTxHex != null && !StringUtils.equals((CharSequence)this.unsignedPayoutTxHex, (CharSequence)this.trade.getSelf().getUnsignedPayoutTxHex())) {
            return true;
        }
        if (this.signedPayoutTxHex != null && !StringUtils.equals((CharSequence)this.signedPayoutTxHex, (CharSequence)this.trade.getPayoutTxHex())) {
            return true;
        }
        return this.updatedMultisigHex != null && !StringUtils.equals((CharSequence)this.updatedMultisigHex, (CharSequence)this.trade.getSelf().getUpdatedMultisigHex());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SellerSendPaymentReceivedMessage)) {
            return false;
        }
        SellerSendPaymentReceivedMessage other = (SellerSendPaymentReceivedMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.delayInMin != other.delayInMin) {
            return false;
        }
        if (this.resendCounter != other.resendCounter) {
            return false;
        }
        SignedWitness this$signedWitness = this.signedWitness;
        SignedWitness other$signedWitness = other.signedWitness;
        if (this$signedWitness == null ? other$signedWitness != null : !((Object)this$signedWitness).equals(other$signedWitness)) {
            return false;
        }
        ChangeListener<MessageState> this$listener = this.listener;
        ChangeListener<MessageState> other$listener = other.listener;
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        Timer this$timer = this.timer;
        Timer other$timer = other.timer;
        if (this$timer == null ? other$timer != null : !this$timer.equals(other$timer)) {
            return false;
        }
        String this$unsignedPayoutTxHex = this.unsignedPayoutTxHex;
        String other$unsignedPayoutTxHex = other.unsignedPayoutTxHex;
        if (this$unsignedPayoutTxHex == null ? other$unsignedPayoutTxHex != null : !this$unsignedPayoutTxHex.equals(other$unsignedPayoutTxHex)) {
            return false;
        }
        String this$signedPayoutTxHex = this.signedPayoutTxHex;
        String other$signedPayoutTxHex = other.signedPayoutTxHex;
        if (this$signedPayoutTxHex == null ? other$signedPayoutTxHex != null : !this$signedPayoutTxHex.equals(other$signedPayoutTxHex)) {
            return false;
        }
        String this$updatedMultisigHex = this.updatedMultisigHex;
        String other$updatedMultisigHex = other.updatedMultisigHex;
        if (this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex)) {
            return false;
        }
        PaymentReceivedMessage this$message = this.message;
        PaymentReceivedMessage other$message = other.message;
        return !(this$message == null ? other$message != null : !((Object)((Object)this$message)).equals((Object)other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SellerSendPaymentReceivedMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.delayInMin;
        result = result * 59 + this.resendCounter;
        SignedWitness $signedWitness = this.signedWitness;
        result = result * 59 + ($signedWitness == null ? 43 : ((Object)$signedWitness).hashCode());
        ChangeListener<MessageState> $listener = this.listener;
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        Timer $timer = this.timer;
        result = result * 59 + ($timer == null ? 43 : $timer.hashCode());
        String $unsignedPayoutTxHex = this.unsignedPayoutTxHex;
        result = result * 59 + ($unsignedPayoutTxHex == null ? 43 : $unsignedPayoutTxHex.hashCode());
        String $signedPayoutTxHex = this.signedPayoutTxHex;
        result = result * 59 + ($signedPayoutTxHex == null ? 43 : $signedPayoutTxHex.hashCode());
        String $updatedMultisigHex = this.updatedMultisigHex;
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        PaymentReceivedMessage $message = this.message;
        result = result * 59 + ($message == null ? 43 : ((Object)((Object)$message)).hashCode());
        return result;
    }
}

