/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.Dispute;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerPreparePaymentReceivedMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(SellerPreparePaymentReceivedMessage.class);

    public SellerPreparePaymentReceivedMessage(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        try {
            this.runInterceptHook();
            this.trade.verifyDaemonConnection();
            if (!this.trade.isPayoutPublished()) {
                if (this.trade.getPayoutTxHex() == null) {
                    var1_1 = this.trade.getWalletLock();
                    synchronized (var1_1) {
                        var2_3 = HavenoUtils.getWalletFunctionLock();
                        synchronized (var2_3) {
                            if (this.trade.getPayoutTxHex() == null) {
                                this.trade.importMultisigHex();
                            }
                            if (this.trade.getBuyer().getPaymentSentMessage().getPayoutTxHex() != null && !this.trade.getProcessModel().isPaymentSentPayoutTxStale()) {
                                try {
                                    if (this.trade.getPayoutTxHex() == null) {
                                        log.info("Seller verifying, signing, and publishing payout tx for trade {}", (Object)this.trade.getId());
                                        this.trade.processPayoutTx(this.trade.getBuyer().getPaymentSentMessage().getPayoutTxHex(), true, true);
                                    }
                                    log.warn("Seller publishing previously signed payout tx for trade {}", (Object)this.trade.getId());
                                    this.trade.processPayoutTx(this.trade.getPayoutTxHex(), false, true);
                                }
                                catch (IllegalArgumentException | IllegalStateException e) {
                                    log.warn("Illegal state or argument verifying, signing, and publishing payout tx for {} {}. Creating new unsigned payout tx. error={}. ", new Object[]{this.trade.getClass().getSimpleName(), this.trade.getId(), e.getMessage(), e});
                                    this.createUnsignedPayoutTx();
                                }
                                catch (Exception e) {
                                    log.warn("Error verifying, signing, and publishing payout tx for trade {}: {}", new Object[]{this.trade.getId(), e.getMessage(), e});
                                    throw e;
                                }
                            } else if (this.trade.getSelf().getUnsignedPayoutTxHex() == null) {
                                this.createUnsignedPayoutTx();
                            }
                        }
                    }
                }
                log.info("Seller re-verifying and publishing signed payout tx for trade {}", (Object)this.trade.getId());
                this.trade.processPayoutTx(this.trade.getPayoutTxHex(), false, true);
            } else if (!(this.trade.isPayoutFinalized() || this.trade.getArbitrator().getPaymentReceivedMessage() != null && this.trade.getBuyer().getPaymentReceivedMessage() != null)) {
                var1_1 = this.trade.getWalletLock();
                synchronized (var1_1) {
                    if (this.trade.walletExists()) {
                        var2_3 = HavenoUtils.getWalletFunctionLock();
                        synchronized (var2_3) {
                            this.trade.importMultisigHex();
                            this.trade.exportMultisigHex();
                        }
                    }
                }
            }
            if (this.trade.isPayoutPublished() && this.trade.getDisputeState().ordinal() >= Trade.DisputeState.DISPUTE_PREPARING.ordinal()) {
                this.trade.advanceDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
                for (Dispute dispute : this.trade.getDisputes()) {
                    dispute.setIsClosed();
                }
            }
            this.trade.requestPersistence();
            this.complete();
        }
        catch (Throwable t) {
            if (HavenoUtils.isIllegal(t)) {
                log.error("Illegal exception preparing payment received message in {} {}: {}", new Object[]{this.trade.getClass().getSimpleName(), this.trade.getId(), t.getMessage(), t});
                this.trade.exportMultisigHex();
                this.complete();
            }
            this.failed(t);
        }
    }

    private void createUnsignedPayoutTx() {
        log.info("Seller creating unsigned payout tx for trade {}", (Object)this.trade.getId());
        try {
            this.trade.getProcessModel().setPaymentSentPayoutTxStale(true);
            MoneroTxWallet payoutTx = this.trade.createPayoutTx();
            this.trade.setPayoutTx((MoneroTx)payoutTx);
            this.trade.getSelf().setUnsignedPayoutTxHex(payoutTx.getTxSet().getMultisigTxHex());
        }
        catch (Exception e) {
            if (this.trade.isPayoutPublished()) {
                log.info("Payout tx already published for {} {}", (Object)this.trade.getClass().getName(), (Object)this.trade.getId());
            }
            throw e;
        }
    }
}

