/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import haveno.common.app.Version;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.Hash;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.ScryptUtil;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.SignContractRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Date;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSignContractRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessSignContractRequest.class);
    private boolean ack1 = false;
    private boolean ack2 = false;

    public ProcessSignContractRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            SignContractRequest request = (SignContractRequest)this.processModel.getTradeMessage();
            TradePeer sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
            sender.setDepositTxHash(request.getDepositTxHash());
            sender.setAccountId(request.getAccountId());
            sender.setPaymentAccountPayloadHash(request.getPaymentAccountPayloadHash());
            sender.setPayoutAddressString(request.getPayoutAddress());
            if (sender == this.trade.getMaker()) {
                sender.setAccountAgeWitnessNonce(request.getDepositTxHash().getBytes(Charsets.UTF_8));
                sender.setAccountAgeWitnessSignature(request.getAccountAgeWitnessSignatureOfDepositHash());
            }
            if (this.processModel.getMaker().getPaymentAccountPayloadHash() == null || this.processModel.getTaker().getPaymentAccountPayloadHash() == null) {
                this.complete();
                return;
            }
            Contract contract = this.trade.createContract();
            String contractAsJson = JsonUtil.objectToJson(contract);
            byte[] signature = HavenoUtils.sign(this.processModel.getKeyRing(), contractAsJson);
            this.trade.setContract(contract);
            this.trade.setContractAsJson(contractAsJson);
            this.trade.setContractHash(Hash.getSha256Hash((String)((String)Preconditions.checkNotNull((Object)contractAsJson))));
            this.trade.getSelf().setContractSignature(signature);
            byte[] encryptedPaymentAccountPayload = null;
            if (!this.trade.isArbitrator()) {
                byte[] decryptionKey = ScryptUtil.getKeyCrypterScrypt().deriveKey((CharSequence)UUID.randomUUID().toString()).getKey();
                this.trade.getSelf().setPaymentAccountKey(decryptionKey);
                byte[] unencrypted = this.trade.getSelf().getPaymentAccountPayload().toProtoMessage().toByteArray();
                SecretKey sk = Encryption.getSecretKeyFromBytes((byte[])this.trade.getSelf().getPaymentAccountKey());
                encryptedPaymentAccountPayload = Encryption.encrypt((byte[])unencrypted, (SecretKey)sk);
            }
            final SignContractResponse response = new SignContractResponse(this.trade.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), contractAsJson, signature, encryptedPaymentAccountPayload);
            final NodeAddress recipient1 = this.trade instanceof ArbitratorTrade ? this.trade.getMaker().getNodeAddress() : this.trade.getTradePeer().getNodeAddress();
            PubKeyRing recipient1PubKey = this.trade instanceof ArbitratorTrade ? this.trade.getMaker().getPubKeyRing() : this.trade.getTradePeer().getPubKeyRing();
            final NodeAddress recipient2 = this.trade instanceof ArbitratorTrade ? this.trade.getTaker().getNodeAddress() : null;
            PubKeyRing recipient2PubKey = this.trade instanceof ArbitratorTrade ? this.trade.getTaker().getPubKeyRing() : null;
            this.processModel.getP2PService().sendEncryptedDirectMessage(recipient1, recipient1PubKey, (NetworkEnvelope)response, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived: trading peer={}; offerId={}; uid={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), recipient1, ProcessSignContractRequest.this.trade.getId()});
                    ProcessSignContractRequest.this.ack1 = true;
                    if (ProcessSignContractRequest.this.ack1 && (recipient2 == null || ProcessSignContractRequest.this.ack2)) {
                        ProcessSignContractRequest.this.completeAux();
                    }
                }

                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), recipient1, ProcessSignContractRequest.this.trade.getId(), errorMessage});
                    ProcessSignContractRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf((Object)response) + "\nerrorMessage=" + errorMessage);
                    ProcessSignContractRequest.this.failed();
                }
            });
            if (recipient2 != null) {
                this.processModel.getP2PService().sendEncryptedDirectMessage(recipient2, recipient2PubKey, (NetworkEnvelope)response, new SendDirectMessageListener(){

                    public void onArrived() {
                        log.info("{} arrived: trading peer={}; offerId={}; uid={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), recipient2, ProcessSignContractRequest.this.trade.getId()});
                        ProcessSignContractRequest.this.ack2 = true;
                        if (ProcessSignContractRequest.this.ack1 && ProcessSignContractRequest.this.ack2) {
                            ProcessSignContractRequest.this.completeAux();
                        }
                    }

                    public void onFault(String errorMessage) {
                        log.error("Sending {} failed: uid={}; peer={}; error={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), recipient2, ProcessSignContractRequest.this.trade.getId(), errorMessage});
                        ProcessSignContractRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf((Object)response) + "\nerrorMessage=" + errorMessage);
                        ProcessSignContractRequest.this.failed();
                    }
                });
            }
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    private void completeAux() {
        this.trade.addInitProgressStep();
        this.trade.setState(Trade.State.CONTRACT_SIGNED);
        this.processModel.getTradeManager().requestPersistence();
        this.complete();
    }
}

