/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.sign.SignedWitness;
import haveno.core.support.dispute.Dispute;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPaymentReceivedMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessPaymentReceivedMessage.class);

    public ProcessPaymentReceivedMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            log.debug("current trade state " + String.valueOf((Object)this.trade.getState()));
            PaymentReceivedMessage message = (PaymentReceivedMessage)this.processModel.getTradeMessage();
            Preconditions.checkNotNull((Object)((Object)message));
            Validator.checkTradeId(this.processModel.getOfferId(), message);
            HavenoUtils.verifyPaymentReceivedMessage(this.trade, message);
            this.trade.getSeller().setNodeAddress(this.processModel.getTempTradePeerNodeAddress());
            if (this.trade.getSeller().getNodeAddress().equals((Object)this.trade.getBuyer().getNodeAddress())) {
                this.trade.getBuyer().setNodeAddress(null);
            }
            this.trade.requestPersistence();
            if (this.trade.getPhase().ordinal() >= Trade.Phase.PAYMENT_RECEIVED.ordinal() && this.trade.isPayoutPublished()) {
                log.warn("Received another PaymentReceivedMessage which was already processed, ACKing");
                this.complete();
                return;
            }
            this.trade.advanceState(Trade.State.SELLER_CONFIRMED_PAYMENT_RECEIPT);
            if (!this.trade.isDepositsUnlocked()) {
                this.trade.syncAndPollWallet();
                if (!this.trade.isDepositsUnlocked()) {
                    throw new RuntimeException("Cannot process PaymentReceivedMessage until the trade wallet sees that the deposits are unlocked for " + this.trade.getClass().getSimpleName() + " " + this.trade.getId());
                }
            }
            this.trade.getSeller().setUpdatedMultisigHex(message.getUpdatedMultisigHex());
            this.trade.getBuyer().setAccountAgeWitness(message.getBuyerAccountAgeWitness());
            if (this.trade.isArbitrator() && this.trade.getBuyer().getPaymentSentMessage() == null) {
                Preconditions.checkNotNull((Object)((Object)message.getPaymentSentMessage()), (Object)"PaymentSentMessage is null for arbitrator");
                this.trade.getBuyer().setPaymentSentMessage(message.getPaymentSentMessage());
                this.trade.getBuyer().setUpdatedMultisigHex(message.getPaymentSentMessage().getUpdatedMultisigHex());
            }
            this.trade.requestPersistence();
            if (!this.trade.isPayoutConfirmed()) {
                this.processPayoutTx(message);
            }
            if (this.trade.isPayoutPublished() && this.trade.getDisputeState().isDisputed()) {
                this.trade.advanceDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
                for (Dispute dispute : this.trade.getDisputes()) {
                    dispute.setIsClosed();
                }
            }
            this.trade.advanceState(Trade.State.SELLER_SENT_PAYMENT_RECEIVED_MSG);
            SignedWitness signedWitness = message.getBuyerSignedWitness();
            if (signedWitness != null && this.trade instanceof BuyerTrade) {
                this.processModel.getAccountAgeWitnessService().publishOwnSignedWitness(signedWitness);
            }
            this.trade.requestPersistence();
            this.complete();
        }
        catch (Throwable t) {
            if (HavenoUtils.isIllegal(t)) {
                this.trade.getSeller().setPaymentReceivedMessage(null);
                this.trade.requestPersistence();
            }
            this.failed(t);
        }
    }

    private void processPayoutTx(PaymentReceivedMessage message) {
        this.trade.importMultisigHex();
        this.trade.syncAndPollWallet();
        if (!this.trade.isPayoutPublished()) {
            if (message.getUnsignedPayoutTxHex() == null && message.getSignedPayoutTxHex() == null && message.getPayoutTxId() == null) {
                throw new IllegalStateException("No payout tx provided in PaymentReceivedMessage for " + this.trade.getClass().getSimpleName() + " " + this.trade.getId());
            }
            if (message.isDeferPublishPayout()) {
                log.info("Deferring publishing payout tx for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                if (this.trade instanceof ArbitratorTrade) {
                    this.trade.pollWalletNormallyForMs(60000L);
                }
                for (int i = 0; i < 5 && !this.trade.isPayoutPublished(); ++i) {
                    HavenoUtils.waitFor(5000L);
                }
                if (!this.trade.isPayoutPublished()) {
                    this.trade.syncAndPollWallet();
                }
            }
            if (!this.trade.isPayoutPublished()) {
                try {
                    if (message.getPayoutTxId() != null && this.trade.isBuyer()) {
                        this.trade.processBuyerPayout(message.getPayoutTxId());
                    } else if (message.getSignedPayoutTxHex() != null) {
                        log.info("{} {} publishing signed payout tx from seller", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        this.trade.processPayoutTx(message.getSignedPayoutTxHex(), false, true);
                    } else {
                        PaymentSentMessage paymentSentMessage = (this.trade.isArbitrator() ? this.trade.getBuyer() : this.trade.getArbitrator()).getPaymentSentMessage();
                        if (paymentSentMessage == null) {
                            throw new RuntimeException("Process model does not have payment sent message for " + this.trade.getClass().getSimpleName() + " " + this.trade.getId());
                        }
                        if (this.trade.getPayoutTxHex() == null) {
                            log.info("{} {} verifying, signing, and publishing payout tx", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                            this.trade.processPayoutTx(message.getUnsignedPayoutTxHex(), true, true);
                        } else {
                            log.info("{} {} re-verifying and publishing signed payout tx", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                            this.trade.processPayoutTx(this.trade.getPayoutTxHex(), false, true);
                        }
                    }
                }
                catch (Exception e) {
                    HavenoUtils.waitFor(this.trade.getXmrConnectionService().getRefreshPeriodMs());
                    this.trade.syncAndPollWallet();
                    if (this.trade.isPayoutPublished()) {
                        log.info("Payout tx already published for {} {}", (Object)this.trade.getClass().getName(), (Object)this.trade.getId());
                    }
                    throw e;
                }
            }
        }
    }
}

