/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDepositsConfirmedMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessDepositsConfirmedMessage.class);

    public ProcessDepositsConfirmedMessage(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            DepositsConfirmedMessage request = (DepositsConfirmedMessage)this.processModel.getTradeMessage();
            Preconditions.checkNotNull((Object)((Object)request));
            Validator.checkTradeId(this.processModel.getOfferId(), request);
            TradePeer sender = this.trade.getTradePeer(request.getPubKeyRing());
            if (sender == null) {
                throw new RuntimeException("Pub key ring is not from arbitrator, buyer, or seller");
            }
            sender.setNodeAddress(this.processModel.getTempTradePeerNodeAddress());
            if (sender.getNodeAddress().equals((Object)this.trade.getBuyer().getNodeAddress()) && sender != this.trade.getBuyer()) {
                this.trade.getBuyer().setNodeAddress(null);
            }
            if (sender.getNodeAddress().equals((Object)this.trade.getSeller().getNodeAddress()) && sender != this.trade.getSeller()) {
                this.trade.getSeller().setNodeAddress(null);
            }
            if (sender.getNodeAddress().equals((Object)this.trade.getArbitrator().getNodeAddress()) && sender != this.trade.getArbitrator()) {
                this.trade.getArbitrator().setNodeAddress(null);
            }
            if (request.getSellerPaymentAccountKey() != null && this.trade.getTradePeer().getPaymentAccountPayload() == null) {
                log.info("Decrypting seller payment account payload for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
                this.trade.decryptPeerPaymentAccountPayload(request.getSellerPaymentAccountKey());
            }
            if (sender.getUpdatedMultisigHex() == null) {
                sender.setUpdatedMultisigHex(request.getUpdatedMultisigHex());
                this.trade.scheduleImportMultisigHex();
            }
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }
}

