/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.app.Version;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.availability.DisputeAgentSelection;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakerSendInitTradeRequestToArbitrator
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(MakerSendInitTradeRequestToArbitrator.class);

    public MakerSendInitTradeRequestToArbitrator(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            Arbitrator leastUsedArbitrator = DisputeAgentSelection.getLeastUsedArbitrator(this.processModel.getTradeStatisticsManager(), this.processModel.getArbitratorManager());
            if (leastUsedArbitrator == null) {
                this.failed("Could not get least used arbitrator to send " + InitTradeRequest.class.getSimpleName() + " for offer " + this.trade.getId());
                return;
            }
            this.sendInitTradeRequests(leastUsedArbitrator.getNodeAddress(), new HashSet<NodeAddress>(), () -> {
                this.trade.addInitProgressStep();
                this.complete();
            }, errorMessage -> {
                log.warn("Cannot initialize trade with arbitrators: " + errorMessage);
                this.failed(errorMessage);
            });
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    private void sendInitTradeRequests(final NodeAddress arbitratorNodeAddress, final Set<NodeAddress> excludedArbitrators, final ResultHandler resultHandler, final ErrorMessageHandler errorMessageHandler) {
        this.sendInitTradeRequest(arbitratorNodeAddress, new SendDirectMessageListener(){

            public void onArrived() {
                log.info("{} arrived at arbitrator: offerId={}", (Object)InitTradeRequest.class.getSimpleName(), (Object)MakerSendInitTradeRequestToArbitrator.this.trade.getId());
                if (!MakerSendInitTradeRequestToArbitrator.this.processModel.getTradeManager().hasOpenTrade(MakerSendInitTradeRequestToArbitrator.this.trade)) {
                    errorMessageHandler.handleErrorMessage("Trade protocol no longer exists, tradeId=" + MakerSendInitTradeRequestToArbitrator.this.trade.getId());
                    return;
                }
                resultHandler.handleResult();
            }

            public void onFault(String errorMessage) {
                log.warn("Arbitrator unavailable: address={}, error={}", (Object)arbitratorNodeAddress, (Object)errorMessage);
                excludedArbitrators.add(arbitratorNodeAddress);
                if (!MakerSendInitTradeRequestToArbitrator.this.processModel.getTradeManager().hasOpenTrade(MakerSendInitTradeRequestToArbitrator.this.trade)) {
                    errorMessageHandler.handleErrorMessage("Trade protocol no longer exists, tradeId=" + MakerSendInitTradeRequestToArbitrator.this.trade.getId());
                    return;
                }
                Arbitrator altArbitrator = DisputeAgentSelection.getLeastUsedArbitrator(MakerSendInitTradeRequestToArbitrator.this.processModel.getTradeStatisticsManager(), MakerSendInitTradeRequestToArbitrator.this.processModel.getArbitratorManager(), excludedArbitrators);
                if (altArbitrator == null) {
                    errorMessageHandler.handleErrorMessage("Cannot take offer because no arbitrators are available");
                    return;
                }
                log.info("Using alternative arbitrator {}", (Object)altArbitrator.getNodeAddress());
                MakerSendInitTradeRequestToArbitrator.this.sendInitTradeRequests(altArbitrator.getNodeAddress(), excludedArbitrators, resultHandler, errorMessageHandler);
            }
        });
    }

    private void sendInitTradeRequest(NodeAddress arbitratorNodeAddress, SendDirectMessageListener listener) {
        Arbitrator arbitrator = this.processModel.getUser().getAcceptedArbitratorByAddress(arbitratorNodeAddress);
        if (arbitrator == null) {
            throw new RuntimeException("Node address " + String.valueOf(arbitratorNodeAddress) + " is not a registered arbitrator");
        }
        this.processModel.getArbitrator().setPubKeyRing(arbitrator.getPubKeyRing());
        this.trade.getArbitrator().setNodeAddress(arbitratorNodeAddress);
        this.trade.getArbitrator().setPubKeyRing(this.processModel.getArbitrator().getPubKeyRing());
        InitTradeRequest takerRequest = (InitTradeRequest)this.processModel.getTradeMessage();
        InitTradeRequest arbitratorRequest = new InitTradeRequest(takerRequest.getTradeProtocolVersion(), this.trade.getId(), this.trade.getAmount().longValueExact(), this.trade.getPrice().getValue(), this.trade.getOffer().getOfferPayload().getPaymentMethodId(), this.trade.getProcessModel().getAccountId(), takerRequest.getTakerAccountId(), this.trade.getOffer().getOfferPayload().getMakerPaymentAccountId(), takerRequest.getTakerPaymentAccountId(), this.trade.getTaker().getPubKeyRing(), takerRequest.getUid(), Version.getP2PMessageVersion(), null, this.trade.getTakeOfferDate().getTime(), this.trade.getMaker().getNodeAddress(), this.trade.getTaker().getNodeAddress(), this.trade.getArbitrator().getNodeAddress(), this.trade.getSelf().getReserveTxHash(), this.trade.getSelf().getReserveTxHex(), this.trade.getSelf().getReserveTxKey(), ((Trade)this.model).getXmrWalletService().getOrCreateAddressEntry(this.trade.getOffer().getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString(), this.trade.getChallenge());
        log.info("Sending {} with offerId {} and uid {} to arbitrator {}", new Object[]{((Object)((Object)arbitratorRequest)).getClass().getSimpleName(), arbitratorRequest.getOfferId(), arbitratorRequest.getUid(), this.trade.getArbitrator().getNodeAddress()});
        this.processModel.getP2PService().sendEncryptedDirectMessage(arbitratorNodeAddress, arbitrator.getPubKeyRing(), (NetworkEnvelope)arbitratorRequest, listener, Integer.valueOf(60));
    }
}

