/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.xmr.model.XmrAddressEntry;
import java.math.BigInteger;
import monero.common.MoneroRpcConnection;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakerRecreateReserveTx
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(MakerRecreateReserveTx.class);

    public MakerRecreateReserveTx(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        try {
            this.runInterceptHook();
            if (!(this.trade instanceof MakerTrade)) {
                throw new RuntimeException("Expected maker trade but was " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + ". That should never happen.");
            }
            OpenOffer openOffer = HavenoUtils.openOfferManager.getOpenOffer(this.trade.getOffer().getId()).orElse(null);
            if (openOffer == null) {
                throw new RuntimeException("Open offer not found for " + this.trade.getClass().getSimpleName() + " " + this.trade.getId());
            }
            Offer offer = openOffer.getOffer();
            this.trade.getSelf().setReserveTxHex(null);
            this.trade.getSelf().setReserveTxHash(null);
            this.trade.getSelf().setReserveTxKey(null);
            this.trade.getSelf().setReserveTxKeyImages(null);
            log.warn("Maker is recreating reserve tx for tradeId={}", (Object)this.trade.getShortId());
            MoneroTxWallet reserveTx = null;
            Object object = HavenoUtils.xmrWalletService.getWalletLock();
            synchronized (object) {
                if (this.isTimedOut()) {
                    throw new RuntimeException("Trade protocol has timed out while getting lock to create reserve tx, tradeId=" + this.trade.getShortId());
                }
                this.trade.startProtocolTimeout();
                log.info("Thawing reserve tx key images for tradeId={}", (Object)this.trade.getShortId());
                HavenoUtils.xmrWalletService.thawOutputs(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages());
                if (this.isTimedOut()) {
                    throw new RuntimeException("Trade protocol has timed out while thawing key images, tradeId=" + this.trade.getShortId());
                }
                this.trade.startProtocolTimeout();
                BigInteger makerFee = offer.getMaxMakerFee();
                BigInteger sendAmount = offer.getDirection() == OfferDirection.BUY ? BigInteger.ZERO : offer.getAmount();
                BigInteger securityDeposit = offer.getDirection() == OfferDirection.BUY ? offer.getMaxBuyerSecurityDeposit() : offer.getMaxSellerSecurityDeposit();
                BigInteger penaltyFee = HavenoUtils.multiply(securityDeposit, offer.getPenaltyFeePct());
                String returnAddress = ((Trade)this.model).getXmrWalletService().getAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString();
                XmrAddressEntry fundingEntry = ((Trade)this.model).getXmrWalletService().getAddressEntry(offer.getId(), XmrAddressEntry.Context.OFFER_FUNDING).orElse(null);
                Integer preferredSubaddressIndex = fundingEntry == null ? null : Integer.valueOf(fundingEntry.getSubaddressIndex());
                try {
                    Object object2 = HavenoUtils.getWalletFunctionLock();
                    synchronized (object2) {
                        for (int i = 0; i < 5; ++i) {
                            MoneroRpcConnection sourceConnection = this.trade.getXmrConnectionService().getConnection();
                            try {
                                reserveTx = ((Trade)this.model).getXmrWalletService().createReserveTx(penaltyFee, makerFee, sendAmount, securityDeposit, returnAddress, openOffer.isReserveExactAmount(), preferredSubaddressIndex);
                            }
                            catch (IllegalStateException e) {
                                log.warn("Illegal state creating reserve tx, tradeId={}, error={}", new Object[]{this.trade.getShortId(), i + 1, e.getMessage()});
                                throw e;
                            }
                            catch (Exception e) {
                                log.warn("Error creating reserve tx, tradeId={}, attempt={}/{}, error={}", new Object[]{this.trade.getShortId(), i + 1, 5, e.getMessage()});
                                this.trade.getXmrWalletService().handleWalletError(e, sourceConnection, i + 1);
                                if (this.isTimedOut()) {
                                    throw new RuntimeException("Trade protocol has timed out while creating reserve tx, tradeId=" + this.trade.getShortId());
                                }
                                if (i == 4) {
                                    throw e;
                                }
                                HavenoUtils.waitFor(5000L);
                            }
                            if (this.isTimedOut()) {
                                throw new RuntimeException("Trade protocol has timed out while creating reserve tx, tradeId=" + this.trade.getShortId());
                            }
                            if (reserveTx != null) break;
                        }
                    }
                }
                catch (Exception e) {
                    if (reserveTx != null) {
                        ((Trade)this.model).getXmrWalletService().thawOutputs(HavenoUtils.getInputKeyImages(reserveTx));
                    }
                    ((Trade)this.model).getXmrWalletService().freezeOutputs(offer.getOfferPayload().getReserveTxKeyImages());
                    this.trade.getSelf().setReserveTxKeyImages(null);
                    throw e;
                }
                this.trade.startProtocolTimeout();
                this.trade.getSelf().setReserveTxHash(reserveTx.getHash());
                this.trade.getSelf().setReserveTxHex(reserveTx.getFullHex());
                this.trade.getSelf().setReserveTxKey(reserveTx.getKey());
                this.trade.getSelf().setReserveTxKeyImages(HavenoUtils.getInputKeyImages(reserveTx));
                this.trade.getXmrWalletService().freezeOutputs(HavenoUtils.getInputKeyImages(reserveTx));
            }
            this.processModel.setReserveTx(reserveTx);
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
        }
        catch (Throwable t) {
            this.trade.setErrorMessage("An error occurred.\nError message:\n" + t.getMessage());
            this.failed(t);
        }
    }

    private boolean isTimedOut() {
        return !this.processModel.getTradeManager().hasOpenTrade(this.trade);
    }
}

