/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.BuyerSendPaymentSentMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuyerSendPaymentSentMessageToSeller
extends BuyerSendPaymentSentMessage {
    private static final Logger log = LoggerFactory.getLogger(BuyerSendPaymentSentMessageToSeller.class);

    public BuyerSendPaymentSentMessageToSeller(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected TradePeer getReceiver() {
        return this.trade.getSeller();
    }

    @Override
    protected void setStateSent() {
        if (this.trade.getState().ordinal() < Trade.State.BUYER_SENT_PAYMENT_SENT_MSG.ordinal()) {
            this.trade.setStateIfValidTransitionTo(Trade.State.BUYER_SENT_PAYMENT_SENT_MSG);
        }
        super.setStateSent();
    }

    @Override
    protected void setStateArrived() {
        this.trade.setStateIfValidTransitionTo(Trade.State.BUYER_SAW_ARRIVED_PAYMENT_SENT_MSG);
        super.setStateArrived();
    }

    @Override
    protected void setStateStoredInMailbox() {
        this.trade.setStateIfValidTransitionTo(Trade.State.BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG);
        super.setStateStoredInMailbox();
    }

    @Override
    protected void setStateFault() {
        this.trade.setStateIfValidTransitionTo(Trade.State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG);
        super.setStateFault();
    }

    @Override
    protected void onFault(String errorMessage, TradeMessage message) {
        this.setStateFault();
        this.appendToErrorMessage("Sending message failed: message=" + String.valueOf((Object)message) + "\nerrorMessage=" + errorMessage);
        this.complete();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuyerSendPaymentSentMessageToSeller)) {
            return false;
        }
        BuyerSendPaymentSentMessageToSeller other = (BuyerSendPaymentSentMessageToSeller)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuyerSendPaymentSentMessageToSeller;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

